import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataUpcloudKubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Cluster ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/kubernetes_cluster#id DataUpcloudKubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/d/kubernetes_cluster upcloud_kubernetes_cluster}
*/
export declare class DataUpcloudKubernetesCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "upcloud_kubernetes_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/d/kubernetes_cluster upcloud_kubernetes_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataUpcloudKubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataUpcloudKubernetesClusterConfig);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get kubeconfig(): string;
    get name(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
