import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#id KubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Cluster name. Needs to be unique within the account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#name KubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Network ID for the cluster to run in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#network KubernetesCluster#network}
    */
    readonly network: string;
    /**
    * Zone in which the Kubernetes cluster will be hosted, e.g. `de-fra1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#zone KubernetesCluster#zone}
    */
    readonly zone: string;
    /**
    * node_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#node_group KubernetesCluster#node_group}
    */
    readonly nodeGroup: KubernetesClusterNodeGroup[] | cdktf.IResolvable;
}
export interface KubernetesClusterNodeGroupTaint {
    /**
    * Taint effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#effect KubernetesCluster#effect}
    */
    readonly effect: string;
    /**
    * Taint key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#key KubernetesCluster#key}
    */
    readonly key: string;
    /**
    * Taint value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#value KubernetesCluster#value}
    */
    readonly value: string;
}
export declare function kubernetesClusterNodeGroupTaintToTerraform(struct?: KubernetesClusterNodeGroupTaint | cdktf.IResolvable): any;
export declare class KubernetesClusterNodeGroupTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterNodeGroupTaint | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterNodeGroupTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class KubernetesClusterNodeGroupTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterNodeGroupTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterNodeGroupTaintOutputReference;
}
export interface KubernetesClusterNodeGroup {
    /**
    * Amount of nodes to provision in the node group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#count KubernetesCluster#count}
    */
    readonly count?: number;
    /**
    * Additional arguments for kubelet for the nodes in this group. WARNING - those arguments will be passed directly to kubelet CLI on each worker node without any validation. Passing invalid arguments can break your whole cluster. Be extra careful when adding kubelet args.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#kubelet_args KubernetesCluster#kubelet_args}
    */
    readonly kubeletArgs?: {
        [key: string]: string;
    };
    /**
    * Key-value pairs to classify the node group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#labels KubernetesCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the node group. Needs to be unique within a cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#name KubernetesCluster#name}
    */
    readonly name: string;
    /**
    * The pricing plan used for the node group. Valid values available via `upcloud_kubernetes_plan` datasource field `description`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#plan KubernetesCluster#plan}
    */
    readonly plan?: string;
    /**
    * You can optionally select SSH keys to be added as authorized keys to the nodes in this node group. This allows you to connect to the nodes via SSH once they are running.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#ssh_keys KubernetesCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * taint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster#taint KubernetesCluster#taint}
    */
    readonly taint?: KubernetesClusterNodeGroupTaint[] | cdktf.IResolvable;
}
export declare function kubernetesClusterNodeGroupToTerraform(struct?: KubernetesClusterNodeGroup | cdktf.IResolvable): any;
export declare class KubernetesClusterNodeGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterNodeGroup | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterNodeGroup | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _kubeletArgs?;
    get kubeletArgs(): {
        [key: string]: string;
    };
    set kubeletArgs(value: {
        [key: string]: string;
    });
    resetKubeletArgs(): void;
    get kubeletArgsInput(): {
        [key: string]: string;
    } | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    resetPlan(): void;
    get planInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _taint;
    get taint(): KubernetesClusterNodeGroupTaintList;
    putTaint(value: KubernetesClusterNodeGroupTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | KubernetesClusterNodeGroupTaint[] | undefined;
}
export declare class KubernetesClusterNodeGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterNodeGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterNodeGroupOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster upcloud_kubernetes_cluster}
*/
export declare class KubernetesCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_kubernetes_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/kubernetes_cluster upcloud_kubernetes_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesClusterConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    get networkCidr(): string;
    get state(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _nodeGroup;
    get nodeGroup(): KubernetesClusterNodeGroupList;
    putNodeGroup(value: KubernetesClusterNodeGroup[] | cdktf.IResolvable): void;
    get nodeGroupInput(): cdktf.IResolvable | KubernetesClusterNodeGroup[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
