"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadbalancerResolver = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver upcloud_loadbalancer_resolver}
*/
class LoadbalancerResolver extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver upcloud_loadbalancer_resolver} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerResolverConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'upcloud_loadbalancer_resolver',
            terraformGeneratorMetadata: {
                providerName: 'upcloud',
                providerVersion: '2.7.1',
                providerVersionConstraint: '~> 2.4'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._cacheInvalid = config.cacheInvalid;
        this._cacheValid = config.cacheValid;
        this._id = config.id;
        this._loadbalancer = config.loadbalancer;
        this._name = config.name;
        this._nameservers = config.nameservers;
        this._retries = config.retries;
        this._timeout = config.timeout;
        this._timeoutRetry = config.timeoutRetry;
    }
    get cacheInvalid() {
        return this.getNumberAttribute('cache_invalid');
    }
    set cacheInvalid(value) {
        this._cacheInvalid = value;
    }
    // Temporarily expose input value. Use with caution.
    get cacheInvalidInput() {
        return this._cacheInvalid;
    }
    get cacheValid() {
        return this.getNumberAttribute('cache_valid');
    }
    set cacheValid(value) {
        this._cacheValid = value;
    }
    // Temporarily expose input value. Use with caution.
    get cacheValidInput() {
        return this._cacheValid;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get loadbalancer() {
        return this.getStringAttribute('loadbalancer');
    }
    set loadbalancer(value) {
        this._loadbalancer = value;
    }
    // Temporarily expose input value. Use with caution.
    get loadbalancerInput() {
        return this._loadbalancer;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nameservers() {
        return this.getListAttribute('nameservers');
    }
    set nameservers(value) {
        this._nameservers = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameserversInput() {
        return this._nameservers;
    }
    get retries() {
        return this.getNumberAttribute('retries');
    }
    set retries(value) {
        this._retries = value;
    }
    // Temporarily expose input value. Use with caution.
    get retriesInput() {
        return this._retries;
    }
    get timeout() {
        return this.getNumberAttribute('timeout');
    }
    set timeout(value) {
        this._timeout = value;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutInput() {
        return this._timeout;
    }
    get timeoutRetry() {
        return this.getNumberAttribute('timeout_retry');
    }
    set timeoutRetry(value) {
        this._timeoutRetry = value;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutRetryInput() {
        return this._timeoutRetry;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cache_invalid: cdktf.numberToTerraform(this._cacheInvalid),
            cache_valid: cdktf.numberToTerraform(this._cacheValid),
            id: cdktf.stringToTerraform(this._id),
            loadbalancer: cdktf.stringToTerraform(this._loadbalancer),
            name: cdktf.stringToTerraform(this._name),
            nameservers: cdktf.listMapper(cdktf.stringToTerraform, false)(this._nameservers),
            retries: cdktf.numberToTerraform(this._retries),
            timeout: cdktf.numberToTerraform(this._timeout),
            timeout_retry: cdktf.numberToTerraform(this._timeoutRetry),
        };
    }
}
exports.LoadbalancerResolver = LoadbalancerResolver;
_a = JSII_RTTI_SYMBOL_1;
LoadbalancerResolver[_a] = { fqn: "@cdktf/provider-upcloud.loadbalancerResolver.LoadbalancerResolver", version: "4.0.2" };
// =================
// STATIC PROPERTIES
// =================
LoadbalancerResolver.tfResourceType = "upcloud_loadbalancer_resolver";
//# sourceMappingURL=data:application/json;base64,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