import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The service configured status indicates the service's current intended status. Managed by the customer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#configured_status Loadbalancer#configured_status}
    */
    readonly configuredStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#id Loadbalancer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the service must be unique within customer account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#name Loadbalancer#name}
    */
    readonly name: string;
    /**
    * Private network UUID where traffic will be routed. Must reside in load balancer zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#network Loadbalancer#network}
    */
    readonly network?: string;
    /**
    * Plan which the service will have
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#plan Loadbalancer#plan}
    */
    readonly plan: string;
    /**
    * Zone in which the service will be hosted, e.g. `fi-hel1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#zone Loadbalancer#zone}
    */
    readonly zone: string;
    /**
    * networks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#networks Loadbalancer#networks}
    */
    readonly networks?: LoadbalancerNetworks[] | cdktf.IResolvable;
}
export interface LoadbalancerNodesNetworksIpAddresses {
}
export declare function loadbalancerNodesNetworksIpAddressesToTerraform(struct?: LoadbalancerNodesNetworksIpAddresses): any;
export declare class LoadbalancerNodesNetworksIpAddressesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerNodesNetworksIpAddresses | undefined;
    set internalValue(value: LoadbalancerNodesNetworksIpAddresses | undefined);
    get address(): string;
    get listen(): cdktf.IResolvable;
}
export declare class LoadbalancerNodesNetworksIpAddressesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerNodesNetworksIpAddressesOutputReference;
}
export interface LoadbalancerNodesNetworks {
}
export declare function loadbalancerNodesNetworksToTerraform(struct?: LoadbalancerNodesNetworks): any;
export declare class LoadbalancerNodesNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerNodesNetworks | undefined;
    set internalValue(value: LoadbalancerNodesNetworks | undefined);
    private _ipAddresses;
    get ipAddresses(): LoadbalancerNodesNetworksIpAddressesList;
    get name(): string;
    get type(): string;
}
export declare class LoadbalancerNodesNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerNodesNetworksOutputReference;
}
export interface LoadbalancerNodes {
}
export declare function loadbalancerNodesToTerraform(struct?: LoadbalancerNodes): any;
export declare class LoadbalancerNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerNodes | undefined;
    set internalValue(value: LoadbalancerNodes | undefined);
    private _networks;
    get networks(): LoadbalancerNodesNetworksList;
    get operationalState(): string;
}
export declare class LoadbalancerNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerNodesOutputReference;
}
export interface LoadbalancerNetworks {
    /**
    * Network family. Currently only `IPv4` is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#family Loadbalancer#family}
    */
    readonly family: string;
    /**
    * The name of the network must be unique within the service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#name Loadbalancer#name}
    */
    readonly name: string;
    /**
    * Private network UUID. Required for private networks and must reside in loadbalancer zone. For public network the field should be omitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#network Loadbalancer#network}
    */
    readonly network?: string;
    /**
    * The type of the network. Only one public network can be attached and at least one private network must be attached.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#type Loadbalancer#type}
    */
    readonly type: string;
}
export declare function loadbalancerNetworksToTerraform(struct?: LoadbalancerNetworks | cdktf.IResolvable): any;
export declare class LoadbalancerNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerNetworks | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerNetworks | cdktf.IResolvable | undefined);
    get dnsName(): string;
    private _family?;
    get family(): string;
    set family(value: string);
    get familyInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class LoadbalancerNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerNetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerNetworksOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer upcloud_loadbalancer}
*/
export declare class Loadbalancer extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer upcloud_loadbalancer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerConfig);
    get backends(): string[];
    private _configuredStatus?;
    get configuredStatus(): string;
    set configuredStatus(value: string);
    resetConfiguredStatus(): void;
    get configuredStatusInput(): string | undefined;
    get dnsName(): string;
    get frontends(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _nodes;
    get nodes(): LoadbalancerNodesList;
    get operationalState(): string;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    get resolvers(): string[];
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _networks;
    get networks(): LoadbalancerNetworksList;
    putNetworks(value: LoadbalancerNetworks[] | cdktf.IResolvable): void;
    resetNetworks(): void;
    get networksInput(): cdktf.IResolvable | LoadbalancerNetworks[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
