import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedDatabaseMysqlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#id ManagedDatabaseMysql#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Maintenance window day of week. Lower case weekday name (monday, tuesday, ...)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#maintenance_window_dow ManagedDatabaseMysql#maintenance_window_dow}
    */
    readonly maintenanceWindowDow?: string;
    /**
    * Maintenance window UTC time in hh:mm:ss format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#maintenance_window_time ManagedDatabaseMysql#maintenance_window_time}
    */
    readonly maintenanceWindowTime?: string;
    /**
    * Name of the service. The name is used as a prefix for the logical hostname. Must be unique within an account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#name ManagedDatabaseMysql#name}
    */
    readonly name: string;
    /**
    * Service plan to use. This determines how much resources the instance will have
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#plan ManagedDatabaseMysql#plan}
    */
    readonly plan: string;
    /**
    * The administrative power state of the service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#powered ManagedDatabaseMysql#powered}
    */
    readonly powered?: boolean | cdktf.IResolvable;
    /**
    * Title of a managed database instance
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#title ManagedDatabaseMysql#title}
    */
    readonly title?: string;
    /**
    * Zone where the instance resides
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#zone ManagedDatabaseMysql#zone}
    */
    readonly zone: string;
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#properties ManagedDatabaseMysql#properties}
    */
    readonly properties?: ManagedDatabaseMysqlProperties;
}
export interface ManagedDatabaseMysqlComponents {
}
export declare function managedDatabaseMysqlComponentsToTerraform(struct?: ManagedDatabaseMysqlComponents): any;
export declare class ManagedDatabaseMysqlComponentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedDatabaseMysqlComponents | undefined;
    set internalValue(value: ManagedDatabaseMysqlComponents | undefined);
    get component(): string;
    get host(): string;
    get port(): number;
    get route(): string;
    get usage(): string;
}
export declare class ManagedDatabaseMysqlComponentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedDatabaseMysqlComponentsOutputReference;
}
export interface ManagedDatabaseMysqlNodeStates {
}
export declare function managedDatabaseMysqlNodeStatesToTerraform(struct?: ManagedDatabaseMysqlNodeStates): any;
export declare class ManagedDatabaseMysqlNodeStatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedDatabaseMysqlNodeStates | undefined;
    set internalValue(value: ManagedDatabaseMysqlNodeStates | undefined);
    get name(): string;
    get role(): string;
    get state(): string;
}
export declare class ManagedDatabaseMysqlNodeStatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedDatabaseMysqlNodeStatesOutputReference;
}
export interface ManagedDatabaseMysqlPropertiesMigration {
    /**
    * Database name for bootstrapping the initial connection
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#dbname ManagedDatabaseMysql#dbname}
    */
    readonly dbname?: string;
    /**
    * Hostname or IP address of the server where to migrate data from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#host ManagedDatabaseMysql#host}
    */
    readonly host?: string;
    /**
    * Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#ignore_dbs ManagedDatabaseMysql#ignore_dbs}
    */
    readonly ignoreDbs?: string;
    /**
    * Password for authentication with the server where to migrate data from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#password ManagedDatabaseMysql#password}
    */
    readonly password?: string;
    /**
    * Port number of the server where to migrate data from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#port ManagedDatabaseMysql#port}
    */
    readonly port?: number;
    /**
    * The server where to migrate data from is secured with SSL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#ssl ManagedDatabaseMysql#ssl}
    */
    readonly ssl?: boolean | cdktf.IResolvable;
    /**
    * User name for authentication with the server where to migrate data from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#username ManagedDatabaseMysql#username}
    */
    readonly username?: string;
}
export declare function managedDatabaseMysqlPropertiesMigrationToTerraform(struct?: ManagedDatabaseMysqlPropertiesMigrationOutputReference | ManagedDatabaseMysqlPropertiesMigration): any;
export declare class ManagedDatabaseMysqlPropertiesMigrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDatabaseMysqlPropertiesMigration | undefined;
    set internalValue(value: ManagedDatabaseMysqlPropertiesMigration | undefined);
    private _dbname?;
    get dbname(): string;
    set dbname(value: string);
    resetDbname(): void;
    get dbnameInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _ignoreDbs?;
    get ignoreDbs(): string;
    set ignoreDbs(value: string);
    resetIgnoreDbs(): void;
    get ignoreDbsInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _ssl?;
    get ssl(): boolean | cdktf.IResolvable;
    set ssl(value: boolean | cdktf.IResolvable);
    resetSsl(): void;
    get sslInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export interface ManagedDatabaseMysqlProperties {
    /**
    * Custom password for admin user. Defaults to random string. This must be set only when a new service is being created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#admin_password ManagedDatabaseMysql#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Custom username for admin user. This must be set only when a new service is being created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#admin_username ManagedDatabaseMysql#admin_username}
    */
    readonly adminUsername?: string;
    /**
    * Automatic utility network IP Filter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#automatic_utility_network_ip_filter ManagedDatabaseMysql#automatic_utility_network_ip_filter}
    */
    readonly automaticUtilityNetworkIpFilter?: boolean | cdktf.IResolvable;
    /**
    * The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#backup_hour ManagedDatabaseMysql#backup_hour}
    */
    readonly backupHour?: number;
    /**
    * The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#backup_minute ManagedDatabaseMysql#backup_minute}
    */
    readonly backupMinute?: number;
    /**
    * The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default for example if using the MySQL Debezium Kafka connector.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#binlog_retention_period ManagedDatabaseMysql#binlog_retention_period}
    */
    readonly binlogRetentionPeriod?: number;
    /**
    * The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#connect_timeout ManagedDatabaseMysql#connect_timeout}
    */
    readonly connectTimeout?: number;
    /**
    * Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or `SYSTEM` to use the MySQL server default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#default_time_zone ManagedDatabaseMysql#default_time_zone}
    */
    readonly defaultTimeZone?: string;
    /**
    * The maximum permitted result length in bytes for the `GROUP_CONCAT()` function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#group_concat_max_len ManagedDatabaseMysql#group_concat_max_len}
    */
    readonly groupConcatMaxLen?: number;
    /**
    * The time, in seconds, before cached statistics expire.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#information_schema_stats_expiry ManagedDatabaseMysql#information_schema_stats_expiry}
    */
    readonly informationSchemaStatsExpiry?: number;
    /**
    * Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_change_buffer_max_size ManagedDatabaseMysql#innodb_change_buffer_max_size}
    */
    readonly innodbChangeBufferMaxSize?: number;
    /**
    * Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed,  1 - flush contiguous dirty pages in the same extent,  2 - flush dirty pages in the same extent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_flush_neighbors ManagedDatabaseMysql#innodb_flush_neighbors}
    */
    readonly innodbFlushNeighbors?: number;
    /**
    * Minimum length of words that are stored in an InnoDB `FULLTEXT` index.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_ft_min_token_size ManagedDatabaseMysql#innodb_ft_min_token_size}
    */
    readonly innodbFtMinTokenSize?: number;
    /**
    * This option is used to specify your own InnoDB `FULLTEXT` index stopword list for all InnoDB tables.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_ft_server_stopword_table ManagedDatabaseMysql#innodb_ft_server_stopword_table}
    */
    readonly innodbFtServerStopwordTable?: string;
    /**
    * The length of time in seconds an InnoDB transaction waits for a row lock before giving up.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_lock_wait_timeout ManagedDatabaseMysql#innodb_lock_wait_timeout}
    */
    readonly innodbLockWaitTimeout?: number;
    /**
    * The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_log_buffer_size ManagedDatabaseMysql#innodb_log_buffer_size}
    */
    readonly innodbLogBufferSize?: number;
    /**
    * The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_online_alter_log_max_size ManagedDatabaseMysql#innodb_online_alter_log_max_size}
    */
    readonly innodbOnlineAlterLogMaxSize?: number;
    /**
    * When enabled, information about all deadlocks in InnoDB user transactions is recorded in the error log. Disabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_print_all_deadlocks ManagedDatabaseMysql#innodb_print_all_deadlocks}
    */
    readonly innodbPrintAllDeadlocks?: boolean | cdktf.IResolvable;
    /**
    * The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_read_io_threads ManagedDatabaseMysql#innodb_read_io_threads}
    */
    readonly innodbReadIoThreads?: number;
    /**
    * When enabled a transaction timeout causes InnoDB to abort and roll back the entire transaction.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_rollback_on_timeout ManagedDatabaseMysql#innodb_rollback_on_timeout}
    */
    readonly innodbRollbackOnTimeout?: boolean | cdktf.IResolvable;
    /**
    * Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_thread_concurrency ManagedDatabaseMysql#innodb_thread_concurrency}
    */
    readonly innodbThreadConcurrency?: number;
    /**
    * The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#innodb_write_io_threads ManagedDatabaseMysql#innodb_write_io_threads}
    */
    readonly innodbWriteIoThreads?: number;
    /**
    * The number of seconds the server waits for activity on an interactive connection before closing it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#interactive_timeout ManagedDatabaseMysql#interactive_timeout}
    */
    readonly interactiveTimeout?: number;
    /**
    * The storage engine for in-memory internal temporary tables.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#internal_tmp_mem_storage_engine ManagedDatabaseMysql#internal_tmp_mem_storage_engine}
    */
    readonly internalTmpMemStorageEngine?: string;
    /**
    * IP filter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#ip_filter ManagedDatabaseMysql#ip_filter}
    */
    readonly ipFilter?: string[];
    /**
    * The `slow_query_logs` work as SQL statements that take more than `long_query_time` seconds to execute. Default is `10s`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#long_query_time ManagedDatabaseMysql#long_query_time}
    */
    readonly longQueryTime?: number;
    /**
    * Size of the largest message in bytes that can be received by the server. Default is `67108864` (64M)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#max_allowed_packet ManagedDatabaseMysql#max_allowed_packet}
    */
    readonly maxAllowedPacket?: number;
    /**
    * Limits the size of internal in-memory tables. Also set `tmp_table_size`. Default is `16777216` (16M)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#max_heap_table_size ManagedDatabaseMysql#max_heap_table_size}
    */
    readonly maxHeapTableSize?: number;
    /**
    * Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#net_buffer_length ManagedDatabaseMysql#net_buffer_length}
    */
    readonly netBufferLength?: number;
    /**
    * The number of seconds to wait for more data from a connection before aborting the read.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#net_read_timeout ManagedDatabaseMysql#net_read_timeout}
    */
    readonly netReadTimeout?: number;
    /**
    * The number of seconds to wait for a block to be written to a connection before aborting the write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#net_write_timeout ManagedDatabaseMysql#net_write_timeout}
    */
    readonly netWriteTimeout?: number;
    /**
    * Public access allows connections to your Managed Database services via the public internet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#public_access ManagedDatabaseMysql#public_access}
    */
    readonly publicAccess?: boolean | cdktf.IResolvable;
    /**
    * Slow query log enables capturing of slow queries. Setting `slow_query_log` to false also truncates the `mysql.slow_log` table. Default is off
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#slow_query_log ManagedDatabaseMysql#slow_query_log}
    */
    readonly slowQueryLog?: boolean | cdktf.IResolvable;
    /**
    * Sort buffer size in bytes for `ORDER BY` optimization. Default is `262144` (256K)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#sort_buffer_size ManagedDatabaseMysql#sort_buffer_size}
    */
    readonly sortBufferSize?: number;
    /**
    * Global SQL mode. Set to empty to use MySQL server defaults.
              When creating a new service and not setting this field default SQL mode (strict, SQL standard compliant) will be assigned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#sql_mode ManagedDatabaseMysql#sql_mode}
    */
    readonly sqlMode?: string;
    /**
    * Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing.
              It is recommended to always have primary keys because various functionality may break if any large table is missing them.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#sql_require_primary_key ManagedDatabaseMysql#sql_require_primary_key}
    */
    readonly sqlRequirePrimaryKey?: boolean | cdktf.IResolvable;
    /**
    * Limits the size of internal in-memory tables. Also set `max_heap_table_size`. Default is `16777216` (16M)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#tmp_table_size ManagedDatabaseMysql#tmp_table_size}
    */
    readonly tmpTableSize?: number;
    /**
    * MySQL major version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#version ManagedDatabaseMysql#version}
    */
    readonly version?: string;
    /**
    * The number of seconds the server waits for activity on a noninteractive connection before closing it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#wait_timeout ManagedDatabaseMysql#wait_timeout}
    */
    readonly waitTimeout?: number;
    /**
    * migration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql#migration ManagedDatabaseMysql#migration}
    */
    readonly migration?: ManagedDatabaseMysqlPropertiesMigration;
}
export declare function managedDatabaseMysqlPropertiesToTerraform(struct?: ManagedDatabaseMysqlPropertiesOutputReference | ManagedDatabaseMysqlProperties): any;
export declare class ManagedDatabaseMysqlPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDatabaseMysqlProperties | undefined;
    set internalValue(value: ManagedDatabaseMysqlProperties | undefined);
    get additionalBackupRegions(): string[];
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    resetAdminUsername(): void;
    get adminUsernameInput(): string | undefined;
    private _automaticUtilityNetworkIpFilter?;
    get automaticUtilityNetworkIpFilter(): boolean | cdktf.IResolvable;
    set automaticUtilityNetworkIpFilter(value: boolean | cdktf.IResolvable);
    resetAutomaticUtilityNetworkIpFilter(): void;
    get automaticUtilityNetworkIpFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _backupHour?;
    get backupHour(): number;
    set backupHour(value: number);
    resetBackupHour(): void;
    get backupHourInput(): number | undefined;
    private _backupMinute?;
    get backupMinute(): number;
    set backupMinute(value: number);
    resetBackupMinute(): void;
    get backupMinuteInput(): number | undefined;
    private _binlogRetentionPeriod?;
    get binlogRetentionPeriod(): number;
    set binlogRetentionPeriod(value: number);
    resetBinlogRetentionPeriod(): void;
    get binlogRetentionPeriodInput(): number | undefined;
    private _connectTimeout?;
    get connectTimeout(): number;
    set connectTimeout(value: number);
    resetConnectTimeout(): void;
    get connectTimeoutInput(): number | undefined;
    private _defaultTimeZone?;
    get defaultTimeZone(): string;
    set defaultTimeZone(value: string);
    resetDefaultTimeZone(): void;
    get defaultTimeZoneInput(): string | undefined;
    private _groupConcatMaxLen?;
    get groupConcatMaxLen(): number;
    set groupConcatMaxLen(value: number);
    resetGroupConcatMaxLen(): void;
    get groupConcatMaxLenInput(): number | undefined;
    private _informationSchemaStatsExpiry?;
    get informationSchemaStatsExpiry(): number;
    set informationSchemaStatsExpiry(value: number);
    resetInformationSchemaStatsExpiry(): void;
    get informationSchemaStatsExpiryInput(): number | undefined;
    private _innodbChangeBufferMaxSize?;
    get innodbChangeBufferMaxSize(): number;
    set innodbChangeBufferMaxSize(value: number);
    resetInnodbChangeBufferMaxSize(): void;
    get innodbChangeBufferMaxSizeInput(): number | undefined;
    private _innodbFlushNeighbors?;
    get innodbFlushNeighbors(): number;
    set innodbFlushNeighbors(value: number);
    resetInnodbFlushNeighbors(): void;
    get innodbFlushNeighborsInput(): number | undefined;
    private _innodbFtMinTokenSize?;
    get innodbFtMinTokenSize(): number;
    set innodbFtMinTokenSize(value: number);
    resetInnodbFtMinTokenSize(): void;
    get innodbFtMinTokenSizeInput(): number | undefined;
    private _innodbFtServerStopwordTable?;
    get innodbFtServerStopwordTable(): string;
    set innodbFtServerStopwordTable(value: string);
    resetInnodbFtServerStopwordTable(): void;
    get innodbFtServerStopwordTableInput(): string | undefined;
    private _innodbLockWaitTimeout?;
    get innodbLockWaitTimeout(): number;
    set innodbLockWaitTimeout(value: number);
    resetInnodbLockWaitTimeout(): void;
    get innodbLockWaitTimeoutInput(): number | undefined;
    private _innodbLogBufferSize?;
    get innodbLogBufferSize(): number;
    set innodbLogBufferSize(value: number);
    resetInnodbLogBufferSize(): void;
    get innodbLogBufferSizeInput(): number | undefined;
    private _innodbOnlineAlterLogMaxSize?;
    get innodbOnlineAlterLogMaxSize(): number;
    set innodbOnlineAlterLogMaxSize(value: number);
    resetInnodbOnlineAlterLogMaxSize(): void;
    get innodbOnlineAlterLogMaxSizeInput(): number | undefined;
    private _innodbPrintAllDeadlocks?;
    get innodbPrintAllDeadlocks(): boolean | cdktf.IResolvable;
    set innodbPrintAllDeadlocks(value: boolean | cdktf.IResolvable);
    resetInnodbPrintAllDeadlocks(): void;
    get innodbPrintAllDeadlocksInput(): boolean | cdktf.IResolvable | undefined;
    private _innodbReadIoThreads?;
    get innodbReadIoThreads(): number;
    set innodbReadIoThreads(value: number);
    resetInnodbReadIoThreads(): void;
    get innodbReadIoThreadsInput(): number | undefined;
    private _innodbRollbackOnTimeout?;
    get innodbRollbackOnTimeout(): boolean | cdktf.IResolvable;
    set innodbRollbackOnTimeout(value: boolean | cdktf.IResolvable);
    resetInnodbRollbackOnTimeout(): void;
    get innodbRollbackOnTimeoutInput(): boolean | cdktf.IResolvable | undefined;
    private _innodbThreadConcurrency?;
    get innodbThreadConcurrency(): number;
    set innodbThreadConcurrency(value: number);
    resetInnodbThreadConcurrency(): void;
    get innodbThreadConcurrencyInput(): number | undefined;
    private _innodbWriteIoThreads?;
    get innodbWriteIoThreads(): number;
    set innodbWriteIoThreads(value: number);
    resetInnodbWriteIoThreads(): void;
    get innodbWriteIoThreadsInput(): number | undefined;
    private _interactiveTimeout?;
    get interactiveTimeout(): number;
    set interactiveTimeout(value: number);
    resetInteractiveTimeout(): void;
    get interactiveTimeoutInput(): number | undefined;
    private _internalTmpMemStorageEngine?;
    get internalTmpMemStorageEngine(): string;
    set internalTmpMemStorageEngine(value: string);
    resetInternalTmpMemStorageEngine(): void;
    get internalTmpMemStorageEngineInput(): string | undefined;
    private _ipFilter?;
    get ipFilter(): string[];
    set ipFilter(value: string[]);
    resetIpFilter(): void;
    get ipFilterInput(): string[] | undefined;
    private _longQueryTime?;
    get longQueryTime(): number;
    set longQueryTime(value: number);
    resetLongQueryTime(): void;
    get longQueryTimeInput(): number | undefined;
    private _maxAllowedPacket?;
    get maxAllowedPacket(): number;
    set maxAllowedPacket(value: number);
    resetMaxAllowedPacket(): void;
    get maxAllowedPacketInput(): number | undefined;
    private _maxHeapTableSize?;
    get maxHeapTableSize(): number;
    set maxHeapTableSize(value: number);
    resetMaxHeapTableSize(): void;
    get maxHeapTableSizeInput(): number | undefined;
    private _netBufferLength?;
    get netBufferLength(): number;
    set netBufferLength(value: number);
    resetNetBufferLength(): void;
    get netBufferLengthInput(): number | undefined;
    private _netReadTimeout?;
    get netReadTimeout(): number;
    set netReadTimeout(value: number);
    resetNetReadTimeout(): void;
    get netReadTimeoutInput(): number | undefined;
    private _netWriteTimeout?;
    get netWriteTimeout(): number;
    set netWriteTimeout(value: number);
    resetNetWriteTimeout(): void;
    get netWriteTimeoutInput(): number | undefined;
    private _publicAccess?;
    get publicAccess(): boolean | cdktf.IResolvable;
    set publicAccess(value: boolean | cdktf.IResolvable);
    resetPublicAccess(): void;
    get publicAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _slowQueryLog?;
    get slowQueryLog(): boolean | cdktf.IResolvable;
    set slowQueryLog(value: boolean | cdktf.IResolvable);
    resetSlowQueryLog(): void;
    get slowQueryLogInput(): boolean | cdktf.IResolvable | undefined;
    private _sortBufferSize?;
    get sortBufferSize(): number;
    set sortBufferSize(value: number);
    resetSortBufferSize(): void;
    get sortBufferSizeInput(): number | undefined;
    private _sqlMode?;
    get sqlMode(): string;
    set sqlMode(value: string);
    resetSqlMode(): void;
    get sqlModeInput(): string | undefined;
    private _sqlRequirePrimaryKey?;
    get sqlRequirePrimaryKey(): boolean | cdktf.IResolvable;
    set sqlRequirePrimaryKey(value: boolean | cdktf.IResolvable);
    resetSqlRequirePrimaryKey(): void;
    get sqlRequirePrimaryKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _tmpTableSize?;
    get tmpTableSize(): number;
    set tmpTableSize(value: number);
    resetTmpTableSize(): void;
    get tmpTableSizeInput(): number | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _waitTimeout?;
    get waitTimeout(): number;
    set waitTimeout(value: number);
    resetWaitTimeout(): void;
    get waitTimeoutInput(): number | undefined;
    private _migration;
    get migration(): ManagedDatabaseMysqlPropertiesMigrationOutputReference;
    putMigration(value: ManagedDatabaseMysqlPropertiesMigration): void;
    resetMigration(): void;
    get migrationInput(): ManagedDatabaseMysqlPropertiesMigration | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql upcloud_managed_database_mysql}
*/
export declare class ManagedDatabaseMysql extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_managed_database_mysql";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql upcloud_managed_database_mysql} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedDatabaseMysqlConfig
    */
    constructor(scope: Construct, id: string, config: ManagedDatabaseMysqlConfig);
    private _components;
    get components(): ManagedDatabaseMysqlComponentsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maintenanceWindowDow?;
    get maintenanceWindowDow(): string;
    set maintenanceWindowDow(value: string);
    resetMaintenanceWindowDow(): void;
    get maintenanceWindowDowInput(): string | undefined;
    private _maintenanceWindowTime?;
    get maintenanceWindowTime(): string;
    set maintenanceWindowTime(value: string);
    resetMaintenanceWindowTime(): void;
    get maintenanceWindowTimeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeStates;
    get nodeStates(): ManagedDatabaseMysqlNodeStatesList;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    private _powered?;
    get powered(): boolean | cdktf.IResolvable;
    set powered(value: boolean | cdktf.IResolvable);
    resetPowered(): void;
    get poweredInput(): boolean | cdktf.IResolvable | undefined;
    get primaryDatabase(): string;
    get serviceHost(): string;
    get servicePassword(): string;
    get servicePort(): string;
    get serviceUri(): string;
    get serviceUsername(): string;
    get state(): string;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    get type(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _properties;
    get properties(): ManagedDatabaseMysqlPropertiesOutputReference;
    putProperties(value: ManagedDatabaseMysqlProperties): void;
    resetProperties(): void;
    get propertiesInput(): ManagedDatabaseMysqlProperties | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
