"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedDatabaseMysql = exports.ManagedDatabaseMysqlPropertiesOutputReference = exports.managedDatabaseMysqlPropertiesToTerraform = exports.ManagedDatabaseMysqlPropertiesMigrationOutputReference = exports.managedDatabaseMysqlPropertiesMigrationToTerraform = exports.ManagedDatabaseMysqlNodeStatesList = exports.ManagedDatabaseMysqlNodeStatesOutputReference = exports.managedDatabaseMysqlNodeStatesToTerraform = exports.ManagedDatabaseMysqlComponentsList = exports.ManagedDatabaseMysqlComponentsOutputReference = exports.managedDatabaseMysqlComponentsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function managedDatabaseMysqlComponentsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.managedDatabaseMysqlComponentsToTerraform = managedDatabaseMysqlComponentsToTerraform;
class ManagedDatabaseMysqlComponentsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // component - computed: true, optional: false, required: false
    get component() {
        return this.getStringAttribute('component');
    }
    // host - computed: true, optional: false, required: false
    get host() {
        return this.getStringAttribute('host');
    }
    // port - computed: true, optional: false, required: false
    get port() {
        return this.getNumberAttribute('port');
    }
    // route - computed: true, optional: false, required: false
    get route() {
        return this.getStringAttribute('route');
    }
    // usage - computed: true, optional: false, required: false
    get usage() {
        return this.getStringAttribute('usage');
    }
}
exports.ManagedDatabaseMysqlComponentsOutputReference = ManagedDatabaseMysqlComponentsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlComponentsOutputReference[_a] = { fqn: "@cdktf/provider-upcloud.managedDatabaseMysql.ManagedDatabaseMysqlComponentsOutputReference", version: "4.0.2" };
class ManagedDatabaseMysqlComponentsList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ManagedDatabaseMysqlComponentsOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ManagedDatabaseMysqlComponentsList = ManagedDatabaseMysqlComponentsList;
_b = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlComponentsList[_b] = { fqn: "@cdktf/provider-upcloud.managedDatabaseMysql.ManagedDatabaseMysqlComponentsList", version: "4.0.2" };
function managedDatabaseMysqlNodeStatesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.managedDatabaseMysqlNodeStatesToTerraform = managedDatabaseMysqlNodeStatesToTerraform;
class ManagedDatabaseMysqlNodeStatesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    // role - computed: true, optional: false, required: false
    get role() {
        return this.getStringAttribute('role');
    }
    // state - computed: true, optional: false, required: false
    get state() {
        return this.getStringAttribute('state');
    }
}
exports.ManagedDatabaseMysqlNodeStatesOutputReference = ManagedDatabaseMysqlNodeStatesOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlNodeStatesOutputReference[_c] = { fqn: "@cdktf/provider-upcloud.managedDatabaseMysql.ManagedDatabaseMysqlNodeStatesOutputReference", version: "4.0.2" };
class ManagedDatabaseMysqlNodeStatesList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ManagedDatabaseMysqlNodeStatesOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ManagedDatabaseMysqlNodeStatesList = ManagedDatabaseMysqlNodeStatesList;
_d = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlNodeStatesList[_d] = { fqn: "@cdktf/provider-upcloud.managedDatabaseMysql.ManagedDatabaseMysqlNodeStatesList", version: "4.0.2" };
function managedDatabaseMysqlPropertiesMigrationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        dbname: cdktf.stringToTerraform(struct.dbname),
        host: cdktf.stringToTerraform(struct.host),
        ignore_dbs: cdktf.stringToTerraform(struct.ignoreDbs),
        password: cdktf.stringToTerraform(struct.password),
        port: cdktf.numberToTerraform(struct.port),
        ssl: cdktf.booleanToTerraform(struct.ssl),
        username: cdktf.stringToTerraform(struct.username),
    };
}
exports.managedDatabaseMysqlPropertiesMigrationToTerraform = managedDatabaseMysqlPropertiesMigrationToTerraform;
class ManagedDatabaseMysqlPropertiesMigrationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._dbname !== undefined) {
            hasAnyValues = true;
            internalValueResult.dbname = this._dbname;
        }
        if (this._host !== undefined) {
            hasAnyValues = true;
            internalValueResult.host = this._host;
        }
        if (this._ignoreDbs !== undefined) {
            hasAnyValues = true;
            internalValueResult.ignoreDbs = this._ignoreDbs;
        }
        if (this._password !== undefined) {
            hasAnyValues = true;
            internalValueResult.password = this._password;
        }
        if (this._port !== undefined) {
            hasAnyValues = true;
            internalValueResult.port = this._port;
        }
        if (this._ssl !== undefined) {
            hasAnyValues = true;
            internalValueResult.ssl = this._ssl;
        }
        if (this._username !== undefined) {
            hasAnyValues = true;
            internalValueResult.username = this._username;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._dbname = undefined;
            this._host = undefined;
            this._ignoreDbs = undefined;
            this._password = undefined;
            this._port = undefined;
            this._ssl = undefined;
            this._username = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._dbname = value.dbname;
            this._host = value.host;
            this._ignoreDbs = value.ignoreDbs;
            this._password = value.password;
            this._port = value.port;
            this._ssl = value.ssl;
            this._username = value.username;
        }
    }
    get dbname() {
        return this.getStringAttribute('dbname');
    }
    set dbname(value) {
        this._dbname = value;
    }
    resetDbname() {
        this._dbname = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dbnameInput() {
        return this._dbname;
    }
    get host() {
        return this.getStringAttribute('host');
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get ignoreDbs() {
        return this.getStringAttribute('ignore_dbs');
    }
    set ignoreDbs(value) {
        this._ignoreDbs = value;
    }
    resetIgnoreDbs() {
        this._ignoreDbs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreDbsInput() {
        return this._ignoreDbs;
    }
    get password() {
        return this.getStringAttribute('password');
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get ssl() {
        return this.getBooleanAttribute('ssl');
    }
    set ssl(value) {
        this._ssl = value;
    }
    resetSsl() {
        this._ssl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslInput() {
        return this._ssl;
    }
    get username() {
        return this.getStringAttribute('username');
    }
    set username(value) {
        this._username = value;
    }
    resetUsername() {
        this._username = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
}
exports.ManagedDatabaseMysqlPropertiesMigrationOutputReference = ManagedDatabaseMysqlPropertiesMigrationOutputReference;
_e = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlPropertiesMigrationOutputReference[_e] = { fqn: "@cdktf/provider-upcloud.managedDatabaseMysql.ManagedDatabaseMysqlPropertiesMigrationOutputReference", version: "4.0.2" };
function managedDatabaseMysqlPropertiesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        admin_password: cdktf.stringToTerraform(struct.adminPassword),
        admin_username: cdktf.stringToTerraform(struct.adminUsername),
        automatic_utility_network_ip_filter: cdktf.booleanToTerraform(struct.automaticUtilityNetworkIpFilter),
        backup_hour: cdktf.numberToTerraform(struct.backupHour),
        backup_minute: cdktf.numberToTerraform(struct.backupMinute),
        binlog_retention_period: cdktf.numberToTerraform(struct.binlogRetentionPeriod),
        connect_timeout: cdktf.numberToTerraform(struct.connectTimeout),
        default_time_zone: cdktf.stringToTerraform(struct.defaultTimeZone),
        group_concat_max_len: cdktf.numberToTerraform(struct.groupConcatMaxLen),
        information_schema_stats_expiry: cdktf.numberToTerraform(struct.informationSchemaStatsExpiry),
        innodb_change_buffer_max_size: cdktf.numberToTerraform(struct.innodbChangeBufferMaxSize),
        innodb_flush_neighbors: cdktf.numberToTerraform(struct.innodbFlushNeighbors),
        innodb_ft_min_token_size: cdktf.numberToTerraform(struct.innodbFtMinTokenSize),
        innodb_ft_server_stopword_table: cdktf.stringToTerraform(struct.innodbFtServerStopwordTable),
        innodb_lock_wait_timeout: cdktf.numberToTerraform(struct.innodbLockWaitTimeout),
        innodb_log_buffer_size: cdktf.numberToTerraform(struct.innodbLogBufferSize),
        innodb_online_alter_log_max_size: cdktf.numberToTerraform(struct.innodbOnlineAlterLogMaxSize),
        innodb_print_all_deadlocks: cdktf.booleanToTerraform(struct.innodbPrintAllDeadlocks),
        innodb_read_io_threads: cdktf.numberToTerraform(struct.innodbReadIoThreads),
        innodb_rollback_on_timeout: cdktf.booleanToTerraform(struct.innodbRollbackOnTimeout),
        innodb_thread_concurrency: cdktf.numberToTerraform(struct.innodbThreadConcurrency),
        innodb_write_io_threads: cdktf.numberToTerraform(struct.innodbWriteIoThreads),
        interactive_timeout: cdktf.numberToTerraform(struct.interactiveTimeout),
        internal_tmp_mem_storage_engine: cdktf.stringToTerraform(struct.internalTmpMemStorageEngine),
        ip_filter: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.ipFilter),
        long_query_time: cdktf.numberToTerraform(struct.longQueryTime),
        max_allowed_packet: cdktf.numberToTerraform(struct.maxAllowedPacket),
        max_heap_table_size: cdktf.numberToTerraform(struct.maxHeapTableSize),
        net_buffer_length: cdktf.numberToTerraform(struct.netBufferLength),
        net_read_timeout: cdktf.numberToTerraform(struct.netReadTimeout),
        net_write_timeout: cdktf.numberToTerraform(struct.netWriteTimeout),
        public_access: cdktf.booleanToTerraform(struct.publicAccess),
        slow_query_log: cdktf.booleanToTerraform(struct.slowQueryLog),
        sort_buffer_size: cdktf.numberToTerraform(struct.sortBufferSize),
        sql_mode: cdktf.stringToTerraform(struct.sqlMode),
        sql_require_primary_key: cdktf.booleanToTerraform(struct.sqlRequirePrimaryKey),
        tmp_table_size: cdktf.numberToTerraform(struct.tmpTableSize),
        version: cdktf.stringToTerraform(struct.version),
        wait_timeout: cdktf.numberToTerraform(struct.waitTimeout),
        migration: managedDatabaseMysqlPropertiesMigrationToTerraform(struct.migration),
    };
}
exports.managedDatabaseMysqlPropertiesToTerraform = managedDatabaseMysqlPropertiesToTerraform;
class ManagedDatabaseMysqlPropertiesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // migration - computed: false, optional: true, required: false
        this._migration = new ManagedDatabaseMysqlPropertiesMigrationOutputReference(this, "migration");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._adminPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.adminPassword = this._adminPassword;
        }
        if (this._adminUsername !== undefined) {
            hasAnyValues = true;
            internalValueResult.adminUsername = this._adminUsername;
        }
        if (this._automaticUtilityNetworkIpFilter !== undefined) {
            hasAnyValues = true;
            internalValueResult.automaticUtilityNetworkIpFilter = this._automaticUtilityNetworkIpFilter;
        }
        if (this._backupHour !== undefined) {
            hasAnyValues = true;
            internalValueResult.backupHour = this._backupHour;
        }
        if (this._backupMinute !== undefined) {
            hasAnyValues = true;
            internalValueResult.backupMinute = this._backupMinute;
        }
        if (this._binlogRetentionPeriod !== undefined) {
            hasAnyValues = true;
            internalValueResult.binlogRetentionPeriod = this._binlogRetentionPeriod;
        }
        if (this._connectTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.connectTimeout = this._connectTimeout;
        }
        if (this._defaultTimeZone !== undefined) {
            hasAnyValues = true;
            internalValueResult.defaultTimeZone = this._defaultTimeZone;
        }
        if (this._groupConcatMaxLen !== undefined) {
            hasAnyValues = true;
            internalValueResult.groupConcatMaxLen = this._groupConcatMaxLen;
        }
        if (this._informationSchemaStatsExpiry !== undefined) {
            hasAnyValues = true;
            internalValueResult.informationSchemaStatsExpiry = this._informationSchemaStatsExpiry;
        }
        if (this._innodbChangeBufferMaxSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbChangeBufferMaxSize = this._innodbChangeBufferMaxSize;
        }
        if (this._innodbFlushNeighbors !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbFlushNeighbors = this._innodbFlushNeighbors;
        }
        if (this._innodbFtMinTokenSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbFtMinTokenSize = this._innodbFtMinTokenSize;
        }
        if (this._innodbFtServerStopwordTable !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbFtServerStopwordTable = this._innodbFtServerStopwordTable;
        }
        if (this._innodbLockWaitTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbLockWaitTimeout = this._innodbLockWaitTimeout;
        }
        if (this._innodbLogBufferSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbLogBufferSize = this._innodbLogBufferSize;
        }
        if (this._innodbOnlineAlterLogMaxSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbOnlineAlterLogMaxSize = this._innodbOnlineAlterLogMaxSize;
        }
        if (this._innodbPrintAllDeadlocks !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbPrintAllDeadlocks = this._innodbPrintAllDeadlocks;
        }
        if (this._innodbReadIoThreads !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbReadIoThreads = this._innodbReadIoThreads;
        }
        if (this._innodbRollbackOnTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbRollbackOnTimeout = this._innodbRollbackOnTimeout;
        }
        if (this._innodbThreadConcurrency !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbThreadConcurrency = this._innodbThreadConcurrency;
        }
        if (this._innodbWriteIoThreads !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbWriteIoThreads = this._innodbWriteIoThreads;
        }
        if (this._interactiveTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.interactiveTimeout = this._interactiveTimeout;
        }
        if (this._internalTmpMemStorageEngine !== undefined) {
            hasAnyValues = true;
            internalValueResult.internalTmpMemStorageEngine = this._internalTmpMemStorageEngine;
        }
        if (this._ipFilter !== undefined) {
            hasAnyValues = true;
            internalValueResult.ipFilter = this._ipFilter;
        }
        if (this._longQueryTime !== undefined) {
            hasAnyValues = true;
            internalValueResult.longQueryTime = this._longQueryTime;
        }
        if (this._maxAllowedPacket !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxAllowedPacket = this._maxAllowedPacket;
        }
        if (this._maxHeapTableSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxHeapTableSize = this._maxHeapTableSize;
        }
        if (this._netBufferLength !== undefined) {
            hasAnyValues = true;
            internalValueResult.netBufferLength = this._netBufferLength;
        }
        if (this._netReadTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.netReadTimeout = this._netReadTimeout;
        }
        if (this._netWriteTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.netWriteTimeout = this._netWriteTimeout;
        }
        if (this._publicAccess !== undefined) {
            hasAnyValues = true;
            internalValueResult.publicAccess = this._publicAccess;
        }
        if (this._slowQueryLog !== undefined) {
            hasAnyValues = true;
            internalValueResult.slowQueryLog = this._slowQueryLog;
        }
        if (this._sortBufferSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.sortBufferSize = this._sortBufferSize;
        }
        if (this._sqlMode !== undefined) {
            hasAnyValues = true;
            internalValueResult.sqlMode = this._sqlMode;
        }
        if (this._sqlRequirePrimaryKey !== undefined) {
            hasAnyValues = true;
            internalValueResult.sqlRequirePrimaryKey = this._sqlRequirePrimaryKey;
        }
        if (this._tmpTableSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.tmpTableSize = this._tmpTableSize;
        }
        if (this._version !== undefined) {
            hasAnyValues = true;
            internalValueResult.version = this._version;
        }
        if (this._waitTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.waitTimeout = this._waitTimeout;
        }
        if (this._migration?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.migration = this._migration?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._adminPassword = undefined;
            this._adminUsername = undefined;
            this._automaticUtilityNetworkIpFilter = undefined;
            this._backupHour = undefined;
            this._backupMinute = undefined;
            this._binlogRetentionPeriod = undefined;
            this._connectTimeout = undefined;
            this._defaultTimeZone = undefined;
            this._groupConcatMaxLen = undefined;
            this._informationSchemaStatsExpiry = undefined;
            this._innodbChangeBufferMaxSize = undefined;
            this._innodbFlushNeighbors = undefined;
            this._innodbFtMinTokenSize = undefined;
            this._innodbFtServerStopwordTable = undefined;
            this._innodbLockWaitTimeout = undefined;
            this._innodbLogBufferSize = undefined;
            this._innodbOnlineAlterLogMaxSize = undefined;
            this._innodbPrintAllDeadlocks = undefined;
            this._innodbReadIoThreads = undefined;
            this._innodbRollbackOnTimeout = undefined;
            this._innodbThreadConcurrency = undefined;
            this._innodbWriteIoThreads = undefined;
            this._interactiveTimeout = undefined;
            this._internalTmpMemStorageEngine = undefined;
            this._ipFilter = undefined;
            this._longQueryTime = undefined;
            this._maxAllowedPacket = undefined;
            this._maxHeapTableSize = undefined;
            this._netBufferLength = undefined;
            this._netReadTimeout = undefined;
            this._netWriteTimeout = undefined;
            this._publicAccess = undefined;
            this._slowQueryLog = undefined;
            this._sortBufferSize = undefined;
            this._sqlMode = undefined;
            this._sqlRequirePrimaryKey = undefined;
            this._tmpTableSize = undefined;
            this._version = undefined;
            this._waitTimeout = undefined;
            this._migration.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._adminPassword = value.adminPassword;
            this._adminUsername = value.adminUsername;
            this._automaticUtilityNetworkIpFilter = value.automaticUtilityNetworkIpFilter;
            this._backupHour = value.backupHour;
            this._backupMinute = value.backupMinute;
            this._binlogRetentionPeriod = value.binlogRetentionPeriod;
            this._connectTimeout = value.connectTimeout;
            this._defaultTimeZone = value.defaultTimeZone;
            this._groupConcatMaxLen = value.groupConcatMaxLen;
            this._informationSchemaStatsExpiry = value.informationSchemaStatsExpiry;
            this._innodbChangeBufferMaxSize = value.innodbChangeBufferMaxSize;
            this._innodbFlushNeighbors = value.innodbFlushNeighbors;
            this._innodbFtMinTokenSize = value.innodbFtMinTokenSize;
            this._innodbFtServerStopwordTable = value.innodbFtServerStopwordTable;
            this._innodbLockWaitTimeout = value.innodbLockWaitTimeout;
            this._innodbLogBufferSize = value.innodbLogBufferSize;
            this._innodbOnlineAlterLogMaxSize = value.innodbOnlineAlterLogMaxSize;
            this._innodbPrintAllDeadlocks = value.innodbPrintAllDeadlocks;
            this._innodbReadIoThreads = value.innodbReadIoThreads;
            this._innodbRollbackOnTimeout = value.innodbRollbackOnTimeout;
            this._innodbThreadConcurrency = value.innodbThreadConcurrency;
            this._innodbWriteIoThreads = value.innodbWriteIoThreads;
            this._interactiveTimeout = value.interactiveTimeout;
            this._internalTmpMemStorageEngine = value.internalTmpMemStorageEngine;
            this._ipFilter = value.ipFilter;
            this._longQueryTime = value.longQueryTime;
            this._maxAllowedPacket = value.maxAllowedPacket;
            this._maxHeapTableSize = value.maxHeapTableSize;
            this._netBufferLength = value.netBufferLength;
            this._netReadTimeout = value.netReadTimeout;
            this._netWriteTimeout = value.netWriteTimeout;
            this._publicAccess = value.publicAccess;
            this._slowQueryLog = value.slowQueryLog;
            this._sortBufferSize = value.sortBufferSize;
            this._sqlMode = value.sqlMode;
            this._sqlRequirePrimaryKey = value.sqlRequirePrimaryKey;
            this._tmpTableSize = value.tmpTableSize;
            this._version = value.version;
            this._waitTimeout = value.waitTimeout;
            this._migration.internalValue = value.migration;
        }
    }
    // additional_backup_regions - computed: true, optional: false, required: false
    get additionalBackupRegions() {
        return this.getListAttribute('additional_backup_regions');
    }
    get adminPassword() {
        return this.getStringAttribute('admin_password');
    }
    set adminPassword(value) {
        this._adminPassword = value;
    }
    resetAdminPassword() {
        this._adminPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminPasswordInput() {
        return this._adminPassword;
    }
    get adminUsername() {
        return this.getStringAttribute('admin_username');
    }
    set adminUsername(value) {
        this._adminUsername = value;
    }
    resetAdminUsername() {
        this._adminUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminUsernameInput() {
        return this._adminUsername;
    }
    get automaticUtilityNetworkIpFilter() {
        return this.getBooleanAttribute('automatic_utility_network_ip_filter');
    }
    set automaticUtilityNetworkIpFilter(value) {
        this._automaticUtilityNetworkIpFilter = value;
    }
    resetAutomaticUtilityNetworkIpFilter() {
        this._automaticUtilityNetworkIpFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get automaticUtilityNetworkIpFilterInput() {
        return this._automaticUtilityNetworkIpFilter;
    }
    get backupHour() {
        return this.getNumberAttribute('backup_hour');
    }
    set backupHour(value) {
        this._backupHour = value;
    }
    resetBackupHour() {
        this._backupHour = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupHourInput() {
        return this._backupHour;
    }
    get backupMinute() {
        return this.getNumberAttribute('backup_minute');
    }
    set backupMinute(value) {
        this._backupMinute = value;
    }
    resetBackupMinute() {
        this._backupMinute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupMinuteInput() {
        return this._backupMinute;
    }
    get binlogRetentionPeriod() {
        return this.getNumberAttribute('binlog_retention_period');
    }
    set binlogRetentionPeriod(value) {
        this._binlogRetentionPeriod = value;
    }
    resetBinlogRetentionPeriod() {
        this._binlogRetentionPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binlogRetentionPeriodInput() {
        return this._binlogRetentionPeriod;
    }
    get connectTimeout() {
        return this.getNumberAttribute('connect_timeout');
    }
    set connectTimeout(value) {
        this._connectTimeout = value;
    }
    resetConnectTimeout() {
        this._connectTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get connectTimeoutInput() {
        return this._connectTimeout;
    }
    get defaultTimeZone() {
        return this.getStringAttribute('default_time_zone');
    }
    set defaultTimeZone(value) {
        this._defaultTimeZone = value;
    }
    resetDefaultTimeZone() {
        this._defaultTimeZone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultTimeZoneInput() {
        return this._defaultTimeZone;
    }
    get groupConcatMaxLen() {
        return this.getNumberAttribute('group_concat_max_len');
    }
    set groupConcatMaxLen(value) {
        this._groupConcatMaxLen = value;
    }
    resetGroupConcatMaxLen() {
        this._groupConcatMaxLen = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupConcatMaxLenInput() {
        return this._groupConcatMaxLen;
    }
    get informationSchemaStatsExpiry() {
        return this.getNumberAttribute('information_schema_stats_expiry');
    }
    set informationSchemaStatsExpiry(value) {
        this._informationSchemaStatsExpiry = value;
    }
    resetInformationSchemaStatsExpiry() {
        this._informationSchemaStatsExpiry = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get informationSchemaStatsExpiryInput() {
        return this._informationSchemaStatsExpiry;
    }
    get innodbChangeBufferMaxSize() {
        return this.getNumberAttribute('innodb_change_buffer_max_size');
    }
    set innodbChangeBufferMaxSize(value) {
        this._innodbChangeBufferMaxSize = value;
    }
    resetInnodbChangeBufferMaxSize() {
        this._innodbChangeBufferMaxSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbChangeBufferMaxSizeInput() {
        return this._innodbChangeBufferMaxSize;
    }
    get innodbFlushNeighbors() {
        return this.getNumberAttribute('innodb_flush_neighbors');
    }
    set innodbFlushNeighbors(value) {
        this._innodbFlushNeighbors = value;
    }
    resetInnodbFlushNeighbors() {
        this._innodbFlushNeighbors = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbFlushNeighborsInput() {
        return this._innodbFlushNeighbors;
    }
    get innodbFtMinTokenSize() {
        return this.getNumberAttribute('innodb_ft_min_token_size');
    }
    set innodbFtMinTokenSize(value) {
        this._innodbFtMinTokenSize = value;
    }
    resetInnodbFtMinTokenSize() {
        this._innodbFtMinTokenSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbFtMinTokenSizeInput() {
        return this._innodbFtMinTokenSize;
    }
    get innodbFtServerStopwordTable() {
        return this.getStringAttribute('innodb_ft_server_stopword_table');
    }
    set innodbFtServerStopwordTable(value) {
        this._innodbFtServerStopwordTable = value;
    }
    resetInnodbFtServerStopwordTable() {
        this._innodbFtServerStopwordTable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbFtServerStopwordTableInput() {
        return this._innodbFtServerStopwordTable;
    }
    get innodbLockWaitTimeout() {
        return this.getNumberAttribute('innodb_lock_wait_timeout');
    }
    set innodbLockWaitTimeout(value) {
        this._innodbLockWaitTimeout = value;
    }
    resetInnodbLockWaitTimeout() {
        this._innodbLockWaitTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbLockWaitTimeoutInput() {
        return this._innodbLockWaitTimeout;
    }
    get innodbLogBufferSize() {
        return this.getNumberAttribute('innodb_log_buffer_size');
    }
    set innodbLogBufferSize(value) {
        this._innodbLogBufferSize = value;
    }
    resetInnodbLogBufferSize() {
        this._innodbLogBufferSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbLogBufferSizeInput() {
        return this._innodbLogBufferSize;
    }
    get innodbOnlineAlterLogMaxSize() {
        return this.getNumberAttribute('innodb_online_alter_log_max_size');
    }
    set innodbOnlineAlterLogMaxSize(value) {
        this._innodbOnlineAlterLogMaxSize = value;
    }
    resetInnodbOnlineAlterLogMaxSize() {
        this._innodbOnlineAlterLogMaxSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbOnlineAlterLogMaxSizeInput() {
        return this._innodbOnlineAlterLogMaxSize;
    }
    get innodbPrintAllDeadlocks() {
        return this.getBooleanAttribute('innodb_print_all_deadlocks');
    }
    set innodbPrintAllDeadlocks(value) {
        this._innodbPrintAllDeadlocks = value;
    }
    resetInnodbPrintAllDeadlocks() {
        this._innodbPrintAllDeadlocks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbPrintAllDeadlocksInput() {
        return this._innodbPrintAllDeadlocks;
    }
    get innodbReadIoThreads() {
        return this.getNumberAttribute('innodb_read_io_threads');
    }
    set innodbReadIoThreads(value) {
        this._innodbReadIoThreads = value;
    }
    resetInnodbReadIoThreads() {
        this._innodbReadIoThreads = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbReadIoThreadsInput() {
        return this._innodbReadIoThreads;
    }
    get innodbRollbackOnTimeout() {
        return this.getBooleanAttribute('innodb_rollback_on_timeout');
    }
    set innodbRollbackOnTimeout(value) {
        this._innodbRollbackOnTimeout = value;
    }
    resetInnodbRollbackOnTimeout() {
        this._innodbRollbackOnTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbRollbackOnTimeoutInput() {
        return this._innodbRollbackOnTimeout;
    }
    get innodbThreadConcurrency() {
        return this.getNumberAttribute('innodb_thread_concurrency');
    }
    set innodbThreadConcurrency(value) {
        this._innodbThreadConcurrency = value;
    }
    resetInnodbThreadConcurrency() {
        this._innodbThreadConcurrency = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbThreadConcurrencyInput() {
        return this._innodbThreadConcurrency;
    }
    get innodbWriteIoThreads() {
        return this.getNumberAttribute('innodb_write_io_threads');
    }
    set innodbWriteIoThreads(value) {
        this._innodbWriteIoThreads = value;
    }
    resetInnodbWriteIoThreads() {
        this._innodbWriteIoThreads = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbWriteIoThreadsInput() {
        return this._innodbWriteIoThreads;
    }
    get interactiveTimeout() {
        return this.getNumberAttribute('interactive_timeout');
    }
    set interactiveTimeout(value) {
        this._interactiveTimeout = value;
    }
    resetInteractiveTimeout() {
        this._interactiveTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get interactiveTimeoutInput() {
        return this._interactiveTimeout;
    }
    get internalTmpMemStorageEngine() {
        return this.getStringAttribute('internal_tmp_mem_storage_engine');
    }
    set internalTmpMemStorageEngine(value) {
        this._internalTmpMemStorageEngine = value;
    }
    resetInternalTmpMemStorageEngine() {
        this._internalTmpMemStorageEngine = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get internalTmpMemStorageEngineInput() {
        return this._internalTmpMemStorageEngine;
    }
    get ipFilter() {
        return this.getListAttribute('ip_filter');
    }
    set ipFilter(value) {
        this._ipFilter = value;
    }
    resetIpFilter() {
        this._ipFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipFilterInput() {
        return this._ipFilter;
    }
    get longQueryTime() {
        return this.getNumberAttribute('long_query_time');
    }
    set longQueryTime(value) {
        this._longQueryTime = value;
    }
    resetLongQueryTime() {
        this._longQueryTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get longQueryTimeInput() {
        return this._longQueryTime;
    }
    get maxAllowedPacket() {
        return this.getNumberAttribute('max_allowed_packet');
    }
    set maxAllowedPacket(value) {
        this._maxAllowedPacket = value;
    }
    resetMaxAllowedPacket() {
        this._maxAllowedPacket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxAllowedPacketInput() {
        return this._maxAllowedPacket;
    }
    get maxHeapTableSize() {
        return this.getNumberAttribute('max_heap_table_size');
    }
    set maxHeapTableSize(value) {
        this._maxHeapTableSize = value;
    }
    resetMaxHeapTableSize() {
        this._maxHeapTableSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxHeapTableSizeInput() {
        return this._maxHeapTableSize;
    }
    get netBufferLength() {
        return this.getNumberAttribute('net_buffer_length');
    }
    set netBufferLength(value) {
        this._netBufferLength = value;
    }
    resetNetBufferLength() {
        this._netBufferLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netBufferLengthInput() {
        return this._netBufferLength;
    }
    get netReadTimeout() {
        return this.getNumberAttribute('net_read_timeout');
    }
    set netReadTimeout(value) {
        this._netReadTimeout = value;
    }
    resetNetReadTimeout() {
        this._netReadTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netReadTimeoutInput() {
        return this._netReadTimeout;
    }
    get netWriteTimeout() {
        return this.getNumberAttribute('net_write_timeout');
    }
    set netWriteTimeout(value) {
        this._netWriteTimeout = value;
    }
    resetNetWriteTimeout() {
        this._netWriteTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netWriteTimeoutInput() {
        return this._netWriteTimeout;
    }
    get publicAccess() {
        return this.getBooleanAttribute('public_access');
    }
    set publicAccess(value) {
        this._publicAccess = value;
    }
    resetPublicAccess() {
        this._publicAccess = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicAccessInput() {
        return this._publicAccess;
    }
    get slowQueryLog() {
        return this.getBooleanAttribute('slow_query_log');
    }
    set slowQueryLog(value) {
        this._slowQueryLog = value;
    }
    resetSlowQueryLog() {
        this._slowQueryLog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slowQueryLogInput() {
        return this._slowQueryLog;
    }
    get sortBufferSize() {
        return this.getNumberAttribute('sort_buffer_size');
    }
    set sortBufferSize(value) {
        this._sortBufferSize = value;
    }
    resetSortBufferSize() {
        this._sortBufferSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sortBufferSizeInput() {
        return this._sortBufferSize;
    }
    get sqlMode() {
        return this.getStringAttribute('sql_mode');
    }
    set sqlMode(value) {
        this._sqlMode = value;
    }
    resetSqlMode() {
        this._sqlMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlModeInput() {
        return this._sqlMode;
    }
    get sqlRequirePrimaryKey() {
        return this.getBooleanAttribute('sql_require_primary_key');
    }
    set sqlRequirePrimaryKey(value) {
        this._sqlRequirePrimaryKey = value;
    }
    resetSqlRequirePrimaryKey() {
        this._sqlRequirePrimaryKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlRequirePrimaryKeyInput() {
        return this._sqlRequirePrimaryKey;
    }
    get tmpTableSize() {
        return this.getNumberAttribute('tmp_table_size');
    }
    set tmpTableSize(value) {
        this._tmpTableSize = value;
    }
    resetTmpTableSize() {
        this._tmpTableSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tmpTableSizeInput() {
        return this._tmpTableSize;
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    resetVersion() {
        this._version = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
    get waitTimeout() {
        return this.getNumberAttribute('wait_timeout');
    }
    set waitTimeout(value) {
        this._waitTimeout = value;
    }
    resetWaitTimeout() {
        this._waitTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get waitTimeoutInput() {
        return this._waitTimeout;
    }
    get migration() {
        return this._migration;
    }
    putMigration(value) {
        this._migration.internalValue = value;
    }
    resetMigration() {
        this._migration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get migrationInput() {
        return this._migration.internalValue;
    }
}
exports.ManagedDatabaseMysqlPropertiesOutputReference = ManagedDatabaseMysqlPropertiesOutputReference;
_f = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlPropertiesOutputReference[_f] = { fqn: "@cdktf/provider-upcloud.managedDatabaseMysql.ManagedDatabaseMysqlPropertiesOutputReference", version: "4.0.2" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql upcloud_managed_database_mysql}
*/
class ManagedDatabaseMysql extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql upcloud_managed_database_mysql} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedDatabaseMysqlConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'upcloud_managed_database_mysql',
            terraformGeneratorMetadata: {
                providerName: 'upcloud',
                providerVersion: '2.7.1',
                providerVersionConstraint: '~> 2.4'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // ==========
        // ATTRIBUTES
        // ==========
        // components - computed: true, optional: false, required: false
        this._components = new ManagedDatabaseMysqlComponentsList(this, "components", false);
        // node_states - computed: true, optional: false, required: false
        this._nodeStates = new ManagedDatabaseMysqlNodeStatesList(this, "node_states", false);
        // properties - computed: false, optional: true, required: false
        this._properties = new ManagedDatabaseMysqlPropertiesOutputReference(this, "properties");
        this._id = config.id;
        this._maintenanceWindowDow = config.maintenanceWindowDow;
        this._maintenanceWindowTime = config.maintenanceWindowTime;
        this._name = config.name;
        this._plan = config.plan;
        this._powered = config.powered;
        this._title = config.title;
        this._zone = config.zone;
        this._properties.internalValue = config.properties;
    }
    get components() {
        return this._components;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get maintenanceWindowDow() {
        return this.getStringAttribute('maintenance_window_dow');
    }
    set maintenanceWindowDow(value) {
        this._maintenanceWindowDow = value;
    }
    resetMaintenanceWindowDow() {
        this._maintenanceWindowDow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceWindowDowInput() {
        return this._maintenanceWindowDow;
    }
    get maintenanceWindowTime() {
        return this.getStringAttribute('maintenance_window_time');
    }
    set maintenanceWindowTime(value) {
        this._maintenanceWindowTime = value;
    }
    resetMaintenanceWindowTime() {
        this._maintenanceWindowTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceWindowTimeInput() {
        return this._maintenanceWindowTime;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nodeStates() {
        return this._nodeStates;
    }
    get plan() {
        return this.getStringAttribute('plan');
    }
    set plan(value) {
        this._plan = value;
    }
    // Temporarily expose input value. Use with caution.
    get planInput() {
        return this._plan;
    }
    get powered() {
        return this.getBooleanAttribute('powered');
    }
    set powered(value) {
        this._powered = value;
    }
    resetPowered() {
        this._powered = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get poweredInput() {
        return this._powered;
    }
    // primary_database - computed: true, optional: false, required: false
    get primaryDatabase() {
        return this.getStringAttribute('primary_database');
    }
    // service_host - computed: true, optional: false, required: false
    get serviceHost() {
        return this.getStringAttribute('service_host');
    }
    // service_password - computed: true, optional: false, required: false
    get servicePassword() {
        return this.getStringAttribute('service_password');
    }
    // service_port - computed: true, optional: false, required: false
    get servicePort() {
        return this.getStringAttribute('service_port');
    }
    // service_uri - computed: true, optional: false, required: false
    get serviceUri() {
        return this.getStringAttribute('service_uri');
    }
    // service_username - computed: true, optional: false, required: false
    get serviceUsername() {
        return this.getStringAttribute('service_username');
    }
    // state - computed: true, optional: false, required: false
    get state() {
        return this.getStringAttribute('state');
    }
    get title() {
        return this.getStringAttribute('title');
    }
    set title(value) {
        this._title = value;
    }
    resetTitle() {
        this._title = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get titleInput() {
        return this._title;
    }
    // type - computed: true, optional: false, required: false
    get type() {
        return this.getStringAttribute('type');
    }
    get zone() {
        return this.getStringAttribute('zone');
    }
    set zone(value) {
        this._zone = value;
    }
    // Temporarily expose input value. Use with caution.
    get zoneInput() {
        return this._zone;
    }
    get properties() {
        return this._properties;
    }
    putProperties(value) {
        this._properties.internalValue = value;
    }
    resetProperties() {
        this._properties.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get propertiesInput() {
        return this._properties.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            id: cdktf.stringToTerraform(this._id),
            maintenance_window_dow: cdktf.stringToTerraform(this._maintenanceWindowDow),
            maintenance_window_time: cdktf.stringToTerraform(this._maintenanceWindowTime),
            name: cdktf.stringToTerraform(this._name),
            plan: cdktf.stringToTerraform(this._plan),
            powered: cdktf.booleanToTerraform(this._powered),
            title: cdktf.stringToTerraform(this._title),
            zone: cdktf.stringToTerraform(this._zone),
            properties: managedDatabaseMysqlPropertiesToTerraform(this._properties.internalValue),
        };
    }
}
exports.ManagedDatabaseMysql = ManagedDatabaseMysql;
_g = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysql[_g] = { fqn: "@cdktf/provider-upcloud.managedDatabaseMysql.ManagedDatabaseMysql", version: "4.0.2" };
// =================
// STATIC PROPERTIES
// =================
ManagedDatabaseMysql.tfResourceType = "upcloud_managed_database_mysql";
//# sourceMappingURL=data:application/json;base64,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