import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServerGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Is group an anti-affinity group. Setting this to true will result in all servers in the group being placed on separate compute hosts.
                  NOTE: this is an experimental feature. The anti-affinity policy is "best-effort" and it is not
                  guaranteed that all the servers will end up on a separate compute hosts. You can verify if the
                  anti-affinity policies are met by requesting a server group details from API. For more information
                  please see UpCloud API documentation on server groups
                  Plese also note that anti-affinity policies are only applied on server start. This means that if anti-affinity
                  policies in server group are not met, you need to manually restart the servers in said group,
                  for example via API, UpCloud Control Panel or upctl (UpCloud CLI)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server_group#anti_affinity ServerGroup#anti_affinity}
    */
    readonly antiAffinity?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server_group#id ServerGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels for your server group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server_group#labels ServerGroup#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * UUIDs of the servers that are members of this group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server_group#members ServerGroup#members}
    */
    readonly members?: string[];
    /**
    * Title of your server group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server_group#title ServerGroup#title}
    */
    readonly title: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/server_group upcloud_server_group}
*/
export declare class ServerGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_server_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/server_group upcloud_server_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServerGroupConfig
    */
    constructor(scope: Construct, id: string, config: ServerGroupConfig);
    private _antiAffinity?;
    get antiAffinity(): boolean | cdktf.IResolvable;
    set antiAffinity(value: boolean | cdktf.IResolvable);
    resetAntiAffinity(): void;
    get antiAffinityInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    resetMembers(): void;
    get membersInput(): string[] | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
