# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Route']


class Route(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteDestinationArgs']]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preserve_host: Optional[pulumi.Input[bool]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 regex_priority: Optional[pulumi.Input[int]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteSourceArgs']]]]] = None,
                 strip_path: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a Route resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['destinations'] = destinations
            __props__['hosts'] = hosts
            __props__['methods'] = methods
            __props__['name'] = name
            __props__['paths'] = paths
            __props__['preserve_host'] = preserve_host
            if protocols is None:
                raise TypeError("Missing required property 'protocols'")
            __props__['protocols'] = protocols
            __props__['regex_priority'] = regex_priority
            if service_id is None:
                raise TypeError("Missing required property 'service_id'")
            __props__['service_id'] = service_id
            __props__['snis'] = snis
            __props__['sources'] = sources
            __props__['strip_path'] = strip_path
        super(Route, __self__).__init__(
            'kong:index/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteDestinationArgs']]]]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            preserve_host: Optional[pulumi.Input[bool]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            regex_priority: Optional[pulumi.Input[int]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteSourceArgs']]]]] = None,
            strip_path: Optional[pulumi.Input[bool]] = None) -> 'Route':
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["destinations"] = destinations
        __props__["hosts"] = hosts
        __props__["methods"] = methods
        __props__["name"] = name
        __props__["paths"] = paths
        __props__["preserve_host"] = preserve_host
        __props__["protocols"] = protocols
        __props__["regex_priority"] = regex_priority
        __props__["service_id"] = service_id
        __props__["snis"] = snis
        __props__["sources"] = sources
        __props__["strip_path"] = strip_path
        return Route(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Optional[Sequence['outputs.RouteDestination']]]:
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def methods(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="preserveHost")
    def preserve_host(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "preserve_host")

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="regexPriority")
    def regex_priority(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "regex_priority")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter
    def snis(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "snis")

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence['outputs.RouteSource']]]:
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="stripPath")
    def strip_path(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "strip_path")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

