from typing import Iterable, Optional, Union

from notecoin.okex.common.exceptions import OkexParamsException
from notecoin.okex.v5.client.base import BaseClient
from notecoin.okex.v5.consts import *
from notecoin.okex.v5.types import CcyType
from notecoin.okex.v5.utils import enum_to_str, iterable_to_str


class AssetAPI(BaseClient):

    def __init__(self, *args, **kwargs):
        super(AssetAPI, self).__init__(*args, **kwargs)

    def deposit_address(self, ccy: Union[CcyType, str]):
        params = {}
        if ccy is not None:
            params['ccy'] = enum_to_str(ccy)

        data = self._request_with_params(GET, DEPOSIT_ADDRESS, params)["data"]

        return data

    def balances(self, ccy: Optional[Union[CcyType, str, Iterable[Union[CcyType, str]]]] = None):
        params = {}
        if ccy is not None:
            if isinstance(ccy, Iterable):
                ccyList = list(ccy)
                if len(ccyList) > 20:
                    raise OkexParamsException("支持多个ccy查询（不超过20个）")
                else:
                    params['ccy'] = iterable_to_str(ccyList)
            else:
                params['ccy'] = enum_to_str(ccy)

        data = self._request_with_params(GET, BALANCES, params)["data"]

        return data
