# lusid-workflow-sdk
FINBOURNE Technology

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.162
- Package version: 0.1.162
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen
For more information, please visit [https://www.finbourne.com](https://www.finbourne.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import lusid_workflow
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lusid_workflow
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import lusid_workflow
from lusid_workflow.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://www.lusid.com/workflow
# See configuration.py for a list of all supported configuration parameters.
configuration = lusid_workflow.Configuration(
    host = "https://www.lusid.com/workflow"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: oauth2
configuration = lusid_workflow.Configuration(
    host = "https://www.lusid.com/workflow"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with lusid_workflow.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = lusid_workflow.TaskDefinitionsApi(api_client)
    create_task_definition_request = {"id":{"scope":"A1","code":"ZZZ"},"displayName":"An example TaskDefinition","description":"Test","fields":[{"name":"clientId","type":"String"},{"name":"assignee","type":"String"},{"name":"resolutionDetail","type":"String"}],"states":[{"type":"Input","name":"Submitted"},{"type":"Internal","name":"InProgress"},{"type":"Internal","name":"SendingSurvey"},{"type":"Output","name":"Done"},{"type":"Output","name":"SurveyNotSent"},{"type":"Output","name":"NotDone"}],"transitions":[{"from":"Submitted","to":"InProgress","trigger":"start","guard":"fields.assignee exists AND fields.assignee NOT eq ''"},{"from":"InProgress","to":"SendingSurvey","trigger":"resolve","guard":"fields.resolutionDetail exists AND fields.resolutionDetail NOT eq ''","output":"sendSurvey"},{"from":"SendingSurvey","to":"Done","trigger":"success"},{"from":"SendingSurvey","to":"SurveyNotSent","trigger":"failure"},{"from":"SendingSurvey","to":"NotDone","trigger":"timeout"},{"from":"InProgress","to":"NotDone","trigger":"cancel","guard":"fields.cancellationDetail exists AND fields.cancellationDetail NOT eq ''"}],"triggers":[{"name":"start","schema":{"type":"External","timeInState":0}},{"name":"cancel","schema":{"type":"External","timeInState":0}},{"name":"resolve","schema":{"type":"External","timeInState":0}},{"name":"timeout","schema":{"type":"Timeout","timeInState":30}},{"name":"success","schema":{"type":"WebHook","timeInState":0,"responseCodes":{"in":[200]}}},{"name":"failure","schema":{"type":"WebHook","timeInState":0,"responseCodes":{"notIn":[200]}}}],"initialState":{"name":"Submitted","requiredFields":["clientId"]},"outputs":[{"name":"a web hook","schema":{"requestDetails":{"method":"Get","url":"www.zzz.com","parameters":[{"kind":"Query","key":"client_id","value":"ZZZ"}],"expectedHttpResponseCodes":["200"]},"type":"WebHook"}}]} # CreateTaskDefinitionRequest | The data to create a Task Definition

    try:
        # [EXPERIMENTAL] CreateTaskDefinition: Create a new Task Definition.
        api_response = api_instance.create_task_definition(create_task_definition_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling TaskDefinitionsApi->create_task_definition: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://www.lusid.com/workflow*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*TaskDefinitionsApi* | [**create_task_definition**](docs/TaskDefinitionsApi.md#create_task_definition) | **POST** /api/taskdefinitions | [EXPERIMENTAL] CreateTaskDefinition: Create a new Task Definition.
*TaskDefinitionsApi* | [**create_task_instance**](docs/TaskDefinitionsApi.md#create_task_instance) | **POST** /api/taskdefinitions/{scope}/{code} | [EXPERIMENTAL] CreateTaskInstance: Create a new Task Instance.
*TaskDefinitionsApi* | [**delete_task_definition**](docs/TaskDefinitionsApi.md#delete_task_definition) | **DELETE** /api/taskdefinitions/{scope}/{code} | [EXPERIMENTAL] DeleteTaskDefinition: Delete a Task Definition.
*TaskDefinitionsApi* | [**get_task_definition**](docs/TaskDefinitionsApi.md#get_task_definition) | **GET** /api/taskdefinitions/{scope}/{code} | [EXPERIMENTAL] GetTaskDefinition: Get a Task Definition.
*TaskDefinitionsApi* | [**get_task_instances_for_definition**](docs/TaskDefinitionsApi.md#get_task_instances_for_definition) | **GET** /api/taskdefinitions/{scope}/{code}/instances | [EXPERIMENTAL] GetTaskInstancesForDefinition: Get all Task Instances based on a Task Definition
*TaskDefinitionsApi* | [**list_task_definitions**](docs/TaskDefinitionsApi.md#list_task_definitions) | **GET** /api/taskdefinitions/{scope} | [EXPERIMENTAL] ListTaskDefinitions: List Task Definitions
*TaskDefinitionsApi* | [**update_task_definition**](docs/TaskDefinitionsApi.md#update_task_definition) | **PUT** /api/taskdefinitions/{scope}/{code} | [EXPERIMENTAL] UpdateTaskDefinition: Update an existing Task Definition.
*TaskInstancesApi* | [**get_task_instance**](docs/TaskInstancesApi.md#get_task_instance) | **GET** /api/taskinstances/{id} | [EXPERIMENTAL] GetTaskInstance: Get a Task Instance.
*TaskInstancesApi* | [**invoke_trigger**](docs/TaskInstancesApi.md#invoke_trigger) | **POST** /api/taskinstances/{id} | [EXPERIMENTAL] InvokeTrigger: Invoke a Task Instance Trigger.


## Documentation For Models

 - [CreateTaskDefinitionRequest](docs/CreateTaskDefinitionRequest.md)
 - [CreateTaskInstanceRequest](docs/CreateTaskInstanceRequest.md)
 - [DeletedEntityResponse](docs/DeletedEntityResponse.md)
 - [FieldInstance](docs/FieldInstance.md)
 - [FieldSchema](docs/FieldSchema.md)
 - [HistoryEntry](docs/HistoryEntry.md)
 - [InitialState](docs/InitialState.md)
 - [Link](docs/Link.md)
 - [LusidProblemDetails](docs/LusidProblemDetails.md)
 - [LusidValidationProblemDetails](docs/LusidValidationProblemDetails.md)
 - [Output](docs/Output.md)
 - [OutputSchema](docs/OutputSchema.md)
 - [OutputType](docs/OutputType.md)
 - [ResourceId](docs/ResourceId.md)
 - [ResourceListOfTaskDefinition](docs/ResourceListOfTaskDefinition.md)
 - [ResourceListOfTaskInstance](docs/ResourceListOfTaskInstance.md)
 - [State](docs/State.md)
 - [Status](docs/Status.md)
 - [TaskDefinition](docs/TaskDefinition.md)
 - [TaskDefinitionId](docs/TaskDefinitionId.md)
 - [TaskInstance](docs/TaskInstance.md)
 - [TransitTaskInstanceRequest](docs/TransitTaskInstanceRequest.md)
 - [Transition](docs/Transition.md)
 - [Trigger](docs/Trigger.md)
 - [TriggerInvocationResponse](docs/TriggerInvocationResponse.md)
 - [TriggerSchema](docs/TriggerSchema.md)
 - [UpdateTaskDefinitionRequest](docs/UpdateTaskDefinitionRequest.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://lusid.okta.com/oauth2/default/v1/authorize
- **Scopes**: N/A


## Author

info@finbourne.com


