import cdk = require('@aws-cdk/cdk');
/**
 * Properties for defining a `AWS::SQS::Queue`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html
 */
export interface CfnQueueProps {
    /**
     * `AWS::SQS::Queue.ContentBasedDeduplication`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
     */
    readonly contentBasedDeduplication?: boolean | cdk.Token;
    /**
     * `AWS::SQS::Queue.DelaySeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-delayseconds
     */
    readonly delaySeconds?: number | cdk.Token;
    /**
     * `AWS::SQS::Queue.FifoQueue`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
     */
    readonly fifoQueue?: boolean | cdk.Token;
    /**
     * `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsdatakeyreuseperiodseconds
     */
    readonly kmsDataKeyReusePeriodSeconds?: number | cdk.Token;
    /**
     * `AWS::SQS::Queue.KmsMasterKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsmasterkeyid
     */
    readonly kmsMasterKeyId?: string;
    /**
     * `AWS::SQS::Queue.MaximumMessageSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-maxmesgsize
     */
    readonly maximumMessageSize?: number | cdk.Token;
    /**
     * `AWS::SQS::Queue.MessageRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-msgretentionperiod
     */
    readonly messageRetentionPeriod?: number | cdk.Token;
    /**
     * `AWS::SQS::Queue.QueueName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-name
     */
    readonly queueName?: string;
    /**
     * `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-receivemsgwaittime
     */
    readonly receiveMessageWaitTimeSeconds?: number | cdk.Token;
    /**
     * `AWS::SQS::Queue.RedrivePolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-redrive
     */
    readonly redrivePolicy?: object | cdk.Token;
    /**
     * `AWS::SQS::Queue.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#cfn-sqs-queue-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SQS::Queue.VisibilityTimeout`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-visiblitytimeout
     */
    readonly visibilityTimeout?: number | cdk.Token;
}
/**
 * A CloudFormation `AWS::SQS::Queue`
 *
 * @cloudformationResource AWS::SQS::Queue
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html
 */
export declare class CfnQueue extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::SQS::Queue";
    /**
     * @cloudformationAttribute Arn
     */
    readonly queueArn: string;
    /**
     * @cloudformationAttribute QueueName
     */
    readonly queueName: string;
    readonly queueUrl: string;
    /**
     * The `TagManager` handles setting, removing and formatting tags
     *
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SQS::Queue`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnQueueProps);
    readonly propertyOverrides: CfnQueueProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SQS::QueuePolicy`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html
 */
export interface CfnQueuePolicyProps {
    /**
     * `AWS::SQS::QueuePolicy.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-policydoc
     */
    readonly policyDocument: object | cdk.Token;
    /**
     * `AWS::SQS::QueuePolicy.Queues`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-queues
     */
    readonly queues: string[];
}
/**
 * A CloudFormation `AWS::SQS::QueuePolicy`
 *
 * @cloudformationResource AWS::SQS::QueuePolicy
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html
 */
export declare class CfnQueuePolicy extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::SQS::QueuePolicy";
    /**
     * Create a new `AWS::SQS::QueuePolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnQueuePolicyProps);
    readonly propertyOverrides: CfnQueuePolicyProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
