# mypy-boto3-cloud9

[![PyPI - mypy-boto3-cloud9](https://img.shields.io/pypi/v/mypy-boto3-cloud9.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloud9)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloud9.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloud9)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Cloud9 1.14.58](https://boto3.amazonaws.com/v1/documentation/api/1.14.58/reference/services/cloud9.html#Cloud9) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-cloud9](#mypy-boto3-cloud9)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Cloud9` service.

```bash
python -m pip install boto3-stubs[cloud9]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[cloud9]` in your environment: `python -m pip install 'boto3-stubs[cloud9]'`

Both type checking and auto-complete should work for `Cloud9` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[cloud9]` in your environment: `python -m pip install 'boto3-stubs[cloud9]'`

Both type checking and auto-complete should work for `Cloud9` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[cloud9]` in your environment: `python -m pip install 'boto3-stubs[cloud9]'`
- Run `mypy` as usual

Type checking should work for `Cloud9` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[cloud9]` in your environment: `python -m pip install 'boto3-stubs[cloud9]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Cloud9` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`Cloud9Client` provides annotations for `boto3.client("cloud9")`.

```python
import boto3

from mypy_boto3_cloud9 import Cloud9Client

client: Cloud9Client = boto3.client("cloud9")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: Cloud9Client = session.client("cloud9")
```

### Paginators annotations

`mypy_boto3_cloud9.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_cloud9 import Cloud9Client
from mypy_boto3_cloud9.paginator import (
    DescribeEnvironmentMembershipsPaginator,
    ListEnvironmentsPaginator,
)

client: Cloud9Client = boto3.client("cloud9")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_environment_memberships_paginator: DescribeEnvironmentMembershipsPaginator = client.get_paginator("describe_environment_memberships")
list_environments_paginator: ListEnvironmentsPaginator = client.get_paginator("list_environments")
```







### Typed dictionations

`mypy_boto3_cloud9.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_cloud9.type_defs import (
    CreateEnvironmentEC2ResultTypeDef,
    CreateEnvironmentMembershipResultTypeDef,
    DescribeEnvironmentMembershipsResultTypeDef,
    DescribeEnvironmentsResultTypeDef,
    DescribeEnvironmentStatusResultTypeDef,
    EnvironmentLifecycleTypeDef,
    EnvironmentMemberTypeDef,
    EnvironmentTypeDef,
    ListEnvironmentsResultTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    TagTypeDef,
    UpdateEnvironmentMembershipResultTypeDef,
)

def get_structure() -> EnvironmentLifecycleTypeDef:
    return {
      ...
    }
```
