"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SAMLProvider = exports.SAMLProviderProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ram_generated_1 = require("./ram.generated");
Object.defineProperty(exports, "SAMLProviderProperty", { enumerable: true, get: function () { return ram_generated_1.RosSAMLProvider; } });
/**
 * A ROS resource type:  `ALIYUN::RAM::SAMLProvider`
 */
class SAMLProvider extends ros.Resource {
    /**
     * Create a new `ALIYUN::RAM::SAMLProvider`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSAMLProvider = new ram_generated_1.RosSAMLProvider(this, id, {
            samlProviderName: props.samlProviderName,
            description: props.description,
            samlMetadataDocumentUrl: props.samlMetadataDocumentUrl,
            samlMetadataDocument: props.samlMetadataDocument,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSAMLProvider;
        this.attrArn = rosSAMLProvider.attrArn;
        this.attrSamlProviderName = rosSAMLProvider.attrSamlProviderName;
    }
}
exports.SAMLProvider = SAMLProvider;
//# sourceMappingURL=data:application/json;base64,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