# Generated by Django 2.1.3 on 2018-11-06 08:14

from typing import List

from django.db import models, migrations


class Migration(migrations.Migration):

    initial = True

    dependencies: List = []

    operations = [
        migrations.CreateModel(
            name='Constant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('key', models.SlugField(help_text='The key that can be used in tags to include the value.<br/>For example: <code>{{ ga_id }}</code>.', max_length=255, unique=True)),
                ('value', models.CharField(help_text='The value to be rendered when this constant is included.', max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('active', models.BooleanField(default=True, help_text='Uncheck to disable this tag from being included, or when using a trigger to include this tag.')),
                ('priority', models.SmallIntegerField(default=0, help_text='Define how early on this tag should load as compared to other tags. A higher number will load sooner. For example:<br/> - A tag with a priority of 3 will load before a tag with priority 1.<br/> - A tag with a priority 0 will load before a tag with priority -1.<br/><em>Please note that with instanly loading tags, the priority is only compared to tags that load in the same document location.</em>')),
                ('tag_type', models.CharField(choices=[('functional', 'Functional'), ('analytical', 'Analytical'), ('traceable', 'Traceable')], default='functional', help_text='The purpose of this tag. Will decide if and when this tag is loaded on a per-user basis.', max_length=10)),
                ('tag_location', models.CharField(choices=[('0_top_head', 'Top of head tag'), ('1_bottom_head', 'Bottom of head tag'), ('2_top_body', 'Top of body tag'), ('3_bottom_body', 'Bottom of body tag')], default='0_top_head', help_text='Where in the document this tag will be inserted. Only applicable for tags that load instantly.', max_length=14)),
                ('tag_loading', models.CharField(choices=[('instant_load', 'Instant'), ('lazy_load', 'Lazy')], default='instant_load', help_text='<b>Instant:</b> include this tag in the document when the initial request is made.<br/><b>Lazy:</b> include this tag after the page has finished loading.', max_length=12)),
                ('content', models.TextField(help_text='The tag to be added or script to be executed.Will assume the content is a script if no explicit tag has been added.')),
            ],
            options={
                'ordering': ['tag_loading', '-active', 'tag_location', '-priority'],
            },
        ),
        migrations.CreateModel(
            name='Trigger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('active', models.BooleanField(default=True, help_text='Uncheck to disable this trigger from firing.')),
                ('pattern', models.CharField(help_text="The regex pattern to match the full url path with. Groups will be added to the included tag's context.", max_length=255)),
                ('tags', models.ManyToManyField(help_text='The tags to include when this trigger is fired.', to='wagtail_tag_manager.Tag')),
            ],
        ),
        migrations.CreateModel(
            name='Variable',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('key', models.SlugField(help_text='The key that can be used in tags to include the value.<br/>For example: <code>{{ path }}</code>.', max_length=255, unique=True)),
                ('variable_type', models.CharField(choices=[('HTTP', (('path', 'Path'), ('_repath+', 'Path with regex'))), ('User', (('user.pk', 'User'), ('session.session_key', 'Session'))), ('Wagtail', (('site', 'Site'),)), ('Other', (('_cookie+', 'Cookie'), ('_random', 'Random number')))], help_text='<b>Path:</b> the path of the visited page.<br/><b>Path with regex:</b> the path of the visited page after applying a regex search.<br/><b>User:</b> the ID of a user, when available.<br/><b>Session:</b> the session key.<br/><b>Site:</b> the name of the site.<br/><b>Cookie:</b> the value of a cookie, when available.<br/><b>Random number:</b> a random number.', max_length=255)),
                ('value', models.CharField(blank=True, help_text='<b>Path with regex:</b> the pattern to search the path with.<br/><b>Cookie:</b> the name of the cookie.', max_length=255, null=True)),
            ],
        ),
    ]
