# Generated by Django 2.1.3 on 2018-11-11 18:54

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('wagtail_tag_manager', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CookieDeclaration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cookie_type', models.CharField(blank=True, choices=[('functional', 'Functional'), ('analytical', 'Analytical'), ('traceable', 'Traceable')], help_text='The type of functionality this cookie supports.', max_length=10, null=True)),
                ('name', models.CharField(help_text='The name of this cookie.', max_length=255)),
                ('domain', models.CharField(help_text='The domain (including subdomain if applicable) of the cookie.<br/>For example: <code>.wagtail.io</code>.', max_length=255)),
                ('purpose', models.TextField(help_text='What this cookie is being used for.')),
                ('duration_value', models.PositiveSmallIntegerField(blank=True, null=True)),
                ('duration_period', models.CharField(choices=[('session', 'Session'), ('seconds+', 'Second(s)'), ('minutes+', 'Minute(s)'), ('hours+', 'Hour(s)'), ('days+', 'Day(s)'), ('weeks+', 'Week(s)'), ('months+', 'Month(s)'), ('years+', 'Year(s)')], help_text='The period after which the cookie will expire.<br/><b>Session:</b> the cookie will expire when the browser is closed.', max_length=10, null=True)),
                ('security', models.CharField(choices=[('http', 'HTTP'), ('https', 'HTTPS')], default='http', help_text='Whether this cookie is secure or not.', max_length=5)),
            ],
            options={
                'ordering': ['domain', 'cookie_type', 'name'],
            },
        ),
        migrations.AlterUniqueTogether(
            name='cookiedeclaration',
            unique_together={('name', 'domain')},
        ),
    ]
