#  SPDX-License-Identifier: Apache-2.0
"""
subarulink - A Python Package for interacting with Subaru Starlink Remote Services API.

const.py - constants used with this package

For more details about this api, please refer to the documentation at
https://github.com/G-Two/subarulink
"""

SERVICE_REQ_ID = "serviceRequestId"

# Remote start constants
TEMP = "climateZoneFrontTemp"
TEMP_MAX = 85
TEMP_MIN = 60

CLIMATE = "climateSettings"
CLIMATE_DEFAULT = "climateSettings"

RUNTIME = "runTimeMinutes"
RUNTIME_DEFAULT = "10"

MODE = "climateZoneFrontAirMode"
MODE_DEFROST = "WINDOW"
MODE_FEET_DEFROST = "FEET_WINDOW"
MODE_FACE = "FACE"
MODE_FEET = "FEET"
MODE_SPLIT = "FEET_FACE_BALANCED"
MODE_AUTO = "AUTO"

HEAT_SEAT_LEFT = "heatedSeatFrontLeft"
HEAT_SEAT_RIGHT = "heatedSeatFrontRight"
HEAT_SEAT_ON = "ON"
HEAT_SEAT_OFF = "OFF"

REAR_DEFROST = "heatedRearWindowActive"
REAR_DEFROST_ON = "true"
REAR_DEFROST_OFF = "false"

FAN_SPEED = "climateZoneFrontAirVolume"
FAN_SPEED_LOW = "2"
FAN_SPEED_MED = "4"
FAN_SPEED_HI = "7"
FAN_SPEED_AUTO = "AUTO"

RECIRCULATE = "outerAirCirculation"
RECIRCULATE_OFF = "outsideAir"
RECIRCULATE_ON = "recirculation"

REAR_AC = "airConditionOn"
REAR_AC_ON = "true"
REAR_AC_OFF = "false"

START_CONFIG = "startConfiguration"
START_CONFIG_DEFAULT = "start_Climate_Control_only_allow_key_in_ignition"

# Unlock doors constants
WHICH_DOOR = "unlockDoorType"
ALL_DOORS = "ALL_DOORS_CMD"
DRIVERS_DOOR = "FRONT_LEFT_DOOR_CMD"

# Location data constants
HEADING = "heading"
LATITUDE = "latitude"
LONGITUDE = "longitude"
LOCATION_TIME = "locationTimestamp"
SPEED = "speed"
BAD_LATITUDE = 90.0
BAD_LONGITUDE = 180.0

# Vehicle status constants
AVG_FUEL_CONSUMPTION = "AVG_FUEL_CONSUMPTION"
BATTERY_VOLTAGE = "BATTERY_VOLTAGE"
DIST_TO_EMPTY = "DISTANCE_TO_EMPTY_FUEL"
DOOR_BOOT_POSITION = "DOOR_BOOT_POSITION"
DOOR_ENGINE_HOOD_POSITION = "DOOR_ENGINE_HOOD_POSITION"
DOOR_FRONT_LEFT_POSITION = "DOOR_FRONT_LEFT_POSITION"
DOOR_FRONT_RIGHT_POSITION = "DOOR_FRONT_RIGHT_POSITION"
DOOR_REAR_LEFT_POSITION = "DOOR_REAR_LEFT_POSITION"
DOOR_REAR_RIGHT_POSITION = "DOOR_REAR_RIGHT_POSITION"
EV_CHARGER_STATE_TYPE = "EV_CHARGER_STATE_TYPE"
EV_CHARGE_SETTING_AMPERE_TYPE = "EV_CHARGE_SETTING_AMPERE_TYPE"
EV_CHARGE_VOLT_TYPE = "EV_CHARGE_VOLT_TYPE"
EV_DISTANCE_TO_EMPTY = "EV_DISTANCE_TO_EMPTY"
EV_IS_PLUGGED_IN = "EV_IS_PLUGGED_IN"
EV_STATE_OF_CHARGE_MODE = "EV_STATE_OF_CHARGE_MODE"
EV_STATE_OF_CHARGE_PERCENT = "EV_STATE_OF_CHARGE_PERCENT"
EV_TIME_TO_FULLY_CHARGED = "EV_TIME_TO_FULLY_CHARGED"
EXTERNAL_TEMP = "EXT_EXTERNAL_TEMP"
ODOMETER = "ODOMETER"
POSITION_TIMESTAMP = "POSITION_TIMESTAMP"
TIMESTAMP = "TIMESTAMP"
TIRE_PRESSURE_FL = "TYRE_PRESSURE_FRONT_LEFT"
TIRE_PRESSURE_FR = "TYRE_PRESSURE_FRONT_RIGHT"
TIRE_PRESSURE_RL = "TYRE_PRESSURE_REAR_LEFT"
TIRE_PRESSURE_RR = "TYRE_PRESSURE_REAR_RIGHT"
VEHICLE_STATE = "VEHICLE_STATE_TYPE"

# Erroneous Values
BAD_AVG_FUEL_CONSUMPTION = "16383"
BAD_DISTANCE_TO_EMPTY_FUEL = "16383"
BAD_EV_TIME_TO_FULLY_CHARGED = "65535"
BAD_TIRE_PRESSURE = "32767"
BAD_ODOMETER = None
BAD_SENSOR_VALUES = [
    BAD_AVG_FUEL_CONSUMPTION,
    BAD_DISTANCE_TO_EMPTY_FUEL,
    BAD_EV_TIME_TO_FULLY_CHARGED,
    BAD_TIRE_PRESSURE,
    BAD_ODOMETER,
]

# Timestamp Formats
TIMESTAMP_FMT = "%Y-%m-%dT%H:%M:%S%z"  # "2020-04-25T23:35:55+0000"
POSITION_TIMESTAMP_FMT = "%Y-%m-%dT%H:%M:%SZ"  # "2020-04-25T23:35:55Z"
