# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from arthur_client.api_bindings.models.d_type import DType
from typing import Optional, Set
from typing_extensions import Self

class BaseLiteralParameterSchema(BaseModel):
    """
    BaseLiteralParameterSchema
    """ # noqa: E501
    parameter_key: StrictStr = Field(description="Name of the parameter.")
    friendly_name: StrictStr = Field(description="User facing name of the parameter.")
    description: StrictStr = Field(description="Description of the parameter.")
    parameter_type: Optional[StrictStr] = 'literal'
    parameter_dtype: DType = Field(description="Data type of the parameter.")
    __properties: ClassVar[List[str]] = ["parameter_key", "friendly_name", "description", "parameter_type", "parameter_dtype"]

    @field_validator('parameter_type')
    def parameter_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['literal']):
            raise ValueError("must be one of enum values ('literal')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BaseLiteralParameterSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BaseLiteralParameterSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "parameter_key": obj.get("parameter_key"),
            "friendly_name": obj.get("friendly_name"),
            "description": obj.get("description"),
            "parameter_type": obj.get("parameter_type") if obj.get("parameter_type") is not None else 'literal',
            "parameter_dtype": obj.get("parameter_dtype")
        })
        return _obj


