# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from arthur_client.api_bindings.models.model_problem_type import ModelProblemType
from typing import Optional, Set
from typing_extensions import Self

class MetricsDatasetParameterSchema(BaseModel):
    """
    MetricsDatasetParameterSchema
    """ # noqa: E501
    parameter_key: StrictStr = Field(description="Name of the parameter.")
    friendly_name: StrictStr = Field(description="User facing name of the parameter.")
    description: StrictStr = Field(description="Description of the parameter.")
    parameter_type: Optional[StrictStr] = 'dataset'
    model_problem_type: Optional[ModelProblemType] = None
    optional: Optional[StrictBool] = Field(default=False, description="Boolean denoting if the parameter is optional.")
    __properties: ClassVar[List[str]] = ["parameter_key", "friendly_name", "description", "parameter_type", "model_problem_type", "optional"]

    @field_validator('parameter_type')
    def parameter_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['dataset']):
            raise ValueError("must be one of enum values ('dataset')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MetricsDatasetParameterSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if model_problem_type (nullable) is None
        # and model_fields_set contains the field
        if self.model_problem_type is None and "model_problem_type" in self.model_fields_set:
            _dict['model_problem_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MetricsDatasetParameterSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "parameter_key": obj.get("parameter_key"),
            "friendly_name": obj.get("friendly_name"),
            "description": obj.get("description"),
            "parameter_type": obj.get("parameter_type") if obj.get("parameter_type") is not None else 'dataset',
            "model_problem_type": obj.get("model_problem_type"),
            "optional": obj.get("optional") if obj.get("optional") is not None else False
        })
        return _obj


