// Copyright 2022 The envd Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package language

import (
	. "github.com/onsi/ginkgo/v2"

	"github.com/tensorchord/envd/e2e"
)

var _ = Describe("python", Ordered, func() {
	It("Should build packages successfully", func() {
		exampleName := "python/packages"
		testcase := "e2e"
		e := e2e.NewExample(buildContextDirWithName(exampleName), testcase)
		e.BuildImage(true)()
		e.RunContainer()()
		e.DestroyContainer()()
		e.RemoveImage()()
	})
	It("Should build requirements successfully", func() {
		exampleName := "python/requirements"
		testcase := "e2e"
		e := e2e.NewExample(buildContextDirWithName(exampleName), testcase)
		e.BuildImage(true)()
		e.RunContainer()()
		e.DestroyContainer()()
		e.RemoveImage()()
	})
	It("Should build hybrid successfully", func() {
		exampleName := "python/hybrid"
		testcase := "e2e"
		e := e2e.NewExample(buildContextDirWithName(exampleName), testcase)
		e.BuildImage(true)()
		e.RunContainer()()
		e.DestroyContainer()()
		e.RemoveImage()()
	})

	It("Should build conda with channel successfully", func() {
		exampleName := "python/conda"
		testcase := "e2e"
		e := e2e.NewExample(buildContextDirWithName(exampleName), testcase)
		e.BuildImage(true)()
		e.RunContainer()()
		e.DestroyContainer()()
		e.RemoveImage()()
	})
})
