/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.hadoop.util;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.hadoop.util.Crc32C;

public class TFRecordWriter {
    private final DataOutput output;

    public TFRecordWriter(DataOutput output) {
        this.output = output;
    }

    public void write(byte[] record, int offset, int length) throws IOException {
        byte[] len = this.toInt64LE(length);
        this.output.write(len);
        this.output.write(this.toInt32LE(Crc32C.maskedCrc32c(len)));
        this.output.write(record, offset, length);
        this.output.write(this.toInt32LE(Crc32C.maskedCrc32c(record, offset, length)));
    }

    public void write(byte[] record) throws IOException {
        this.write(record, 0, record.length);
    }

    private byte[] toInt64LE(long data) {
        byte[] buff = new byte[8];
        ByteBuffer bb = ByteBuffer.wrap(buff);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putLong(data);
        return buff;
    }

    private byte[] toInt32LE(int data) {
        byte[] buff = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(buff);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(data);
        return buff;
    }
}

