# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['marshmallow_geojson']

package_data = \
{'': ['*']}

install_requires = \
['marshmallow>=3.8.0,<4.0.0', 'ujson>=3.2.0,<4.0.0']

setup_kwargs = {
    'name': 'marshmallow-geojson',
    'version': '0.1.11',
    'description': 'Marshmallow schema validation for GeoJson',
    'long_description': '.. image:: https://travis-ci.org/folt/marshmallow-geojson.svg\n   :target: https://travis-ci.org/github/folt/marshmallow-geojson\n   :alt: Travis\n\n.. image:: https://codecov.io/gh/folt/marshmallow-geojson/branch/master/graph/badge.svg?token=B5ATYXLBHO\n   :target: https://codecov.io/gh/folt/marshmallow-geojson\n   :alt: Codecov\n\nmarshmallow_geojson 🌍\n======================\n\n====================   =======\nGeoJSON Objects        Status\n====================   =======\nPoint_                 ✅\nMultiPoint_            ❌\nLineString_            ❌\nMultiLineString_       ❌\nPolygon_               ❌\nMultiPolygon_          ❌\nGeometryCollection_    ❌\nFeature_               ❌\nFeatureCollection_     ❌\n====================   =======\n\nInstallation\n------------\n\nmarshmallow_geojson is compatible with Python 3.7 and 3.8.\nThe recommended way to install is via poetry_:\n\n.. code::\n\n  poetry add marshmallow_geojson\n\nUsing pip to install is also possible.\n\n.. code::\n\n  pip install marshmallow_geojson\n\nGEOJSON\n-------\nGeoJSON_ is a format for encoding a variety of geographic data structures.\n\n.. code-block::\n\n  {\n    "type": "Feature",\n    "geometry": {\n      "type": "Point",\n      "coordinates": [125.6, 10.1]\n    },\n    "properties": {\n      "name": "Dinagat Islands"\n    }\n  }\n\nGeoJSON supports the following geometry types: Point, LineString, Polygon,\nMultiPoint, MultiLineString, and MultiPolygon. Geometric objects with\nadditional properties are Feature objects. Sets of features are contained by\nFeatureCollection objects.\n\nPoint\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "Point",\n    "coordinates": [\n        -105.01621,\n        39.57422\n    ]\n  }\n\n\nMultiPoint\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "MultiPoint",\n    "coordinates": [\n        [\n            -105.01621,\n            39.57422\n        ],\n        [\n            -80.666513,\n            35.053994\n        ]\n    ]\n  }\n\n\nLineString\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "LineString",\n    "coordinates": [\n        [\n            -99.113159,\n            38.869651\n        ],\n        [\n            -99.0802,\n            38.85682\n        ],\n        [\n            -98.822021,\n            38.85682\n        ],\n        [\n            -98.448486,\n            38.848264\n        ]\n    ]\n  }\n\n\nMultiLineString\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "MultiLineString",\n    "coordinates": [\n        [\n              [\n                -105.019898,\n                39.574997\n            ],\n            [\n                -105.019598,\n                39.574898\n            ],\n            [\n                -105.019061,\n                39.574782\n            ]\n        ],\n        [\n            [\n                -105.017173,\n                39.574402\n            ],\n            [\n                -105.01698,\n                39.574385\n            ],\n            [\n                -105.016636,\n                39.574385\n            ],\n            [\n                -105.016508,\n                39.574402\n            ],\n            [\n                -105.01595,\n                39.57427\n            ]\n        ],\n        [\n            [\n                -105.014276,\n                39.573972\n            ],\n            [\n                -105.014126,\n                39.574038\n            ],\n            [\n                -105.013825,\n                39.57417\n            ],\n            [\n                -105.01331,\n                39.574452\n            ]\n        ]\n    ]\n  }\n\n\nPolygon\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "Polygon",\n    "coordinates": [\n        [\n            [\n                100,\n                0\n            ],\n            [\n                101,\n                0\n            ],\n            [\n                101,\n                1\n            ],\n            [\n                100,\n                1\n            ],\n            [\n                100,\n                0\n            ]\n        ]\n    ]\n  }\n\n\nMultiPolygon\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "MultiPolygon",\n    "coordinates": [\n        [\n            [\n                [\n                    107,\n                    7\n                ],\n                [\n                    108,\n                    7\n                ],\n                [\n                    108,\n                    8\n                ],\n                [\n                    107,\n                    8\n                ],\n                [\n                    107,\n                    7\n                ]\n            ]\n        ],\n        [\n            [\n                [\n                    100,\n                    0\n                ],\n                [\n                    101,\n                    0\n                ],\n                [\n                    101,\n                    1\n                ],\n                [\n                    100,\n                    1\n                ],\n                [\n                    100,\n                    0\n                ]\n            ]\n        ]\n    ]\n  }\n\n\nGeometryCollection\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "GeometryCollection",\n    "geometries": [\n        {\n            "type": "Point",\n            "coordinates": [\n                -80.660805,\n                35.049392\n            ]\n        },\n        {\n            "type": "Polygon",\n            "coordinates": [\n                [\n                    [\n                        -80.664582,\n                        35.044965\n                    ],\n                    [\n                        -80.663874,\n                        35.04428\n                    ],\n                    [\n                        -80.662586,\n                        35.04558\n                    ],\n                    [\n                        -80.663444,\n                        35.046036\n                    ],\n                    [\n                        -80.664582,\n                        35.044965\n                    ]\n                ]\n            ]\n        },\n        {\n            "type": "LineString",\n            "coordinates": [\n                [\n                    -80.662372,\n                    35.059509\n                ],\n                [\n                    -80.662693,\n                    35.059263\n                ],\n                [\n                    -80.662844,\n                    35.05893\n                ]\n            ]\n        }\n    ]\n  }\n\n\nFeature\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "Feature",\n    "geometry": {\n        "type": "Polygon",\n        "coordinates": [\n            [\n                [\n                    -80.724878,\n                    35.265454\n                ],\n                [\n                    -80.722646,\n                    35.260338\n                ],\n                [\n                    -80.720329,\n                    35.260618\n                ],\n                [\n                    -80.71681,\n                    35.255361\n                ],\n                [\n                    -80.704793,\n                    35.268397\n                ],\n                [\n                    -80.715179,\n                    35.267696\n                ],\n                [\n                    -80.721359,\n                    35.267276\n                ],\n                [\n                    -80.724878,\n                    35.265454\n                ]\n            ]\n        ]\n    },\n    "properties": {\n        "name": "Plaza Road Park"\n    }\n  }\n\n\nFeatureCollection\n------------------\nSimple example data:\n\n.. code-block::\n\n  {\n    "type": "FeatureCollection",\n    "features": [\n        {\n            "type": "Feature",\n            "geometry": {\n                "type": "Point",\n                "coordinates": [\n                    -80.870885,\n                    35.215151\n                ]\n            },\n            "properties": {\n                "name": "ABBOTT NEIGHBORHOOD PARK",\n                "address": "1300  SPRUCE ST"\n            }\n        },\n        {\n            "type": "Feature",\n            "geometry": {\n                "type": "Polygon",\n                "coordinates": [\n                    [\n                        [\n                            -80.724878,\n                            35.265454\n                        ],\n                        [\n                            -80.722646,\n                            35.260338\n                        ],\n                        [\n                            -80.720329,\n                            35.260618\n                        ],\n                        [\n                            -80.704793,\n                            35.268397\n                        ],\n\n                        [\n                            -80.724878,\n                            35.265454\n                        ]\n                    ]\n                ]\n            },\n            "properties": {\n                "name": "Plaza Road Park"\n            }\n        }\n    ]\n  }\n\n.. _GeoJSON: http://geojson.org/\n.. _poetry: https://python-poetry.org/\n',
    'author': 'Aliaksandr Vaskevich',
    'author_email': 'vaskevic.an@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/folt/marshmallow-geojson',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
