# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ecowitt2mqtt']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.7.4,<4.0.0',
 'asyncio-mqtt>=0.7.0,<0.8.0',
 'meteocalc>=1.1.0,<2.0.0']

entry_points = \
{'console_scripts': ['ecowitt2mqtt = ecowitt2mqtt.main:main']}

setup_kwargs = {
    'name': 'ecowitt2mqtt',
    'version': '1.0.11',
    'description': 'A small web server to send data from Ecowitt devices to an MQTT Broker',
    'long_description': "# 🔘 ecowitt2mqtt: Send Ecowitt device data to an MQTT broker\n\n[![PyPi](https://img.shields.io/pypi/v/ecowitt2mqtt.svg)](https://pypi.python.org/pypi/ecowitt2mqtt)\n[![Docker Hub](https://img.shields.io/docker/pulls/bachya/ecowitt2mqtt)](https://hub.docker.com/r/bachya/ecowitt2mqtt)\n[![Version](https://img.shields.io/pypi/pyversions/ecowitt2mqtt.svg)](https://pypi.python.org/pypi/ecowitt2mqtt)\n[![License](https://img.shields.io/pypi/l/ecowitt2mqtt.svg)](https://github.com/bachya/ecowitt2mqtt/blob/master/LICENSE)\n[![Maintainability](https://api.codeclimate.com/v1/badges/a03c9e96f19a3dc37f98/maintainability)](https://codeclimate.com/github/bachya/ecowitt2mqtt/maintainability)\n[![Say Thanks](https://img.shields.io/badge/SayThanks-!-1EAEDB.svg)](https://saythanks.io/to/bachya)\n\n`ecowitt2mqtt` is a small CLI/web server that allows [Ecowitt](http://www.ecowitt.com)\ndevice data to be sent to an MQTT broker.\n\n- [Installation](#installation)\n- [Python Versions](#python-versions)\n- [Quick Start](#quick-start)\n- [Advanced Usage](#advanced-usage)\n- [Contributing](#contributing)\n\n# Installation\n\n```python\npip install ecowitt2mqtt\n```\n\n# Python Versions\n\n`ecowitt2mqtt` is currently supported on:\n\n* Python 3.6\n* Python 3.7\n* Python 3.8 \n\n# Quick Start\n\nNote that this README assumes:\n\n* you have access to an MQTT broker\n* you have already paired your Ecowitt device with the WS View Android/iOS app from\n  Ecowitt.\n\nFirst, install `ecowitt2mqtt` via `pip`:\n\n```bash\n$ pip install ecowitt2mqtt\n```\n\nThen, shift over to the WS View app on your Android/iOS device. While viewing your\ndevice in the app, select `Weather Services`:\n\n![Select Weather Services](https://raw.githubusercontent.com/bachya/ecowitt2mqtt/dev/assets/1-weather-services.jpeg?raw=true)\n\nPress `Next` until you reach the `Customized` screen:\n\n![The Customized screen in the WS View app](https://raw.githubusercontent.com/bachya/ecowitt2mqtt/dev/assets/2-customized.jpeg?raw=true)\n\nFill out the form with these values and tap `Save`:\n\n* `Protocol Type Same As`: `Ecowitt`\n* `Server IP / Hostname`: the IP address/hostname of the device running `ecowitt2mqtt`\n* `Path`: `/data/report` (note that unlike the default in the WS View App, there shouldn't\n  be a trailing slash)\n* `Port`: `8080` (the default port on which `ecowitt2mqtt` is served)\n* `Upload Interval`: `60` (change this to alter the frequency with which data is published)\n\nThen, on the machine where you installed `ecowitt2mqtt`, run it:\n\n```bash\n$ ecowitt2mqtt \\\n    --mqtt-broker=192.168.1.101 \\\n    --mqtt-username=user \\\n    --mqtt-password=password \\\n    --mqtt-topic=ecowitt2mqtt/device_1\n```\n\nWithin the `Upload Interval`, data should begin to appear in the MQTT broker.\n\n# Advanced Usage\n\n## Command Line Interface\n\nThe `ecowitt2mqtt` executable contains several configurable parameters:\n```\nusage: ecowitt2mqtt [-h] --mqtt-broker MQTT_BROKER --mqtt-topic MQTT_TOPIC [--mqtt-port MQTT_PORT]\n                    [--mqtt-username MQTT_USERNAME] [--mqtt-password MQTT_PASSWORD]\n                    [--endpoint ENDPOINT] [--port PORT] [-l LOG_LEVEL]\n\nSend data from Ecowitt devices to an MQTT broker\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -l LOG_LEVEL, --log-level LOG_LEVEL\n                        The logging level (default: INFO)\n  --mqtt-broker MQTT_BROKER\n                        The hostname or IP address of the MQTT broker\n  --mqtt-port MQTT_PORT\n                        The port of the MQTT broker (default: 1883)\n  --mqtt-username MQTT_USERNAME\n                        The username to use with the MQTT broker (default: None)\n  --mqtt-password MQTT_PASSWORD\n                        The password to use with the MQTT broker (default: None)\n  --mqtt-topic MQTT_TOPIC\n                        The MQTT topic to publish the device's data to (default: ecowitt2mqtt/<ID>)\n  --hass-discovery      Publish data in the Home Assistant MQTT Discovery format\n  --hass-discovery-prefix HASS_DISCOVERY_PREFIX\n                        The Home Assistant discovery prefix to use (default: homeassistant)\n  --endpoint ENDPOINT   The relative endpoint/path to serve the web app on (default: /data/report)\n  --port PORT           The port to serve the web app on (default: 8080)\n  --unit-system UNIT_SYSTEM\n                        The unit system to use (default: imperial)\n```\n\n## Running in the Background\n\n`ecowitt2mqtt` doesn't, itself, provide any sort of daemonization mechanism. The suggested\nroute is to use something like [`supervisord`](http://www.supervisord.org):\n\n```\n[supervisord]\nnodaemon=true\nloglevel=info\nuser=root\n\n[program:ecowitt2mqtt]\ncommand=ecowitt2mqtt --mqtt-broker=192.168.1.101 --mqtt-username=user --mqtt-password=password\nstdout_logfile=/dev/stdout\nstdout_logfile_maxbytes=0\nredirect_stderr=true\n```\n\n## Home Assistant MQTT Discovery\n\n[Home Assistant](https://home-assistant.io) users can quickly add entities from an\nEcowitt device by using\n[MQTT Discovery](https://www.home-assistant.io/docs/mqtt/discovery/).\n\nOnce Home Assistant is configured to accept MQTT Discovery, `ecowitt2mqtt` simply needs\nthe `--hass-discovery` flag:\n\n```bash\n$ ecowitt2mqtt \\\n    --mqtt-broker=192.168.1.101 \\\n    --mqtt-username=user \\\n    --mqtt-password=password \\\n    --hass-discovery\n```\n\nNote that if both `--hass-discovery` and `--mqtt-topic` are provided, `--hass-discovery` will\nwin out.\n\n## Docker\n\nThe library is available via a Docker image\n([`bachya/ecowitt2mqtt`](https://hub.docker.com/r/bachya/ecowitt2mqtt)). It is configured\nby a handful of environment variables that correspond to the command line parameters\nlisted above:\n\n* `LOG_LEVEL:` the log level to use (default: `INFO`)\n* `MQTT_BROKER:` the hostname or IP address of the MQTT broker\n* `MQTT_PORT:` the port of the MQTT broker (default: `1883`)\n* `MQTT_PASSWORD:` the password to use with the MQTT broker (default: `None`)\n* `MQTT_USERNAME:` the password to use with the MQTT broker (default: `None`)\n* `MQTT_TOPIC:` the MQTT topic to publish the device's data to\n* `HASS_DISCOVERY`: whether to use Home Assistant MQTT Discovery (default: `false`)\n* `HASS_DISCOVERY_PREFIX`: the topic prefix to use for Home Assistant MQTT Discovery\n  (default: `homeassistant`)\n* `ENDPOINT:` the relative endpoint/path to serve the web app on (default: `/data/report`)\n* `PORT:` the port to serve the web app on (default: `8080`)\n* `UNIT_SYSTEM`: the unit system to use (`imperial` or `metric`) (default: `imperial`)\n\nRunning the image is straightforward:\n\n```\ndocker run -it \\\n    -e MQTT_BROKER=192.168.1.101 \\\n    -e MQTT_USERNAME=user \\\n    -e MQTT_PASSWORD=password \\\n    -p 8080:8080 \\\n    bachya/ecowitt2mqtt:latest\n```\n\nNote the value of the `-p` flag: you must expose the port defined by the `PORT`\nenvironment variable. In the example above, the default port (`8080`) is used and is\nexposed via the same port on the host.\n\n[`docker-compose`](https://docs.docker.com/compose/) users can find an example\nconfiguration file at\n[`docker-compose.dev.yml`](https://github.com/bachya/ecowitt2mqtt/blob/dev/docker-compose.dev.yml).\nNote that this is intended to be a dev environment for quickly testing the repo itself;\nin production, you should refer to one of the\n[Docker Hub](https://hub.docker.com/r/bachya/ecowitt2mqtt) images.\n\n# Contributing\n\n1. [Check for open features/bugs](https://github.com/bachya/ecowitt2mqtt/issues)\nor [initiate a discussion on one](https://github.com/bachya/ecowitt2mqtt/issues/new).\n2. [Fork the repository](https://github.com/bachya/ecowitt2mqtt/fork).\n3. (_optional, but highly recommended_) Create a virtual environment: `python3 -m venv .venv`\n4. (_optional, but highly recommended_) Enter the virtual environment: `source ./.venv/bin/activate`\n5. Install the dev environment: `script/setup`\n6. Code your new feature or bug fix.\n7. Update `README.md` with any new documentation.\n8. Add yourself to `AUTHORS.md`.\n9. Submit a pull request!\n",
    'author': 'Aaron Bach',
    'author_email': 'bachya1208@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/bachya/ecowitt2mqtt',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
