import platform
import sys

import napari
import pytest
import qtpy
from qtpy.QtCore import QCoreApplication

from PartSeg._launcher.main_window import MainWindow as LauncherMainWindow
from PartSeg._roi_analysis import main_window as analysis_main_window
from PartSeg._roi_mask import main_window as mask_main_window
from PartSeg.common_gui import napari_image_view

from .utils import CI_BUILD, GITHUB_ACTIONS, TRAVIS

napari_warnings = napari.__version__ == "0.3.4" and platform.system() == "Linux" and sys.version_info.minor == 8


def empty(*_):
    """To silent some functions"""
    pass


@pytest.fixture(autouse=True)
def disable_threads_viewer(monkeypatch):
    def _prepare_layers(self, image, parameters, replace):
        self._add_image(napari_image_view._prepare_layers(image, parameters, replace))

    monkeypatch.setattr(napari_image_view.ImageView, "_prepare_layers", _prepare_layers)

    def _add_layer_util(self, index, layer, filters):
        self.viewer.add_layer(layer)

    monkeypatch.setattr(napari_image_view.ImageView, "_add_layer_util", _add_layer_util)


class TestAnalysisMainWindow:
    # @pytest.mark.skipif((platform.system() == "Linux") and CI_BUILD, reason="vispy problem")
    @pytest.mark.skipif(
        (platform.system() == "Windows") and GITHUB_ACTIONS and sys.version_info.minor == 7, reason="need to debug"
    )
    @pytest.mark.skipif(qtpy.API_NAME == "PySide2", reason="PySide2 problem")
    @pytest.mark.skipif(napari_warnings, reason="warnings fail test")
    def test_opening(self, qtbot, tmpdir):
        main_window = analysis_main_window.MainWindow(tmpdir, initial_image=False)
        qtbot.addWidget(main_window)
        main_window.main_menu.batch_processing_btn.click()
        main_window.main_menu.advanced_btn.click()


class TestMaskMainWindow:
    # @pytest.mark.skipif((platform.system() == "Linux") and CI_BUILD, reason="vispy problem")
    @pytest.mark.skipif(qtpy.API_NAME == "PySide2", reason="PySide2 problem")
    @pytest.mark.skipif(napari_warnings, reason="warnings fail test")
    def test_opening(self, qtbot, tmpdir):
        main_window = mask_main_window.MainWindow(tmpdir, initial_image=False)
        qtbot.addWidget(main_window)


class TestLauncherMainWindow:
    def test_opening(self, qtbot):
        main_window = LauncherMainWindow("Launcher")
        qtbot.addWidget(main_window)

    # @pytest.mark.skipif((platform.system() == "Linux") and CI_BUILD, reason="vispy problem")
    @pytest.mark.skipif(qtpy.API_NAME == "PySide2", reason="PySide2 problem")
    @pytest.mark.skipif((platform.system() == "Windows") and CI_BUILD, reason="glBindFramebuffer with no OpenGL")
    def test_open_mask(self, qtbot, monkeypatch, tmp_path):
        monkeypatch.setattr(mask_main_window, "CONFIG_FOLDER", str(tmp_path))
        if platform.system() == "Linux" and (GITHUB_ACTIONS or TRAVIS):
            monkeypatch.setattr(mask_main_window.MainWindow, "show", empty)
        main_window = LauncherMainWindow("Launcher")
        qtbot.addWidget(main_window)
        main_window._launch_mask()
        with qtbot.waitSignal(main_window.prepare.finished):
            main_window.prepare.start()
        # qtbot.addWidget(main_window.wind)
        QCoreApplication.processEvents()
        main_window.wind.hide()

    # @pytest.mark.skipif((platform.system() == "Linux") and CI_BUILD, reason="vispy problem")
    @pytest.mark.skipif((platform.system() == "Windows") and CI_BUILD, reason="glBindFramebuffer with no OpenGL")
    @pytest.mark.skipif(qtpy.API_NAME == "PySide2", reason="PySide2 problem")
    def test_open_analysis(self, qtbot, monkeypatch, tmp_path):
        monkeypatch.setattr(analysis_main_window, "CONFIG_FOLDER", str(tmp_path))
        if platform.system() == "Linux" and (GITHUB_ACTIONS or TRAVIS):
            monkeypatch.setattr(analysis_main_window.MainWindow, "show", empty)
        main_window = LauncherMainWindow("Launcher")
        qtbot.addWidget(main_window)
        main_window._launch_analysis()
        with qtbot.waitSignal(main_window.prepare.finished):
            main_window.prepare.start()
        # qtbot.addWidget(main_window.wind)
        QCoreApplication.processEvents()
        main_window.wind.hide()
