/*
* Copyright © 2020 Contrast Security, Inc.
* See https://www.contrastsecurity.com/enduser-terms-0317a for more details.
*/
/* THIS FILE WAS AUTOMATICALLY GENERATED BY HOOKSPY */
/* Python requires its own header to always be included first */
#define PY_SSIZE_T_CLEAN
#include <Python.h>

#include <contrast/assess/propagate.h>
#include <contrast/assess/scope.h>
#include <contrast/assess/utils.h>

typedef PyObject *(*fastcall_func)(PyObject *, PyObject *const *, Py_ssize_t);
typedef PyObject *(*fastcall_kwargs_func)(PyObject *, PyObject *const *, Py_ssize_t, PyObject *);

#define BYTES_DECODE_OFFSET 4
#define BYTES_REPLACE_OFFSET 24
#define BYTES_SPLIT_OFFSET 31
#define BYTES_RSPLIT_OFFSET 29
#define BYTES_JOIN_OFFSET 18
#define BYTES_CAPITALIZE_OFFSET 1
#define BYTES_TITLE_OFFSET 36
#define BYTES_CENTER_OFFSET 2
#define BYTES_EXPANDTABS_OFFSET 6
#define BYTES_PARTITION_OFFSET 23
#define BYTES_LJUST_OFFSET 19
#define BYTES_LOWER_OFFSET 20
#define BYTES_LSTRIP_OFFSET 21
#define BYTES_RJUST_OFFSET 27
#define BYTES_RSTRIP_OFFSET 30
#define BYTES_RPARTITION_OFFSET 28
#define BYTES_SPLITLINES_OFFSET 32
#define BYTES_STRIP_OFFSET 34
#define BYTES_SWAPCASE_OFFSET 35
#define BYTES_TRANSLATE_OFFSET 37
#define BYTES_UPPER_OFFSET 38
#define BYTES_ZFILL_OFFSET 39


ternaryfunc bytes_decode_orig;
binaryfunc bytes_replace_orig;
ternaryfunc bytes_split_orig;
ternaryfunc bytes_rsplit_orig;
binaryfunc bytes_join_orig;
unaryfunc bytes_capitalize_orig;
unaryfunc bytes_title_orig;
binaryfunc bytes_center_orig;
ternaryfunc bytes_expandtabs_orig;
binaryfunc bytes_partition_orig;
binaryfunc bytes_ljust_orig;
unaryfunc bytes_lower_orig;
binaryfunc bytes_lstrip_orig;
binaryfunc bytes_rjust_orig;
binaryfunc bytes_rstrip_orig;
binaryfunc bytes_rpartition_orig;
ternaryfunc bytes_splitlines_orig;
binaryfunc bytes_strip_orig;
unaryfunc bytes_swapcase_orig;
binaryfunc bytes_translate_orig;
unaryfunc bytes_upper_orig;
binaryfunc bytes_zfill_orig;
newfunc bytes_new_orig;


HOOK_TERNARYFUNC(bytes_decode, "decode");
HOOK_BINARYFUNC(bytes_replace, "replace");
HOOK_TERNARYFUNC(bytes_split, "split");
HOOK_TERNARYFUNC(bytes_rsplit, "rsplit");
PyObject *bytes_join_new(PyObject *self, PyObject *args) {
    PyObject *list = PySequence_List(args);

    enter_propagation_scope();

    /* If this fails for any reason, just call the original function and get
     * out of here.
     */
    if (list == NULL) {
        PyErr_Clear();
        return bytes_join_orig((PyObject *)self, args);
    }

    /* In Py36+ we also hook an internal function that is called by this
     * function in order to propagate fstring formatting. We still want to have
     * a separate hook for join so that the events are reported differently.
     * This means that we need to go into scope when calling the original
     * function here so that we don't propagate twice.
     */
    PyObject *result = bytes_join_orig((PyObject *)self, list);
    exit_propagation_scope();

    PyObject *prop_args = PyTuple_Pack(1, list);

    if (prop_args == NULL || result == NULL)
        goto cleanup_and_exit;

    propagate_result("join", (PyObject *)self, result, prop_args, NULL);

cleanup_and_exit:
    Py_XDECREF(list);
    Py_XDECREF(prop_args);
    return result;

}

HOOK_UNARYFUNC(bytes_capitalize, "capitalize");
HOOK_UNARYFUNC(bytes_title, "title");
HOOK_BINARYFUNC(bytes_center, "center");
HOOK_TERNARYFUNC(bytes_expandtabs, "expandtabs");
HOOK_BINARYFUNC(bytes_partition, "partition");
HOOK_BINARYFUNC(bytes_ljust, "ljust");
HOOK_UNARYFUNC(bytes_lower, "lower");
HOOK_BINARYFUNC(bytes_lstrip, "lstrip");
HOOK_BINARYFUNC(bytes_rjust, "rjust");
HOOK_BINARYFUNC(bytes_rstrip, "rstrip");
HOOK_BINARYFUNC(bytes_rpartition, "rpartition");
HOOK_TERNARYFUNC(bytes_splitlines, "splitlines");
HOOK_BINARYFUNC(bytes_strip, "strip");
HOOK_UNARYFUNC(bytes_swapcase, "swapcase");
HOOK_BINARYFUNC(bytes_translate, "translate");
HOOK_UNARYFUNC(bytes_upper, "upper");
HOOK_BINARYFUNC(bytes_zfill, "zfill");
PyObject *bytes_new_new(PyTypeObject *type, PyObject *args, PyObject *kwds) {
    PyObject *result = bytes_new_orig(type, args, kwds);

    if (result == NULL)
        return result;

    propagate_result("CAST", NULL, result, args, kwds);

    return result;

}




int apply_bytes_patches(funchook_t *funchook) {

    ADD_METHOD_HOOK(PyBytes_Type, bytes_decode, BYTES_DECODE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_replace, BYTES_REPLACE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_split, BYTES_SPLIT_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_rsplit, BYTES_RSPLIT_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_join, BYTES_JOIN_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_capitalize, BYTES_CAPITALIZE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_title, BYTES_TITLE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_center, BYTES_CENTER_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_expandtabs, BYTES_EXPANDTABS_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_partition, BYTES_PARTITION_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_ljust, BYTES_LJUST_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_lower, BYTES_LOWER_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_lstrip, BYTES_LSTRIP_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_rjust, BYTES_RJUST_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_rstrip, BYTES_RSTRIP_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_rpartition, BYTES_RPARTITION_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_splitlines, BYTES_SPLITLINES_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_strip, BYTES_STRIP_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_swapcase, BYTES_SWAPCASE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_translate, BYTES_TRANSLATE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_upper, BYTES_UPPER_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_zfill, BYTES_ZFILL_OFFSET);
    ADD_NEWFUNC_HOOK(PyBytes_Type, bytes_new);

    /* Indicates success */
    return 0;
}

