# -*- coding: utf-8 -*-
# Copyright © 2020 Contrast Security, Inc.
# See https://www.contrastsecurity.com/enduser-terms-0317a for more details.
class ObjectShare(object):
    # Strings
    AND = "&"
    PIPE = "|"
    ASTERISK = "*"
    BACK_SLASH = "\\"
    EMPTY_STRING = ""
    COLON = ":"
    COMMA = ","
    DASH = "-"
    DOUBLE_QUOTE = '"'
    EQUALS = "="
    EXCLAMATION = "!"
    HTTP_SCORE = "HTTP_"
    HTTP_START = "http:"
    HTTPS_START = "https:"
    NEW_LINE = "\n"
    NONE_STRING = "None"
    PERIOD = "."
    PLUS_SIGN = "+"
    POUND_SIGN = "#"
    QUESTION_MARK = "?"
    RETURN = "\r"
    SEMICOLON = ";"
    SINGLE_QUOTE = "'"
    SLASH = "/"
    SPACE = " "
    UNDERSCORE = "_"
    AT = "@"
    LEFT_ANGLE = "<"
    RIGHT_ANGLE = ">"
    LEFT_BRACKET = "["
    RIGHT_BRACKET = "]"
    LEFT_PAREN = "("
    RIGHT_PAREN = ")"
    BACK_TICK = "`"

    DOUBLE_QUOTE_ESCAPED = "&quot;"

    CLASS = "class"
    CONTRAST_ASSESS_METHOD_START = "cs__assess_"
    CONTRAST_METHOD_START = "cs__"

    MODULE = "module"

    READ_FLAG = "r"
    WRITE_FLAG = "w"
    READ_WRITE_FLAG = "rw"

    PARENT_PATH = ".."

    CACHE = "cache"

    EMPTY_ARRAY = []

    UTF_8_ENCODING = "utf-8"

    # Messages
    OVERRIDE_MESSAGE = (
        "A security filter prevented original response from being returned."
    )
