# This file was auto-generated by Fern from our API Definition.

import os
import typing

import httpx
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.request_options import RequestOptions
from .environment import VellumEnvironment
from .raw_client import AsyncRawVellum, RawVellum
from .resources.ad_hoc.client import AdHocClient, AsyncAdHocClient
from .resources.container_images.client import AsyncContainerImagesClient, ContainerImagesClient
from .resources.deployments.client import AsyncDeploymentsClient, DeploymentsClient
from .resources.document_indexes.client import AsyncDocumentIndexesClient, DocumentIndexesClient
from .resources.documents.client import AsyncDocumentsClient, DocumentsClient
from .resources.events.client import AsyncEventsClient, EventsClient
from .resources.folder_entities.client import AsyncFolderEntitiesClient, FolderEntitiesClient
from .resources.integrations.client import AsyncIntegrationsClient, IntegrationsClient
from .resources.metric_definitions.client import AsyncMetricDefinitionsClient, MetricDefinitionsClient
from .resources.ml_models.client import AsyncMlModelsClient, MlModelsClient
from .resources.organizations.client import AsyncOrganizationsClient, OrganizationsClient
from .resources.prompts.client import AsyncPromptsClient, PromptsClient
from .resources.sandboxes.client import AsyncSandboxesClient, SandboxesClient
from .resources.test_suite_runs.client import AsyncTestSuiteRunsClient, TestSuiteRunsClient
from .resources.test_suites.client import AsyncTestSuitesClient, TestSuitesClient
from .resources.workflow_deployments.client import AsyncWorkflowDeploymentsClient, WorkflowDeploymentsClient
from .resources.workflow_executions.client import AsyncWorkflowExecutionsClient, WorkflowExecutionsClient
from .resources.workflow_sandboxes.client import AsyncWorkflowSandboxesClient, WorkflowSandboxesClient
from .resources.workflows.client import AsyncWorkflowsClient, WorkflowsClient
from .resources.workspace_secrets.client import AsyncWorkspaceSecretsClient, WorkspaceSecretsClient
from .resources.workspaces.client import AsyncWorkspacesClient, WorkspacesClient
from .types.api_version_enum import ApiVersionEnum
from .types.code_execution_package import CodeExecutionPackage
from .types.code_execution_runtime import CodeExecutionRuntime
from .types.code_executor_input import CodeExecutorInput
from .types.code_executor_response import CodeExecutorResponse
from .types.execute_api_request_bearer_token import ExecuteApiRequestBearerToken
from .types.execute_api_request_body import ExecuteApiRequestBody
from .types.execute_api_request_headers_value import ExecuteApiRequestHeadersValue
from .types.execute_api_response import ExecuteApiResponse
from .types.execute_prompt_event import ExecutePromptEvent
from .types.execute_prompt_response import ExecutePromptResponse
from .types.execute_workflow_response import ExecuteWorkflowResponse
from .types.generate_options_request import GenerateOptionsRequest
from .types.generate_request import GenerateRequest
from .types.generate_response import GenerateResponse
from .types.generate_stream_response import GenerateStreamResponse
from .types.method_enum import MethodEnum
from .types.prompt_deployment_expand_meta_request import PromptDeploymentExpandMetaRequest
from .types.prompt_deployment_input_request import PromptDeploymentInputRequest
from .types.raw_prompt_execution_overrides_request import RawPromptExecutionOverridesRequest
from .types.search_request_options_request import SearchRequestOptionsRequest
from .types.search_response import SearchResponse
from .types.submit_completion_actual_request import SubmitCompletionActualRequest
from .types.submit_workflow_execution_actual_request import SubmitWorkflowExecutionActualRequest
from .types.vellum_variable_type import VellumVariableType
from .types.workflow_execution_event_type import WorkflowExecutionEventType
from .types.workflow_expand_meta_request import WorkflowExpandMetaRequest
from .types.workflow_request_input_request import WorkflowRequestInputRequest
from .types.workflow_stream_event import WorkflowStreamEvent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class Vellum:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : VellumEnvironment
        The environment to use for requests from the client. from .environment import VellumEnvironment



        Defaults to VellumEnvironment.PRODUCTION



    api_version : typing.Optional[ApiVersionEnum]
    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default there is no timeout set, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from vellum import Vellum

    client = Vellum(
        api_version="YOUR_API_VERSION",
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: VellumEnvironment = VellumEnvironment.PRODUCTION,
        api_version: typing.Optional[ApiVersionEnum] = os.getenv("VELLUM_API_VERSION", "2025-07-30"),
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else None if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            environment=environment,
            api_version=api_version,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = RawVellum(client_wrapper=self._client_wrapper)
        self.integrations = IntegrationsClient(client_wrapper=self._client_wrapper)
        self.events = EventsClient(client_wrapper=self._client_wrapper)
        self.ad_hoc = AdHocClient(client_wrapper=self._client_wrapper)
        self.container_images = ContainerImagesClient(client_wrapper=self._client_wrapper)
        self.deployments = DeploymentsClient(client_wrapper=self._client_wrapper)
        self.document_indexes = DocumentIndexesClient(client_wrapper=self._client_wrapper)
        self.documents = DocumentsClient(client_wrapper=self._client_wrapper)
        self.folder_entities = FolderEntitiesClient(client_wrapper=self._client_wrapper)
        self.metric_definitions = MetricDefinitionsClient(client_wrapper=self._client_wrapper)
        self.ml_models = MlModelsClient(client_wrapper=self._client_wrapper)
        self.organizations = OrganizationsClient(client_wrapper=self._client_wrapper)
        self.prompts = PromptsClient(client_wrapper=self._client_wrapper)
        self.sandboxes = SandboxesClient(client_wrapper=self._client_wrapper)
        self.test_suite_runs = TestSuiteRunsClient(client_wrapper=self._client_wrapper)
        self.test_suites = TestSuitesClient(client_wrapper=self._client_wrapper)
        self.workflow_deployments = WorkflowDeploymentsClient(client_wrapper=self._client_wrapper)
        self.workflow_executions = WorkflowExecutionsClient(client_wrapper=self._client_wrapper)
        self.workflow_sandboxes = WorkflowSandboxesClient(client_wrapper=self._client_wrapper)
        self.workflows = WorkflowsClient(client_wrapper=self._client_wrapper)
        self.workspace_secrets = WorkspaceSecretsClient(client_wrapper=self._client_wrapper)
        self.workspaces = WorkspacesClient(client_wrapper=self._client_wrapper)

    @property
    def with_raw_response(self) -> RawVellum:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVellum
        """
        return self._raw_client

    def execute_api(
        self,
        *,
        url: str,
        method: typing.Optional[MethodEnum] = OMIT,
        body: typing.Optional[ExecuteApiRequestBody] = OMIT,
        headers: typing.Optional[typing.Dict[str, ExecuteApiRequestHeadersValue]] = OMIT,
        bearer_token: typing.Optional[ExecuteApiRequestBearerToken] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecuteApiResponse:
        """
        Parameters
        ----------
        url : str

        method : typing.Optional[MethodEnum]

        body : typing.Optional[ExecuteApiRequestBody]

        headers : typing.Optional[typing.Dict[str, ExecuteApiRequestHeadersValue]]

        bearer_token : typing.Optional[ExecuteApiRequestBearerToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecuteApiResponse


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.execute_api(
            url="x",
        )
        """
        _response = self._raw_client.execute_api(
            url=url,
            method=method,
            body=body,
            headers=headers,
            bearer_token=bearer_token,
            request_options=request_options,
        )
        return _response.data

    def execute_code(
        self,
        *,
        code: str,
        runtime: CodeExecutionRuntime,
        input_values: typing.Sequence[CodeExecutorInput],
        packages: typing.Sequence[CodeExecutionPackage],
        output_type: VellumVariableType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CodeExecutorResponse:
        """
        Parameters
        ----------
        code : str

        runtime : CodeExecutionRuntime

        input_values : typing.Sequence[CodeExecutorInput]

        packages : typing.Sequence[CodeExecutionPackage]

        output_type : VellumVariableType

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeExecutorResponse


        Examples
        --------
        from vellum import CodeExecutionPackage, StringInput, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.execute_code(
            code="x",
            runtime="PYTHON_3_11_6",
            input_values=[
                StringInput(
                    name="x",
                    value="value",
                ),
                StringInput(
                    name="x",
                    value="value",
                ),
            ],
            packages=[
                CodeExecutionPackage(
                    version="version",
                    name="name",
                ),
                CodeExecutionPackage(
                    version="version",
                    name="name",
                ),
            ],
            output_type="STRING",
        )
        """
        _response = self._raw_client.execute_code(
            code=code,
            runtime=runtime,
            input_values=input_values,
            packages=packages,
            output_type=output_type,
            request_options=request_options,
        )
        return _response.data

    def execute_prompt(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        prompt_deployment_id: typing.Optional[str] = OMIT,
        prompt_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[PromptDeploymentExpandMetaRequest] = OMIT,
        raw_overrides: typing.Optional[RawPromptExecutionOverridesRequest] = OMIT,
        expand_raw: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecutePromptResponse:
        """
        Executes a deployed Prompt and returns the result.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            A list consisting of the Prompt Deployment's input variables and their values.

        prompt_deployment_id : typing.Optional[str]
            The ID of the Prompt Deployment. Must provide either this or prompt_deployment_name.

        prompt_deployment_name : typing.Optional[str]
            The unique name of the Prompt Deployment. Must provide either this or prompt_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Prompt Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        expand_meta : typing.Optional[PromptDeploymentExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this prompt execution in the API response. Corresponding values will be returned under the `meta` key of the API response.

        raw_overrides : typing.Optional[RawPromptExecutionOverridesRequest]
            Overrides for the raw API request sent to the model host. Combined with `expand_raw`, it can be used to access new features from models.

        expand_raw : typing.Optional[typing.Sequence[str]]
            A list of keys whose values you'd like to directly return from the JSON response of the model provider. Useful if you need lower-level info returned by model providers that Vellum would otherwise omit. Corresponding key/value pairs will be returned under the `raw` key of the API response.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecutePromptResponse


        Examples
        --------
        from vellum import StringInputRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.execute_prompt(
            inputs=[
                StringInputRequest(
                    name="x",
                    value="value",
                ),
                StringInputRequest(
                    name="x",
                    value="value",
                ),
            ],
        )
        """
        _response = self._raw_client.execute_prompt(
            inputs=inputs,
            prompt_deployment_id=prompt_deployment_id,
            prompt_deployment_name=prompt_deployment_name,
            release_tag=release_tag,
            external_id=external_id,
            expand_meta=expand_meta,
            raw_overrides=raw_overrides,
            expand_raw=expand_raw,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def execute_prompt_stream(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        prompt_deployment_id: typing.Optional[str] = OMIT,
        prompt_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[PromptDeploymentExpandMetaRequest] = OMIT,
        raw_overrides: typing.Optional[RawPromptExecutionOverridesRequest] = OMIT,
        expand_raw: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[ExecutePromptEvent]:
        """
        Executes a deployed Prompt and streams back the results.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            A list consisting of the Prompt Deployment's input variables and their values.

        prompt_deployment_id : typing.Optional[str]
            The ID of the Prompt Deployment. Must provide either this or prompt_deployment_name.

        prompt_deployment_name : typing.Optional[str]
            The unique name of the Prompt Deployment. Must provide either this or prompt_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Prompt Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        expand_meta : typing.Optional[PromptDeploymentExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this prompt execution in the API response. Corresponding values will be returned under the `meta` key of the API response.

        raw_overrides : typing.Optional[RawPromptExecutionOverridesRequest]
            Overrides for the raw API request sent to the model host. Combined with `expand_raw`, it can be used to access new features from models.

        expand_raw : typing.Optional[typing.Sequence[str]]
            A list of keys whose values you'd like to directly return from the JSON response of the model provider. Useful if you need lower-level info returned by model providers that Vellum would otherwise omit. Corresponding key/value pairs will be returned under the `raw` key of the API response.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[ExecutePromptEvent]


        Examples
        --------
        from vellum import StringInputRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        response = client.execute_prompt_stream(
            inputs=[
                StringInputRequest(
                    name="x",
                    value="value",
                ),
                StringInputRequest(
                    name="x",
                    value="value",
                ),
            ],
        )
        for chunk in response:
            yield chunk
        """
        with self._raw_client.execute_prompt_stream(
            inputs=inputs,
            prompt_deployment_id=prompt_deployment_id,
            prompt_deployment_name=prompt_deployment_name,
            release_tag=release_tag,
            external_id=external_id,
            expand_meta=expand_meta,
            raw_overrides=raw_overrides,
            expand_raw=expand_raw,
            metadata=metadata,
            request_options=request_options,
        ) as r:
            yield from r.data

    def execute_workflow(
        self,
        *,
        inputs: typing.Sequence[WorkflowRequestInputRequest],
        expand_meta: typing.Optional[WorkflowExpandMetaRequest] = OMIT,
        workflow_deployment_id: typing.Optional[str] = OMIT,
        workflow_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        previous_execution_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecuteWorkflowResponse:
        """
        Executes a deployed Workflow and returns its outputs.

        Parameters
        ----------
        inputs : typing.Sequence[WorkflowRequestInputRequest]
            The list of inputs defined in the Workflow's Deployment with their corresponding values.

        expand_meta : typing.Optional[WorkflowExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this workflow execution in the API response. Corresponding values will be returned under the `execution_meta` key within NODE events in the response stream.

        workflow_deployment_id : typing.Optional[str]
            The ID of the Workflow Deployment. Must provide either this or workflow_deployment_name.

        workflow_deployment_name : typing.Optional[str]
            The name of the Workflow Deployment. Must provide either this or workflow_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        previous_execution_id : typing.Optional[str]
            The ID of a previous Workflow Execution to reference for initial State loading.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecuteWorkflowResponse


        Examples
        --------
        from vellum import Vellum, WorkflowRequestStringInputRequest

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.execute_workflow(
            inputs=[
                WorkflowRequestStringInputRequest(
                    name="x",
                    value="value",
                ),
                WorkflowRequestStringInputRequest(
                    name="x",
                    value="value",
                ),
            ],
        )
        """
        _response = self._raw_client.execute_workflow(
            inputs=inputs,
            expand_meta=expand_meta,
            workflow_deployment_id=workflow_deployment_id,
            workflow_deployment_name=workflow_deployment_name,
            release_tag=release_tag,
            external_id=external_id,
            metadata=metadata,
            previous_execution_id=previous_execution_id,
            request_options=request_options,
        )
        return _response.data

    def execute_workflow_stream(
        self,
        *,
        inputs: typing.Sequence[WorkflowRequestInputRequest],
        expand_meta: typing.Optional[WorkflowExpandMetaRequest] = OMIT,
        workflow_deployment_id: typing.Optional[str] = OMIT,
        workflow_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        event_types: typing.Optional[typing.Sequence[WorkflowExecutionEventType]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        previous_execution_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[WorkflowStreamEvent]:
        """
        Executes a deployed Workflow and streams back its results.

        Parameters
        ----------
        inputs : typing.Sequence[WorkflowRequestInputRequest]
            The list of inputs defined in the Workflow's Deployment with their corresponding values.

        expand_meta : typing.Optional[WorkflowExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this workflow execution in the API response. Corresponding values will be returned under the `execution_meta` key within NODE events in the response stream.

        workflow_deployment_id : typing.Optional[str]
            The ID of the Workflow Deployment. Must provide either this or workflow_deployment_name.

        workflow_deployment_name : typing.Optional[str]
            The name of the Workflow Deployment. Must provide either this or workflow_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        event_types : typing.Optional[typing.Sequence[WorkflowExecutionEventType]]
            Optionally specify which events you want to receive. Defaults to only WORKFLOW events. Note that the schema of non-WORKFLOW events is unstable and should be used with caution.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        previous_execution_id : typing.Optional[str]
            The ID of a previous Workflow Execution to reference for initial State loading.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[WorkflowStreamEvent]


        Examples
        --------
        from vellum import Vellum, WorkflowRequestStringInputRequest

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        response = client.execute_workflow_stream(
            inputs=[
                WorkflowRequestStringInputRequest(
                    name="x",
                    value="value",
                ),
                WorkflowRequestStringInputRequest(
                    name="x",
                    value="value",
                ),
            ],
        )
        for chunk in response:
            yield chunk
        """
        with self._raw_client.execute_workflow_stream(
            inputs=inputs,
            expand_meta=expand_meta,
            workflow_deployment_id=workflow_deployment_id,
            workflow_deployment_name=workflow_deployment_name,
            release_tag=release_tag,
            external_id=external_id,
            event_types=event_types,
            metadata=metadata,
            previous_execution_id=previous_execution_id,
            request_options=request_options,
        ) as r:
            yield from r.data

    def generate(
        self,
        *,
        requests: typing.Sequence[GenerateRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        options: typing.Optional[GenerateOptionsRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateResponse:
        """
        Generate a completion using a previously defined deployment.

        Important: This endpoint is DEPRECATED and has been superseded by
        [execute-prompt](/api-reference/api-reference/execute-prompt).

        Parameters
        ----------
        requests : typing.Sequence[GenerateRequest]
            The generation request to make. Bulk requests are no longer supported, this field must be an array of length 1.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        options : typing.Optional[GenerateOptionsRequest]
            Additional configuration that can be used to control what's included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateResponse


        Examples
        --------
        from vellum import GenerateRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.generate(
            requests=[
                GenerateRequest(
                    input_values={"input_values": {"key": "value"}},
                ),
                GenerateRequest(
                    input_values={"input_values": {"key": "value"}},
                ),
            ],
        )
        """
        _response = self._raw_client.generate(
            requests=requests,
            deployment_id=deployment_id,
            deployment_name=deployment_name,
            options=options,
            request_options=request_options,
        )
        return _response.data

    def generate_stream(
        self,
        *,
        requests: typing.Sequence[GenerateRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        options: typing.Optional[GenerateOptionsRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[GenerateStreamResponse]:
        """
        Generate a stream of completions using a previously defined deployment.

        Important: This endpoint is DEPRECATED and has been superseded by
        [execute-prompt-stream](/api-reference/api-reference/execute-prompt-stream).

        Parameters
        ----------
        requests : typing.Sequence[GenerateRequest]
            The generation request to make. Bulk requests are no longer supported, this field must be an array of length 1.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        options : typing.Optional[GenerateOptionsRequest]
            Additional configuration that can be used to control what's included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[GenerateStreamResponse]


        Examples
        --------
        from vellum import GenerateRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        response = client.generate_stream(
            requests=[
                GenerateRequest(
                    input_values={"input_values": {"key": "value"}},
                ),
                GenerateRequest(
                    input_values={"input_values": {"key": "value"}},
                ),
            ],
        )
        for chunk in response:
            yield chunk
        """
        with self._raw_client.generate_stream(
            requests=requests,
            deployment_id=deployment_id,
            deployment_name=deployment_name,
            options=options,
            request_options=request_options,
        ) as r:
            yield from r.data

    def search(
        self,
        *,
        query: str,
        index_id: typing.Optional[str] = OMIT,
        index_name: typing.Optional[str] = OMIT,
        options: typing.Optional[SearchRequestOptionsRequest] = OMIT,
        document_index: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Perform a search against a document index.

        Parameters
        ----------
        query : str
            The query to search for.

        index_id : typing.Optional[str]
            The ID of the index to search against. Must provide either this, index_name or document_index.

        index_name : typing.Optional[str]
            The name of the index to search against. Must provide either this, index_id or document_index.

        options : typing.Optional[SearchRequestOptionsRequest]
            Configuration options for the search.

        document_index : typing.Optional[str]
            Either the index name or index ID to search against. Must provide either this, index_id or index_name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.search(
            query="x",
        )
        """
        _response = self._raw_client.search(
            query=query,
            index_id=index_id,
            index_name=index_name,
            options=options,
            document_index=document_index,
            request_options=request_options,
        )
        return _response.data

    def submit_completion_actuals(
        self,
        *,
        actuals: typing.Sequence[SubmitCompletionActualRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Used to submit feedback regarding the quality of previously generated completions.

        Parameters
        ----------
        actuals : typing.Sequence[SubmitCompletionActualRequest]
            Feedback regarding the quality of previously generated completions

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from vellum import SubmitCompletionActualRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.submit_completion_actuals(
            actuals=[SubmitCompletionActualRequest(), SubmitCompletionActualRequest()],
        )
        """
        _response = self._raw_client.submit_completion_actuals(
            actuals=actuals,
            deployment_id=deployment_id,
            deployment_name=deployment_name,
            request_options=request_options,
        )
        return _response.data

    def submit_workflow_execution_actuals(
        self,
        *,
        actuals: typing.Sequence[SubmitWorkflowExecutionActualRequest],
        execution_id: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
            Used to submit feedback regarding the quality of previous workflow execution and its outputs.

            **Note:** Uses a base url of `https://predict.vellum.ai`.

        Parameters
        ----------
        actuals : typing.Sequence[SubmitWorkflowExecutionActualRequest]
            Feedback regarding the quality of an output on a previously executed workflow.

        execution_id : typing.Optional[str]
            The Vellum-generated ID of a previously executed workflow. Must provide either this or external_id.

        external_id : typing.Optional[str]
            The external ID that was originally provided by when executing the workflow, if applicable, that you'd now like to submit actuals for. Must provide either this or execution_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from vellum import Vellum, WorkflowExecutionActualStringRequest

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.submit_workflow_execution_actuals(
            actuals=[
                WorkflowExecutionActualStringRequest(),
                WorkflowExecutionActualStringRequest(),
            ],
        )
        """
        _response = self._raw_client.submit_workflow_execution_actuals(
            actuals=actuals, execution_id=execution_id, external_id=external_id, request_options=request_options
        )
        return _response.data


class AsyncVellum:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : VellumEnvironment
        The environment to use for requests from the client. from .environment import VellumEnvironment



        Defaults to VellumEnvironment.PRODUCTION



    api_version : typing.Optional[ApiVersionEnum]
    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default there is no timeout set, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from vellum import AsyncVellum

    client = AsyncVellum(
        api_version="YOUR_API_VERSION",
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: VellumEnvironment = VellumEnvironment.PRODUCTION,
        api_version: typing.Optional[ApiVersionEnum] = os.getenv("VELLUM_API_VERSION", "2025-07-30"),
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else None if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            environment=environment,
            api_version=api_version,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = AsyncRawVellum(client_wrapper=self._client_wrapper)
        self.integrations = AsyncIntegrationsClient(client_wrapper=self._client_wrapper)
        self.events = AsyncEventsClient(client_wrapper=self._client_wrapper)
        self.ad_hoc = AsyncAdHocClient(client_wrapper=self._client_wrapper)
        self.container_images = AsyncContainerImagesClient(client_wrapper=self._client_wrapper)
        self.deployments = AsyncDeploymentsClient(client_wrapper=self._client_wrapper)
        self.document_indexes = AsyncDocumentIndexesClient(client_wrapper=self._client_wrapper)
        self.documents = AsyncDocumentsClient(client_wrapper=self._client_wrapper)
        self.folder_entities = AsyncFolderEntitiesClient(client_wrapper=self._client_wrapper)
        self.metric_definitions = AsyncMetricDefinitionsClient(client_wrapper=self._client_wrapper)
        self.ml_models = AsyncMlModelsClient(client_wrapper=self._client_wrapper)
        self.organizations = AsyncOrganizationsClient(client_wrapper=self._client_wrapper)
        self.prompts = AsyncPromptsClient(client_wrapper=self._client_wrapper)
        self.sandboxes = AsyncSandboxesClient(client_wrapper=self._client_wrapper)
        self.test_suite_runs = AsyncTestSuiteRunsClient(client_wrapper=self._client_wrapper)
        self.test_suites = AsyncTestSuitesClient(client_wrapper=self._client_wrapper)
        self.workflow_deployments = AsyncWorkflowDeploymentsClient(client_wrapper=self._client_wrapper)
        self.workflow_executions = AsyncWorkflowExecutionsClient(client_wrapper=self._client_wrapper)
        self.workflow_sandboxes = AsyncWorkflowSandboxesClient(client_wrapper=self._client_wrapper)
        self.workflows = AsyncWorkflowsClient(client_wrapper=self._client_wrapper)
        self.workspace_secrets = AsyncWorkspaceSecretsClient(client_wrapper=self._client_wrapper)
        self.workspaces = AsyncWorkspacesClient(client_wrapper=self._client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVellum:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVellum
        """
        return self._raw_client

    async def execute_api(
        self,
        *,
        url: str,
        method: typing.Optional[MethodEnum] = OMIT,
        body: typing.Optional[ExecuteApiRequestBody] = OMIT,
        headers: typing.Optional[typing.Dict[str, ExecuteApiRequestHeadersValue]] = OMIT,
        bearer_token: typing.Optional[ExecuteApiRequestBearerToken] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecuteApiResponse:
        """
        Parameters
        ----------
        url : str

        method : typing.Optional[MethodEnum]

        body : typing.Optional[ExecuteApiRequestBody]

        headers : typing.Optional[typing.Dict[str, ExecuteApiRequestHeadersValue]]

        bearer_token : typing.Optional[ExecuteApiRequestBearerToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecuteApiResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.execute_api(
                url="x",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_api(
            url=url,
            method=method,
            body=body,
            headers=headers,
            bearer_token=bearer_token,
            request_options=request_options,
        )
        return _response.data

    async def execute_code(
        self,
        *,
        code: str,
        runtime: CodeExecutionRuntime,
        input_values: typing.Sequence[CodeExecutorInput],
        packages: typing.Sequence[CodeExecutionPackage],
        output_type: VellumVariableType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CodeExecutorResponse:
        """
        Parameters
        ----------
        code : str

        runtime : CodeExecutionRuntime

        input_values : typing.Sequence[CodeExecutorInput]

        packages : typing.Sequence[CodeExecutionPackage]

        output_type : VellumVariableType

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeExecutorResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, CodeExecutionPackage, StringInput

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.execute_code(
                code="x",
                runtime="PYTHON_3_11_6",
                input_values=[
                    StringInput(
                        name="x",
                        value="value",
                    ),
                    StringInput(
                        name="x",
                        value="value",
                    ),
                ],
                packages=[
                    CodeExecutionPackage(
                        version="version",
                        name="name",
                    ),
                    CodeExecutionPackage(
                        version="version",
                        name="name",
                    ),
                ],
                output_type="STRING",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_code(
            code=code,
            runtime=runtime,
            input_values=input_values,
            packages=packages,
            output_type=output_type,
            request_options=request_options,
        )
        return _response.data

    async def execute_prompt(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        prompt_deployment_id: typing.Optional[str] = OMIT,
        prompt_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[PromptDeploymentExpandMetaRequest] = OMIT,
        raw_overrides: typing.Optional[RawPromptExecutionOverridesRequest] = OMIT,
        expand_raw: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecutePromptResponse:
        """
        Executes a deployed Prompt and returns the result.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            A list consisting of the Prompt Deployment's input variables and their values.

        prompt_deployment_id : typing.Optional[str]
            The ID of the Prompt Deployment. Must provide either this or prompt_deployment_name.

        prompt_deployment_name : typing.Optional[str]
            The unique name of the Prompt Deployment. Must provide either this or prompt_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Prompt Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        expand_meta : typing.Optional[PromptDeploymentExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this prompt execution in the API response. Corresponding values will be returned under the `meta` key of the API response.

        raw_overrides : typing.Optional[RawPromptExecutionOverridesRequest]
            Overrides for the raw API request sent to the model host. Combined with `expand_raw`, it can be used to access new features from models.

        expand_raw : typing.Optional[typing.Sequence[str]]
            A list of keys whose values you'd like to directly return from the JSON response of the model provider. Useful if you need lower-level info returned by model providers that Vellum would otherwise omit. Corresponding key/value pairs will be returned under the `raw` key of the API response.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecutePromptResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, StringInputRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.execute_prompt(
                inputs=[
                    StringInputRequest(
                        name="x",
                        value="value",
                    ),
                    StringInputRequest(
                        name="x",
                        value="value",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_prompt(
            inputs=inputs,
            prompt_deployment_id=prompt_deployment_id,
            prompt_deployment_name=prompt_deployment_name,
            release_tag=release_tag,
            external_id=external_id,
            expand_meta=expand_meta,
            raw_overrides=raw_overrides,
            expand_raw=expand_raw,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def execute_prompt_stream(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        prompt_deployment_id: typing.Optional[str] = OMIT,
        prompt_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[PromptDeploymentExpandMetaRequest] = OMIT,
        raw_overrides: typing.Optional[RawPromptExecutionOverridesRequest] = OMIT,
        expand_raw: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[ExecutePromptEvent]:
        """
        Executes a deployed Prompt and streams back the results.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            A list consisting of the Prompt Deployment's input variables and their values.

        prompt_deployment_id : typing.Optional[str]
            The ID of the Prompt Deployment. Must provide either this or prompt_deployment_name.

        prompt_deployment_name : typing.Optional[str]
            The unique name of the Prompt Deployment. Must provide either this or prompt_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Prompt Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        expand_meta : typing.Optional[PromptDeploymentExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this prompt execution in the API response. Corresponding values will be returned under the `meta` key of the API response.

        raw_overrides : typing.Optional[RawPromptExecutionOverridesRequest]
            Overrides for the raw API request sent to the model host. Combined with `expand_raw`, it can be used to access new features from models.

        expand_raw : typing.Optional[typing.Sequence[str]]
            A list of keys whose values you'd like to directly return from the JSON response of the model provider. Useful if you need lower-level info returned by model providers that Vellum would otherwise omit. Corresponding key/value pairs will be returned under the `raw` key of the API response.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[ExecutePromptEvent]


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, StringInputRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.execute_prompt_stream(
                inputs=[
                    StringInputRequest(
                        name="x",
                        value="value",
                    ),
                    StringInputRequest(
                        name="x",
                        value="value",
                    ),
                ],
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._raw_client.execute_prompt_stream(
            inputs=inputs,
            prompt_deployment_id=prompt_deployment_id,
            prompt_deployment_name=prompt_deployment_name,
            release_tag=release_tag,
            external_id=external_id,
            expand_meta=expand_meta,
            raw_overrides=raw_overrides,
            expand_raw=expand_raw,
            metadata=metadata,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    async def execute_workflow(
        self,
        *,
        inputs: typing.Sequence[WorkflowRequestInputRequest],
        expand_meta: typing.Optional[WorkflowExpandMetaRequest] = OMIT,
        workflow_deployment_id: typing.Optional[str] = OMIT,
        workflow_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        previous_execution_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecuteWorkflowResponse:
        """
        Executes a deployed Workflow and returns its outputs.

        Parameters
        ----------
        inputs : typing.Sequence[WorkflowRequestInputRequest]
            The list of inputs defined in the Workflow's Deployment with their corresponding values.

        expand_meta : typing.Optional[WorkflowExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this workflow execution in the API response. Corresponding values will be returned under the `execution_meta` key within NODE events in the response stream.

        workflow_deployment_id : typing.Optional[str]
            The ID of the Workflow Deployment. Must provide either this or workflow_deployment_name.

        workflow_deployment_name : typing.Optional[str]
            The name of the Workflow Deployment. Must provide either this or workflow_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        previous_execution_id : typing.Optional[str]
            The ID of a previous Workflow Execution to reference for initial State loading.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecuteWorkflowResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, WorkflowRequestStringInputRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.execute_workflow(
                inputs=[
                    WorkflowRequestStringInputRequest(
                        name="x",
                        value="value",
                    ),
                    WorkflowRequestStringInputRequest(
                        name="x",
                        value="value",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_workflow(
            inputs=inputs,
            expand_meta=expand_meta,
            workflow_deployment_id=workflow_deployment_id,
            workflow_deployment_name=workflow_deployment_name,
            release_tag=release_tag,
            external_id=external_id,
            metadata=metadata,
            previous_execution_id=previous_execution_id,
            request_options=request_options,
        )
        return _response.data

    async def execute_workflow_stream(
        self,
        *,
        inputs: typing.Sequence[WorkflowRequestInputRequest],
        expand_meta: typing.Optional[WorkflowExpandMetaRequest] = OMIT,
        workflow_deployment_id: typing.Optional[str] = OMIT,
        workflow_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        event_types: typing.Optional[typing.Sequence[WorkflowExecutionEventType]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        previous_execution_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[WorkflowStreamEvent]:
        """
        Executes a deployed Workflow and streams back its results.

        Parameters
        ----------
        inputs : typing.Sequence[WorkflowRequestInputRequest]
            The list of inputs defined in the Workflow's Deployment with their corresponding values.

        expand_meta : typing.Optional[WorkflowExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this workflow execution in the API response. Corresponding values will be returned under the `execution_meta` key within NODE events in the response stream.

        workflow_deployment_id : typing.Optional[str]
            The ID of the Workflow Deployment. Must provide either this or workflow_deployment_name.

        workflow_deployment_name : typing.Optional[str]
            The name of the Workflow Deployment. Must provide either this or workflow_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        event_types : typing.Optional[typing.Sequence[WorkflowExecutionEventType]]
            Optionally specify which events you want to receive. Defaults to only WORKFLOW events. Note that the schema of non-WORKFLOW events is unstable and should be used with caution.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        previous_execution_id : typing.Optional[str]
            The ID of a previous Workflow Execution to reference for initial State loading.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[WorkflowStreamEvent]


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, WorkflowRequestStringInputRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.execute_workflow_stream(
                inputs=[
                    WorkflowRequestStringInputRequest(
                        name="x",
                        value="value",
                    ),
                    WorkflowRequestStringInputRequest(
                        name="x",
                        value="value",
                    ),
                ],
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._raw_client.execute_workflow_stream(
            inputs=inputs,
            expand_meta=expand_meta,
            workflow_deployment_id=workflow_deployment_id,
            workflow_deployment_name=workflow_deployment_name,
            release_tag=release_tag,
            external_id=external_id,
            event_types=event_types,
            metadata=metadata,
            previous_execution_id=previous_execution_id,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    async def generate(
        self,
        *,
        requests: typing.Sequence[GenerateRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        options: typing.Optional[GenerateOptionsRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateResponse:
        """
        Generate a completion using a previously defined deployment.

        Important: This endpoint is DEPRECATED and has been superseded by
        [execute-prompt](/api-reference/api-reference/execute-prompt).

        Parameters
        ----------
        requests : typing.Sequence[GenerateRequest]
            The generation request to make. Bulk requests are no longer supported, this field must be an array of length 1.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        options : typing.Optional[GenerateOptionsRequest]
            Additional configuration that can be used to control what's included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, GenerateRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.generate(
                requests=[
                    GenerateRequest(
                        input_values={"input_values": {"key": "value"}},
                    ),
                    GenerateRequest(
                        input_values={"input_values": {"key": "value"}},
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.generate(
            requests=requests,
            deployment_id=deployment_id,
            deployment_name=deployment_name,
            options=options,
            request_options=request_options,
        )
        return _response.data

    async def generate_stream(
        self,
        *,
        requests: typing.Sequence[GenerateRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        options: typing.Optional[GenerateOptionsRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[GenerateStreamResponse]:
        """
        Generate a stream of completions using a previously defined deployment.

        Important: This endpoint is DEPRECATED and has been superseded by
        [execute-prompt-stream](/api-reference/api-reference/execute-prompt-stream).

        Parameters
        ----------
        requests : typing.Sequence[GenerateRequest]
            The generation request to make. Bulk requests are no longer supported, this field must be an array of length 1.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        options : typing.Optional[GenerateOptionsRequest]
            Additional configuration that can be used to control what's included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[GenerateStreamResponse]


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, GenerateRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.generate_stream(
                requests=[
                    GenerateRequest(
                        input_values={"input_values": {"key": "value"}},
                    ),
                    GenerateRequest(
                        input_values={"input_values": {"key": "value"}},
                    ),
                ],
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._raw_client.generate_stream(
            requests=requests,
            deployment_id=deployment_id,
            deployment_name=deployment_name,
            options=options,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    async def search(
        self,
        *,
        query: str,
        index_id: typing.Optional[str] = OMIT,
        index_name: typing.Optional[str] = OMIT,
        options: typing.Optional[SearchRequestOptionsRequest] = OMIT,
        document_index: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Perform a search against a document index.

        Parameters
        ----------
        query : str
            The query to search for.

        index_id : typing.Optional[str]
            The ID of the index to search against. Must provide either this, index_name or document_index.

        index_name : typing.Optional[str]
            The name of the index to search against. Must provide either this, index_id or document_index.

        options : typing.Optional[SearchRequestOptionsRequest]
            Configuration options for the search.

        document_index : typing.Optional[str]
            Either the index name or index ID to search against. Must provide either this, index_id or index_name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.search(
                query="x",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            query=query,
            index_id=index_id,
            index_name=index_name,
            options=options,
            document_index=document_index,
            request_options=request_options,
        )
        return _response.data

    async def submit_completion_actuals(
        self,
        *,
        actuals: typing.Sequence[SubmitCompletionActualRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Used to submit feedback regarding the quality of previously generated completions.

        Parameters
        ----------
        actuals : typing.Sequence[SubmitCompletionActualRequest]
            Feedback regarding the quality of previously generated completions

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, SubmitCompletionActualRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.submit_completion_actuals(
                actuals=[
                    SubmitCompletionActualRequest(),
                    SubmitCompletionActualRequest(),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.submit_completion_actuals(
            actuals=actuals,
            deployment_id=deployment_id,
            deployment_name=deployment_name,
            request_options=request_options,
        )
        return _response.data

    async def submit_workflow_execution_actuals(
        self,
        *,
        actuals: typing.Sequence[SubmitWorkflowExecutionActualRequest],
        execution_id: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
            Used to submit feedback regarding the quality of previous workflow execution and its outputs.

            **Note:** Uses a base url of `https://predict.vellum.ai`.

        Parameters
        ----------
        actuals : typing.Sequence[SubmitWorkflowExecutionActualRequest]
            Feedback regarding the quality of an output on a previously executed workflow.

        execution_id : typing.Optional[str]
            The Vellum-generated ID of a previously executed workflow. Must provide either this or external_id.

        external_id : typing.Optional[str]
            The external ID that was originally provided by when executing the workflow, if applicable, that you'd now like to submit actuals for. Must provide either this or execution_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, WorkflowExecutionActualStringRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.submit_workflow_execution_actuals(
                actuals=[
                    WorkflowExecutionActualStringRequest(),
                    WorkflowExecutionActualStringRequest(),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.submit_workflow_execution_actuals(
            actuals=actuals, execution_id=execution_id, external_id=external_id, request_options=request_options
        )
        return _response.data
