# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.internal_server_error import InternalServerError
from ...errors.not_found_error import NotFoundError
from ...types.compile_prompt_deployment_expand_meta_request import CompilePromptDeploymentExpandMetaRequest
from ...types.deployment_history_item import DeploymentHistoryItem
from ...types.deployment_provider_payload_response import DeploymentProviderPayloadResponse
from ...types.deployment_read import DeploymentRead
from ...types.deployment_release_tag_read import DeploymentReleaseTagRead
from ...types.paginated_deployment_release_tag_read_list import PaginatedDeploymentReleaseTagReadList
from ...types.paginated_slim_deployment_read_list import PaginatedSlimDeploymentReadList
from ...types.prompt_deployment_input_request import PromptDeploymentInputRequest
from ...types.prompt_deployment_release import PromptDeploymentRelease
from .types.deployments_list_request_status import DeploymentsListRequestStatus
from .types.list_deployment_release_tags_request_source import ListDeploymentReleaseTagsRequestSource

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDeploymentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        status: typing.Optional[DeploymentsListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedSlimDeploymentReadList]:
        """
        Used to list all Prompt Deployments.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        status : typing.Optional[DeploymentsListRequestStatus]
            status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedSlimDeploymentReadList]

        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/deployments",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "limit": limit,
                "offset": offset,
                "ordering": ordering,
                "status": status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedSlimDeploymentReadList,
                    parse_obj_as(
                        type_=PaginatedSlimDeploymentReadList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeploymentRead]:
        """
        Used to retrieve a Prompt Deployment given its ID or name.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeploymentRead]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeploymentRead,
                    parse_obj_as(
                        type_=DeploymentRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def deployment_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeploymentHistoryItem]:
        """
        DEPRECATED: This endpoint is deprecated and will be removed in a future release. Please use the
        `retrieve_prompt_deployment_release` xendpoint instead.

        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Deployment History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Deployment History Item you'd like to retrieve.

        id : str
            Either the Prompt Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeploymentHistoryItem]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}/history/{jsonable_encoder(history_id_or_release_tag)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeploymentHistoryItem,
                    parse_obj_as(
                        type_=DeploymentHistoryItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_deployment_release_tags(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        source: typing.Optional[ListDeploymentReleaseTagsRequestSource] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedDeploymentReleaseTagReadList]:
        """
        List Release Tags associated with the specified Prompt Deployment

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        source : typing.Optional[ListDeploymentReleaseTagsRequestSource]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedDeploymentReleaseTagReadList]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}/release-tags",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "limit": limit,
                "offset": offset,
                "ordering": ordering,
                "source": source,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedDeploymentReleaseTagReadList,
                    parse_obj_as(
                        type_=PaginatedDeploymentReleaseTagReadList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve_deployment_release_tag(
        self, id: str, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeploymentReleaseTagRead]:
        """
        Retrieve a Deployment Release Tag by tag name, associated with a specified Deployment.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Deployment that you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeploymentReleaseTagRead]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}/release-tags/{jsonable_encoder(name)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeploymentReleaseTagRead,
                    parse_obj_as(
                        type_=DeploymentReleaseTagRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_deployment_release_tag(
        self,
        id: str,
        name: str,
        *,
        history_item_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DeploymentReleaseTagRead]:
        """
        Updates an existing Release Tag associated with the specified Prompt Deployment.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Deployment that you'd like to update.

        history_item_id : typing.Optional[str]
            The ID of the Release to tag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeploymentReleaseTagRead]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}/release-tags/{jsonable_encoder(name)}",
            base_url=self._client_wrapper.get_environment().default,
            method="PATCH",
            json={
                "history_item_id": history_item_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeploymentReleaseTagRead,
                    parse_obj_as(
                        type_=DeploymentReleaseTagRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve_prompt_deployment_release(
        self, id: str, release_id_or_release_tag: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PromptDeploymentRelease]:
        """
        Retrieve a specific Prompt Deployment Release by either its UUID or the name of a Release Tag that points to it.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        release_id_or_release_tag : str
            Either the UUID of Prompt Deployment Release you'd like to retrieve, or the name of a Release Tag that's pointing to the Prompt Deployment Release you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PromptDeploymentRelease]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}/releases/{jsonable_encoder(release_id_or_release_tag)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PromptDeploymentRelease,
                    parse_obj_as(
                        type_=PromptDeploymentRelease,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve_provider_payload(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[CompilePromptDeploymentExpandMetaRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DeploymentProviderPayloadResponse]:
        """
        Given a set of input variable values, compile the exact payload that Vellum would send to the configured model provider
        for execution if the execute-prompt endpoint had been invoked. Note that this endpoint does not actually execute the
        prompt or make an API call to the model provider.

        This endpoint is useful if you don't want to proxy LLM provider requests through Vellum and prefer to send them directly
        to the provider yourself. Note that no guarantees are made on the format of this API's response schema, other than
        that it will be a valid payload for the configured model provider. It's not recommended that you try to parse or
        derive meaning from the response body and instead, should simply pass it directly to the model provider as is.

        We encourage you to seek advise from Vellum Support before integrating with this API for production use.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            The list of inputs defined in the Prompt's deployment with their corresponding values.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        expand_meta : typing.Optional[CompilePromptDeploymentExpandMetaRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeploymentProviderPayloadResponse]

        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/deployments/provider-payload",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "deployment_id": deployment_id,
                "deployment_name": deployment_name,
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[PromptDeploymentInputRequest], direction="write"
                ),
                "release_tag": release_tag,
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta,
                    annotation=typing.Optional[CompilePromptDeploymentExpandMetaRequest],
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeploymentProviderPayloadResponse,
                    parse_obj_as(
                        type_=DeploymentProviderPayloadResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDeploymentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        status: typing.Optional[DeploymentsListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedSlimDeploymentReadList]:
        """
        Used to list all Prompt Deployments.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        status : typing.Optional[DeploymentsListRequestStatus]
            status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedSlimDeploymentReadList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/deployments",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "limit": limit,
                "offset": offset,
                "ordering": ordering,
                "status": status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedSlimDeploymentReadList,
                    parse_obj_as(
                        type_=PaginatedSlimDeploymentReadList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeploymentRead]:
        """
        Used to retrieve a Prompt Deployment given its ID or name.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeploymentRead]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeploymentRead,
                    parse_obj_as(
                        type_=DeploymentRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def deployment_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeploymentHistoryItem]:
        """
        DEPRECATED: This endpoint is deprecated and will be removed in a future release. Please use the
        `retrieve_prompt_deployment_release` xendpoint instead.

        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Deployment History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Deployment History Item you'd like to retrieve.

        id : str
            Either the Prompt Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeploymentHistoryItem]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}/history/{jsonable_encoder(history_id_or_release_tag)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeploymentHistoryItem,
                    parse_obj_as(
                        type_=DeploymentHistoryItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_deployment_release_tags(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        source: typing.Optional[ListDeploymentReleaseTagsRequestSource] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedDeploymentReleaseTagReadList]:
        """
        List Release Tags associated with the specified Prompt Deployment

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        source : typing.Optional[ListDeploymentReleaseTagsRequestSource]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedDeploymentReleaseTagReadList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}/release-tags",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "limit": limit,
                "offset": offset,
                "ordering": ordering,
                "source": source,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedDeploymentReleaseTagReadList,
                    parse_obj_as(
                        type_=PaginatedDeploymentReleaseTagReadList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve_deployment_release_tag(
        self, id: str, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeploymentReleaseTagRead]:
        """
        Retrieve a Deployment Release Tag by tag name, associated with a specified Deployment.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Deployment that you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeploymentReleaseTagRead]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}/release-tags/{jsonable_encoder(name)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeploymentReleaseTagRead,
                    parse_obj_as(
                        type_=DeploymentReleaseTagRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_deployment_release_tag(
        self,
        id: str,
        name: str,
        *,
        history_item_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DeploymentReleaseTagRead]:
        """
        Updates an existing Release Tag associated with the specified Prompt Deployment.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Deployment that you'd like to update.

        history_item_id : typing.Optional[str]
            The ID of the Release to tag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeploymentReleaseTagRead]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}/release-tags/{jsonable_encoder(name)}",
            base_url=self._client_wrapper.get_environment().default,
            method="PATCH",
            json={
                "history_item_id": history_item_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeploymentReleaseTagRead,
                    parse_obj_as(
                        type_=DeploymentReleaseTagRead,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve_prompt_deployment_release(
        self, id: str, release_id_or_release_tag: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PromptDeploymentRelease]:
        """
        Retrieve a specific Prompt Deployment Release by either its UUID or the name of a Release Tag that points to it.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        release_id_or_release_tag : str
            Either the UUID of Prompt Deployment Release you'd like to retrieve, or the name of a Release Tag that's pointing to the Prompt Deployment Release you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PromptDeploymentRelease]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/deployments/{jsonable_encoder(id)}/releases/{jsonable_encoder(release_id_or_release_tag)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PromptDeploymentRelease,
                    parse_obj_as(
                        type_=PromptDeploymentRelease,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve_provider_payload(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[CompilePromptDeploymentExpandMetaRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DeploymentProviderPayloadResponse]:
        """
        Given a set of input variable values, compile the exact payload that Vellum would send to the configured model provider
        for execution if the execute-prompt endpoint had been invoked. Note that this endpoint does not actually execute the
        prompt or make an API call to the model provider.

        This endpoint is useful if you don't want to proxy LLM provider requests through Vellum and prefer to send them directly
        to the provider yourself. Note that no guarantees are made on the format of this API's response schema, other than
        that it will be a valid payload for the configured model provider. It's not recommended that you try to parse or
        derive meaning from the response body and instead, should simply pass it directly to the model provider as is.

        We encourage you to seek advise from Vellum Support before integrating with this API for production use.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            The list of inputs defined in the Prompt's deployment with their corresponding values.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        expand_meta : typing.Optional[CompilePromptDeploymentExpandMetaRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeploymentProviderPayloadResponse]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/deployments/provider-payload",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "deployment_id": deployment_id,
                "deployment_name": deployment_name,
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[PromptDeploymentInputRequest], direction="write"
                ),
                "release_tag": release_tag,
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta,
                    annotation=typing.Optional[CompilePromptDeploymentExpandMetaRequest],
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeploymentProviderPayloadResponse,
                    parse_obj_as(
                        type_=DeploymentProviderPayloadResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
