# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.bad_request_error import BadRequestError
from ...types.components_schemas_composio_execute_tool_response import ComponentsSchemasComposioExecuteToolResponse
from ...types.components_schemas_composio_tool_definition import ComponentsSchemasComposioToolDefinition

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawIntegrationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def retrieve_integration_tool_definition(
        self,
        integration: str,
        provider: str,
        tool_name: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ComponentsSchemasComposioToolDefinition]:
        """
        Parameters
        ----------
        integration : str
            The integration name

        provider : str
            The integration provider name

        tool_name : str
            The tool's unique name, as specified by the integration provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ComponentsSchemasComposioToolDefinition]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"integrations/v1/providers/{jsonable_encoder(provider)}/integrations/{jsonable_encoder(integration)}/tools/{jsonable_encoder(tool_name)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ComponentsSchemasComposioToolDefinition,
                    parse_obj_as(
                        type_=ComponentsSchemasComposioToolDefinition,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def execute_integration_tool(
        self,
        integration: str,
        provider: str,
        tool_name: str,
        *,
        arguments: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ComponentsSchemasComposioExecuteToolResponse]:
        """
        Parameters
        ----------
        integration : str
            The integration name

        provider : str
            The integration provider name

        tool_name : str
            The tool's unique name, as specified by the integration provider

        arguments : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ComponentsSchemasComposioExecuteToolResponse]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"integrations/v1/providers/{jsonable_encoder(provider)}/integrations/{jsonable_encoder(integration)}/tools/{jsonable_encoder(tool_name)}/execute",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "arguments": arguments,
                "provider": "COMPOSIO",
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ComponentsSchemasComposioExecuteToolResponse,
                    parse_obj_as(
                        type_=ComponentsSchemasComposioExecuteToolResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawIntegrationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def retrieve_integration_tool_definition(
        self,
        integration: str,
        provider: str,
        tool_name: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ComponentsSchemasComposioToolDefinition]:
        """
        Parameters
        ----------
        integration : str
            The integration name

        provider : str
            The integration provider name

        tool_name : str
            The tool's unique name, as specified by the integration provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ComponentsSchemasComposioToolDefinition]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"integrations/v1/providers/{jsonable_encoder(provider)}/integrations/{jsonable_encoder(integration)}/tools/{jsonable_encoder(tool_name)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ComponentsSchemasComposioToolDefinition,
                    parse_obj_as(
                        type_=ComponentsSchemasComposioToolDefinition,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def execute_integration_tool(
        self,
        integration: str,
        provider: str,
        tool_name: str,
        *,
        arguments: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ComponentsSchemasComposioExecuteToolResponse]:
        """
        Parameters
        ----------
        integration : str
            The integration name

        provider : str
            The integration provider name

        tool_name : str
            The tool's unique name, as specified by the integration provider

        arguments : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ComponentsSchemasComposioExecuteToolResponse]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"integrations/v1/providers/{jsonable_encoder(provider)}/integrations/{jsonable_encoder(integration)}/tools/{jsonable_encoder(tool_name)}/execute",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "arguments": arguments,
                "provider": "COMPOSIO",
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ComponentsSchemasComposioExecuteToolResponse,
                    parse_obj_as(
                        type_=ComponentsSchemasComposioExecuteToolResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
