# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.ml_model_read import MlModelRead
from .raw_client import AsyncRawMlModelsClient, RawMlModelsClient


class MlModelsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMlModelsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawMlModelsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMlModelsClient
        """
        return self._raw_client

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MlModelRead:
        """
        Retrieve details about an ML Model

        Parameters
        ----------
        id : str
            Either the ML Model's ID, its unique name, or its ID in the workspace.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MlModelRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.ml_models.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(id, request_options=request_options)
        return _response.data


class AsyncMlModelsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMlModelsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMlModelsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMlModelsClient
        """
        return self._raw_client

    async def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MlModelRead:
        """
        Retrieve details about an ML Model

        Parameters
        ----------
        id : str
            Either the ML Model's ID, its unique name, or its ID in the workspace.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MlModelRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ml_models.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(id, request_options=request_options)
        return _response.data
