# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.prompt_exec_config import PromptExecConfig
from ...types.prompt_push_response import PromptPushResponse
from .raw_client import AsyncRawPromptsClient, RawPromptsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PromptsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPromptsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawPromptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPromptsClient
        """
        return self._raw_client

    def pull(
        self,
        id: str,
        *,
        prompt_variant_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptExecConfig:
        """
        Used to pull the definition of a Prompt from Vellum.

        Parameters
        ----------
        id : str
            The ID of the Prompt to pull from. Prompt Sandbox IDs are currently supported.

        prompt_variant_id : typing.Optional[str]
            The ID of the Prompt Variant within a Prompt Sandbox to pull. Must be included if providing the ID of a Prompt Sandbox.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptExecConfig


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.prompts.pull(
            id="id",
        )
        """
        _response = self._raw_client.pull(id, prompt_variant_id=prompt_variant_id, request_options=request_options)
        return _response.data

    def push(
        self,
        *,
        exec_config: PromptExecConfig,
        prompt_variant_id: typing.Optional[str] = OMIT,
        prompt_variant_label: typing.Optional[str] = OMIT,
        prompt_sandbox_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptPushResponse:
        """
        Used to push updates to a Prompt in Vellum.

        Parameters
        ----------
        exec_config : PromptExecConfig

        prompt_variant_id : typing.Optional[str]
            If specified, an existing Prompt Variant by the provided ID will be updated. Otherwise, a new Prompt Variant will be created and an ID generated.

        prompt_variant_label : typing.Optional[str]
            If provided, then the created/updated Prompt Variant will have this label.

        prompt_sandbox_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptPushResponse


        Examples
        --------
        from vellum import (
            JinjaPromptBlock,
            PromptExecConfig,
            PromptParameters,
            Vellum,
            VellumVariable,
        )

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.prompts.push(
            exec_config=PromptExecConfig(
                ml_model="ml_model",
                input_variables=[
                    VellumVariable(
                        id="x",
                        key="key",
                        type="STRING",
                    ),
                    VellumVariable(
                        id="x",
                        key="key",
                        type="STRING",
                    ),
                ],
                parameters=PromptParameters(),
                blocks=[
                    JinjaPromptBlock(
                        template="template",
                    ),
                    JinjaPromptBlock(
                        template="template",
                    ),
                ],
            ),
        )
        """
        _response = self._raw_client.push(
            exec_config=exec_config,
            prompt_variant_id=prompt_variant_id,
            prompt_variant_label=prompt_variant_label,
            prompt_sandbox_id=prompt_sandbox_id,
            request_options=request_options,
        )
        return _response.data


class AsyncPromptsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPromptsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPromptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPromptsClient
        """
        return self._raw_client

    async def pull(
        self,
        id: str,
        *,
        prompt_variant_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptExecConfig:
        """
        Used to pull the definition of a Prompt from Vellum.

        Parameters
        ----------
        id : str
            The ID of the Prompt to pull from. Prompt Sandbox IDs are currently supported.

        prompt_variant_id : typing.Optional[str]
            The ID of the Prompt Variant within a Prompt Sandbox to pull. Must be included if providing the ID of a Prompt Sandbox.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptExecConfig


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.prompts.pull(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.pull(
            id, prompt_variant_id=prompt_variant_id, request_options=request_options
        )
        return _response.data

    async def push(
        self,
        *,
        exec_config: PromptExecConfig,
        prompt_variant_id: typing.Optional[str] = OMIT,
        prompt_variant_label: typing.Optional[str] = OMIT,
        prompt_sandbox_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptPushResponse:
        """
        Used to push updates to a Prompt in Vellum.

        Parameters
        ----------
        exec_config : PromptExecConfig

        prompt_variant_id : typing.Optional[str]
            If specified, an existing Prompt Variant by the provided ID will be updated. Otherwise, a new Prompt Variant will be created and an ID generated.

        prompt_variant_label : typing.Optional[str]
            If provided, then the created/updated Prompt Variant will have this label.

        prompt_sandbox_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptPushResponse


        Examples
        --------
        import asyncio

        from vellum import (
            AsyncVellum,
            JinjaPromptBlock,
            PromptExecConfig,
            PromptParameters,
            VellumVariable,
        )

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.prompts.push(
                exec_config=PromptExecConfig(
                    ml_model="ml_model",
                    input_variables=[
                        VellumVariable(
                            id="x",
                            key="key",
                            type="STRING",
                        ),
                        VellumVariable(
                            id="x",
                            key="key",
                            type="STRING",
                        ),
                    ],
                    parameters=PromptParameters(),
                    blocks=[
                        JinjaPromptBlock(
                            template="template",
                        ),
                        JinjaPromptBlock(
                            template="template",
                        ),
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.push(
            exec_config=exec_config,
            prompt_variant_id=prompt_variant_id,
            prompt_variant_label=prompt_variant_label,
            prompt_sandbox_id=prompt_sandbox_id,
            request_options=request_options,
        )
        return _response.data
