# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .entity_status import EntityStatus
from .environment_enum import EnvironmentEnum
from .vellum_variable import VellumVariable


class DeploymentRead(UniversalBaseModel):
    """
    A Prompt Deployment's full details.
    """

    id: str
    created: dt.datetime
    label: str = pydantic.Field()
    """
    A human-readable label for the deployment
    """

    name: str = pydantic.Field()
    """
    A name that uniquely identifies this deployment within its workspace
    """

    status: typing.Optional[EntityStatus] = pydantic.Field(default=None)
    """
    The current status of the deployment
    
    * `ACTIVE` - Active
    * `ARCHIVED` - Archived
    """

    environment: typing.Optional[EnvironmentEnum] = pydantic.Field(default=None)
    """
    Deprecated. The value returned will always be 'PRODUCTION'.
    """

    last_deployed_on: dt.datetime
    input_variables: typing.List[VellumVariable]
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human-readable description of the deployment
    """

    active_model_version_ids: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Deprecated. This now always returns an empty array.
    """

    last_deployed_history_item_id: str = pydantic.Field()
    """
    The ID of the history item associated with this Deployment's LATEST Release Tag
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_vellum_value import ArrayVellumValue  # noqa: E402, F401, I001

update_forward_refs(DeploymentRead)
