# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .generate_result import GenerateResult


class GenerateResponse(UniversalBaseModel):
    results: typing.List[GenerateResult] = pydantic.Field()
    """
    The results of each generation request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


    @property
    def texts(self) -> typing.List[str]:
        return [
            completion.text
            for result in self.results
            for completion in (result.data.completions if result.data else [])
        ]

    @property
    def text(self) -> str:
        if len(self.texts) != 1:
            raise ValueError(f"Expected exactly one completion, but got {len(self.texts)}")
        return self.texts[0]
