# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .node_execution_span_attributes import NodeExecutionSpanAttributes
from .vellum_node_execution_event import VellumNodeExecutionEvent
from .workflow_execution_usage_calculation_fulfilled_body import WorkflowExecutionUsageCalculationFulfilledBody


class NodeExecutionSpan(UniversalBaseModel):
    name: typing.Literal["node.execution"] = "node.execution"
    events: typing.List[VellumNodeExecutionEvent]
    attributes: NodeExecutionSpanAttributes
    usage_result: typing.Optional[WorkflowExecutionUsageCalculationFulfilledBody] = None
    span_id: str
    start_ts: dt.datetime
    end_ts: dt.datetime
    parent_span_id: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .api_request_parent_context import ApiRequestParentContext  # noqa: E402, F401, I001
from .external_parent_context import ExternalParentContext  # noqa: E402, F401, I001
from .node_parent_context import NodeParentContext  # noqa: E402, F401, I001
from .prompt_deployment_parent_context import PromptDeploymentParentContext  # noqa: E402, F401, I001
from .span_link import SpanLink  # noqa: E402, F401, I001
from .workflow_deployment_parent_context import WorkflowDeploymentParentContext  # noqa: E402, F401, I001
from .workflow_parent_context import WorkflowParentContext  # noqa: E402, F401, I001
from .workflow_sandbox_parent_context import WorkflowSandboxParentContext  # noqa: E402, F401, I001

update_forward_refs(NodeExecutionSpan)
