# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .function_definition import FunctionDefinition
from .prompt_parameters import PromptParameters
from .prompt_settings import PromptSettings
from .vellum_variable import VellumVariable


class PromptExecConfig(UniversalBaseModel):
    ml_model: str
    input_variables: typing.List[VellumVariable]
    parameters: PromptParameters
    settings: typing.Optional[PromptSettings] = None
    blocks: typing.List["PromptBlock"]
    functions: typing.Optional[typing.List[FunctionDefinition]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_vellum_value import ArrayVellumValue  # noqa: E402, F401, I001
from .chat_message_prompt_block import ChatMessagePromptBlock  # noqa: E402, F401, I001
from .prompt_block import PromptBlock  # noqa: E402, F401, I001

update_forward_refs(PromptExecConfig)
