# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .workflow_node_result_event_state import WorkflowNodeResultEventState


class WorkflowResultEventOutputDataJson(UniversalBaseModel):
    """
    A JSON output streamed from a Workflow execution.
    """

    id: typing.Optional[str] = None
    name: str
    state: WorkflowNodeResultEventState
    node_id: str
    delta: typing.Optional[str] = pydantic.Field(default=None)
    """
    The newly output string value. Only relevant for string outputs with a state of STREAMING.
    """

    type: typing.Literal["JSON"] = "JSON"
    value: typing.Optional[typing.Any] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
