#!/usr/bin/env python3
# -*- coding: utf-8 -*-

"""
   @project: HSPyLib
   @package: hspylib.modules.cli.icons.font_awesome
      @file: app_icons.py
   @created: Tue, 4 May 2021
    @author: <B>H</B>ugo <B>S</B>aporetti <B>J</B>unior"
      @site: https://github.com/yorevs/hspylib
   @license: MIT - Please refer to <https://opensource.org/licenses/MIT>

   Copyright 2022, HSPyLib team
"""
from enum import auto

from hspylib.modules.cli.icons.font_awesome.awesome import Awesome


class AppIcons(Awesome):
    """
    Application icons.
    Codes can be found here:
    - https://fontawesome.com/cheatsheet?from=io
    """

    # fmt: off
    _CUSTOM         = auto()
    AMAZON          = '\uF270'  # 
    APPLE           = '\uF179'  # 
    AWS             = '\uF375'  # 
    CPLUSPLUS       = '\uF38C'  # 
    DOCKER          = '\uF308'  # 
    DROPBOX         = '\uF16B'  # 
    GIT             = '\uF813'  # 
    GITHUB          = '\uF408'  # 
    GOOGLE          = '\uF1A0'  # 
    GOOGLE_DRIVE    = '\uF3AA'  # 
    FACEBOOK        = '\uF082'  # 
    FIREBASE        = '\uF1D0'  # 
    IE              = '\uF7FF'  # 
    INSTAGRAM       = '\uF16D'  # 
    JAVA            = '\uF4E4'  # 
    LINKED_IN       = '\uF08C'  # 
    LINUX           = '\uF31A'  # 
    PAYPAL          = '\uF1ED'  # 
    PYTHON          = '\uF3E2'  # 
    STACK_OVERFLOW  = '\uF16C'  # 
    TWITTER         = '\uF081'  # 
    UBUNTU          = '\uF31B'  # 
    VS_CODE         = '\uF3AB'  # 
    YOUTUBE         = '\uF16A'  # 
    WHATSAPP        = '\uFAA2'  # 甆
    WINDOWS         = '\uF17A'  # 
    # fmt: on
