"""
Open Nomenclature qualifiers and their abbreviations. Taken from Sigovini
et al. (2016). See: https://doi.org/10.1111/2041-210X.12594
"""
qualifiers = {
    "aberratio": ["ab."],
    "adultus|i": ["ad."],
    "affinis": ["aff."],
    "animalia cetera": ["a.c."],
    "cetera": ["c.", "cet."],
    "conchylium|a": ["conch.", "shell"],
    "confer": ["cf.", "cfr.", "conf.", "sp. cf."],
    "ex affinis": ["ex aff."],
    "ex grege": ["ex gr.", "gr."],
    "exuvia|ae": ["ex."],
    "familia genus species": ["fam. gen. sp."],
    "familia nova": ["fam. n.", "fam. nov.", "n. fam.", "nov. fam."],
    "female": ["f."],
    "forma": ["f."],
    "fragmentum|a": ["frag.", "fr."],
    "genus novum": [
        "g. n.",
        "g. nov.",
        "gen. et sp. nov.",
        "gen. n.",
        "gen. nov.",
        "n. g.",
        "nov. gen et sp.",
        "nov. gen.",
    ],
    "genus species": ["g. sp.", "gen. sp."],
    "incertae sedis": ["inc. sed."],
    "juvenile|s": ["juv"],
    "larva|ae": ["l.", "lv."],
    "male": ["m."],
    "nova species": ["n. sp.", "nov. sp.", "nov. spec."],
    "ovigerous females": ["ov.", "ovig."],
    "pupa|ae": ["p."],
    "secundum": ["sec"],
    "sensu": ["sensu"],
    "sensu amplo": ["s. a.", "s. ampl."],
    "sensu lato": ["s.l", "s. lat."],
    "sensu stricto": ["s.s.", "s. str."],
    "species": ["sp.", "spp."],
    "species affinis": ["sp. aff."],
    "species aggregate": ["agg.", "sp. agg."],
    "species complex": ["complex"],
    "species dubia": ["sp. dub."],
    "species group": ["gr.", "group", "sp. gr."],
    "species incerta": ["?", "gen. inc.", "gen. et sp. inc.", "inc.", "sp. inc."],
    "species indeterminabilis": ["ind.", "indet.", "sp. ind.", "sp. indet."],
    "species indeterminata": ["ind.", "indet.", "sp. ind.", "sp. indet."],
    "species inquirenda": ["sp. inq."],
    "species near": ["nr.", "sp. nr."],
    "species nova": ["sp. n.", "sp. nov.", "spec. nov."],
    "species plurimae": ["sp. pl."],
    "species proxima": ["prox.", "sp. prox."],
    "stetit": ["stet."],
    "subspecies": ["ssp.", "subsp."],
    "subspecies nova": ["n. ssp.", "ssp. n.", "ssp. nov.", "subsp. n.", "subsp. nov."],
    "valva|e": ["valva"],
    "varietas": ["v.", "var."],
}
