# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ServiceDynamicSnippetContentv1Args', 'ServiceDynamicSnippetContentv1']

@pulumi.input_type
class ServiceDynamicSnippetContentv1Args:
    def __init__(__self__, *,
                 content: pulumi.Input[str],
                 service_id: pulumi.Input[str],
                 snippet_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ServiceDynamicSnippetContentv1 resource.
        :param pulumi.Input[str] content: The VCL code that specifies exactly what the snippet does
        :param pulumi.Input[str] service_id: The ID of the service that the dynamic snippet belongs to
        :param pulumi.Input[str] snippet_id: The ID of the dynamic snippet that the content belong to
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "service_id", service_id)
        pulumi.set(__self__, "snippet_id", snippet_id)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[str]:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        The ID of the service that the dynamic snippet belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> pulumi.Input[str]:
        """
        The ID of the dynamic snippet that the content belong to
        """
        return pulumi.get(self, "snippet_id")

    @snippet_id.setter
    def snippet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "snippet_id", value)


@pulumi.input_type
class _ServiceDynamicSnippetContentv1State:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 snippet_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceDynamicSnippetContentv1 resources.
        :param pulumi.Input[str] content: The VCL code that specifies exactly what the snippet does
        :param pulumi.Input[str] service_id: The ID of the service that the dynamic snippet belongs to
        :param pulumi.Input[str] snippet_id: The ID of the dynamic snippet that the content belong to
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if snippet_id is not None:
            pulumi.set(__self__, "snippet_id", snippet_id)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the service that the dynamic snippet belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dynamic snippet that the content belong to
        """
        return pulumi.get(self, "snippet_id")

    @snippet_id.setter
    def snippet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snippet_id", value)


class ServiceDynamicSnippetContentv1(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 snippet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Defines content that represents blocks of VCL logic that is inserted into your service.  This resource will populate the content of a dynamic snippet and allow it to be manged without the creation of a new service verison.

        > **Warning:** This provider will take precedence over any changes you make through the API. Such changes are likely to be reversed if you run the provider again.

        If this provider is being used to populate the initial content of a dynamic snippet which you intend to manage via the API, then the lifecycle `ignore_changes` field can be used with the resource.  An example of this configuration is provided below.

        ## Example Usage

        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_dynamic_snippet_content_v1.content` The resource ID is a combined value of the `service_id` and `snippet_id` separated by a forward slash.

        ```sh
         $ pulumi import fastly:index/serviceDynamicSnippetContentv1:ServiceDynamicSnippetContentv1 content xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content: The VCL code that specifies exactly what the snippet does
        :param pulumi.Input[str] service_id: The ID of the service that the dynamic snippet belongs to
        :param pulumi.Input[str] snippet_id: The ID of the dynamic snippet that the content belong to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceDynamicSnippetContentv1Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Defines content that represents blocks of VCL logic that is inserted into your service.  This resource will populate the content of a dynamic snippet and allow it to be manged without the creation of a new service verison.

        > **Warning:** This provider will take precedence over any changes you make through the API. Such changes are likely to be reversed if you run the provider again.

        If this provider is being used to populate the initial content of a dynamic snippet which you intend to manage via the API, then the lifecycle `ignore_changes` field can be used with the resource.  An example of this configuration is provided below.

        ## Example Usage

        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_dynamic_snippet_content_v1.content` The resource ID is a combined value of the `service_id` and `snippet_id` separated by a forward slash.

        ```sh
         $ pulumi import fastly:index/serviceDynamicSnippetContentv1:ServiceDynamicSnippetContentv1 content xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param ServiceDynamicSnippetContentv1Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceDynamicSnippetContentv1Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 snippet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceDynamicSnippetContentv1Args.__new__(ServiceDynamicSnippetContentv1Args)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            if snippet_id is None and not opts.urn:
                raise TypeError("Missing required property 'snippet_id'")
            __props__.__dict__["snippet_id"] = snippet_id
        super(ServiceDynamicSnippetContentv1, __self__).__init__(
            'fastly:index/serviceDynamicSnippetContentv1:ServiceDynamicSnippetContentv1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content: Optional[pulumi.Input[str]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            snippet_id: Optional[pulumi.Input[str]] = None) -> 'ServiceDynamicSnippetContentv1':
        """
        Get an existing ServiceDynamicSnippetContentv1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content: The VCL code that specifies exactly what the snippet does
        :param pulumi.Input[str] service_id: The ID of the service that the dynamic snippet belongs to
        :param pulumi.Input[str] snippet_id: The ID of the dynamic snippet that the content belong to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceDynamicSnippetContentv1State.__new__(_ServiceDynamicSnippetContentv1State)

        __props__.__dict__["content"] = content
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["snippet_id"] = snippet_id
        return ServiceDynamicSnippetContentv1(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[str]:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The ID of the service that the dynamic snippet belongs to
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> pulumi.Output[str]:
        """
        The ID of the dynamic snippet that the content belong to
        """
        return pulumi.get(self, "snippet_id")

