from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..models.credit_card_card_type import CreditCardCardType
from ..types import UNSET, Unset

T = TypeVar("T", bound="CreditCard")


@attr.s(auto_attribs=True)
class CreditCard:
    """Credit card details.<p>Used to send payment details for a booking</p>

    Attributes:
        card_country (Union[Unset, str]):
        card_name (Union[Unset, str]): Full name on the credit card
        card_number (Union[Unset, str]): Full Credit card number, no spaces or special characters
        card_security_number (Union[Unset, str]): Credit Card CVV / CVN
        card_token (Union[Unset, str]):  Credit card Token generated by client libraries. Use instead of other card
            attributes for supported gateways.<br>For example when using Stripe.js, only send the cardToken attribute. Do
            not send cardNumber or any other attribute.
        card_type (Union[Unset, CreditCardCardType]): Type of card
        expiry_month (Union[Unset, str]): <ul>Expiry month of the card<li>01 : January</li><li>02 : February</li><li>03
            : March</li><li>04 : April</li><li>05 : May</li><li>06 : June</li><li>07 : July</li><li>08 : August</li><li>09 :
            September</li><li>10 : October</li><li>11 : November</li><li>12 : December</li></ul>
        expiry_year (Union[Unset, str]): Expiry year of the card in 4 digits<br>(i.e 2015 / 2016 ...)
    """

    card_country: Union[Unset, str] = UNSET
    card_name: Union[Unset, str] = UNSET
    card_number: Union[Unset, str] = UNSET
    card_security_number: Union[Unset, str] = UNSET
    card_token: Union[Unset, str] = UNSET
    card_type: Union[Unset, CreditCardCardType] = UNSET
    expiry_month: Union[Unset, str] = UNSET
    expiry_year: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        card_country = self.card_country
        card_name = self.card_name
        card_number = self.card_number
        card_security_number = self.card_security_number
        card_token = self.card_token
        card_type: Union[Unset, str] = UNSET
        if not isinstance(self.card_type, Unset):
            card_type = self.card_type.value

        expiry_month = self.expiry_month
        expiry_year = self.expiry_year

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if card_country is not UNSET:
            field_dict["cardCountry"] = card_country
        if card_name is not UNSET:
            field_dict["cardName"] = card_name
        if card_number is not UNSET:
            field_dict["cardNumber"] = card_number
        if card_security_number is not UNSET:
            field_dict["cardSecurityNumber"] = card_security_number
        if card_token is not UNSET:
            field_dict["cardToken"] = card_token
        if card_type is not UNSET:
            field_dict["cardType"] = card_type
        if expiry_month is not UNSET:
            field_dict["expiryMonth"] = expiry_month
        if expiry_year is not UNSET:
            field_dict["expiryYear"] = expiry_year

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        card_country = d.pop("cardCountry", UNSET)

        card_name = d.pop("cardName", UNSET)

        card_number = d.pop("cardNumber", UNSET)

        card_security_number = d.pop("cardSecurityNumber", UNSET)

        card_token = d.pop("cardToken", UNSET)

        _card_type = d.pop("cardType", UNSET)
        card_type: Union[Unset, CreditCardCardType]
        if isinstance(_card_type, Unset):
            card_type = UNSET
        else:
            card_type = CreditCardCardType(_card_type)

        expiry_month = d.pop("expiryMonth", UNSET)

        expiry_year = d.pop("expiryYear", UNSET)

        credit_card = cls(
            card_country=card_country,
            card_name=card_name,
            card_number=card_number,
            card_security_number=card_security_number,
            card_token=card_token,
            card_type=card_type,
            expiry_month=expiry_month,
            expiry_year=expiry_year,
        )

        credit_card.additional_properties = d
        return credit_card

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
