from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..models.request_status import RequestStatus
from ..models.voucher import Voucher
from ..types import UNSET, Unset

T = TypeVar("T", bound="ResponseVoucher")


@attr.s(auto_attribs=True)
class ResponseVoucher:
    """
    Attributes:
        request_status (RequestStatus):
        voucher (Union[Unset, Voucher]): A Voucher is a gift card that can be used to pay for a booking.<br>It can also
            be generated by a booking when a customer buys a Gift Card.<br>This is not a "confirmation voucher", you should
            use Booking.orderNumber as a confirmation code to show to customers.
    """

    request_status: RequestStatus
    voucher: Union[Unset, Voucher] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        request_status = self.request_status.to_dict()

        voucher: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.voucher, Unset):
            voucher = self.voucher.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "requestStatus": request_status,
            }
        )
        if voucher is not UNSET:
            field_dict["voucher"] = voucher

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        request_status = RequestStatus.from_dict(d.pop("requestStatus"))

        _voucher = d.pop("voucher", UNSET)
        voucher: Union[Unset, Voucher]
        if isinstance(_voucher, Unset):
            voucher = UNSET
        else:
            voucher = Voucher.from_dict(_voucher)

        response_voucher = cls(
            request_status=request_status,
            voucher=voucher,
        )

        response_voucher.additional_properties = d
        return response_voucher

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
