/* Copyright 2021 Ryan Castellucci, MIT License */

#include <Python.h>

#include "nflogconst.h"

int nflog_add_hwtypes(PyObject *m) {
  if (!m) { return -1; }
  // fgrep ARPHRD_ /usr/include/linux/if_arp.h | perl -pe 's/.+ARPHRD_(\S+)\s+(\S+).*/  ADDINTCONST(m, "HWTYPE_$1", $2);/'
  ADDINTCONST(m, "HWTYPE_NETROM", 0);
  ADDINTCONST(m, "HWTYPE_ETHER", 1);
  ADDINTCONST(m, "HWTYPE_EETHER", 2);
  ADDINTCONST(m, "HWTYPE_AX25", 3);
  ADDINTCONST(m, "HWTYPE_PRONET", 4);
  ADDINTCONST(m, "HWTYPE_CHAOS", 5);
  ADDINTCONST(m, "HWTYPE_IEEE802", 6);
  ADDINTCONST(m, "HWTYPE_ARCNET", 7);
  ADDINTCONST(m, "HWTYPE_APPLETLK", 8);
  ADDINTCONST(m, "HWTYPE_DLCI", 15);
  ADDINTCONST(m, "HWTYPE_ATM", 19);
  ADDINTCONST(m, "HWTYPE_METRICOM", 23);
  ADDINTCONST(m, "HWTYPE_IEEE1394", 24);
  ADDINTCONST(m, "HWTYPE_EUI64", 27);
  ADDINTCONST(m, "HWTYPE_INFINIBAND", 32);
  ADDINTCONST(m, "HWTYPE_SLIP", 256);
  ADDINTCONST(m, "HWTYPE_CSLIP", 257);
  ADDINTCONST(m, "HWTYPE_SLIP6", 258);
  ADDINTCONST(m, "HWTYPE_CSLIP6", 259);
  ADDINTCONST(m, "HWTYPE_RSRVD", 260);
  ADDINTCONST(m, "HWTYPE_ADAPT", 264);
  ADDINTCONST(m, "HWTYPE_ROSE", 270);
  ADDINTCONST(m, "HWTYPE_X25", 271);
  ADDINTCONST(m, "HWTYPE_HWX25", 272);
  ADDINTCONST(m, "HWTYPE_CAN", 280);
  ADDINTCONST(m, "HWTYPE_PPP", 512);
  ADDINTCONST(m, "HWTYPE_CISCO", 513);
  ADDINTCONST(m, "HWTYPE_HDLC", 513);
  ADDINTCONST(m, "HWTYPE_LAPB", 516);
  ADDINTCONST(m, "HWTYPE_DDCMP", 517);
  ADDINTCONST(m, "HWTYPE_RAWHDLC", 518);
  ADDINTCONST(m, "HWTYPE_RAWIP", 519);
  ADDINTCONST(m, "HWTYPE_TUNNEL", 768);
  ADDINTCONST(m, "HWTYPE_TUNNEL6", 769);
  ADDINTCONST(m, "HWTYPE_FRAD", 770);
  ADDINTCONST(m, "HWTYPE_SKIP", 771);
  ADDINTCONST(m, "HWTYPE_LOOPBACK", 772);
  ADDINTCONST(m, "HWTYPE_LOCALTLK", 773);
  ADDINTCONST(m, "HWTYPE_FDDI", 774);
  ADDINTCONST(m, "HWTYPE_BIF", 775);
  ADDINTCONST(m, "HWTYPE_SIT", 776);
  ADDINTCONST(m, "HWTYPE_IPDDP", 777);
  ADDINTCONST(m, "HWTYPE_IPGRE", 778);
  ADDINTCONST(m, "HWTYPE_PIMREG", 779);
  ADDINTCONST(m, "HWTYPE_HIPPI", 780);
  ADDINTCONST(m, "HWTYPE_ASH", 781);
  ADDINTCONST(m, "HWTYPE_ECONET", 782);
  ADDINTCONST(m, "HWTYPE_IRDA", 783);
  ADDINTCONST(m, "HWTYPE_FCPP", 784);
  ADDINTCONST(m, "HWTYPE_FCAL", 785);
  ADDINTCONST(m, "HWTYPE_FCPL", 786);
  ADDINTCONST(m, "HWTYPE_FCFABRIC", 787);
  ADDINTCONST(m, "HWTYPE_IEEE802_TR", 800);
  ADDINTCONST(m, "HWTYPE_IEEE80211", 801);
  ADDINTCONST(m, "HWTYPE_IEEE80211_PRISM", 802);
  ADDINTCONST(m, "HWTYPE_IEEE80211_RADIOTAP", 803);
  ADDINTCONST(m, "HWTYPE_IEEE802154", 804);
  ADDINTCONST(m, "HWTYPE_IEEE802154_MONITOR", 805);
  ADDINTCONST(m, "HWTYPE_PHONET", 820);
  ADDINTCONST(m, "HWTYPE_PHONET_PIPE", 821);
  ADDINTCONST(m, "HWTYPE_CAIF", 822);
  ADDINTCONST(m, "HWTYPE_IP6GRE", 823);
  ADDINTCONST(m, "HWTYPE_NETLINK", 824);
  ADDINTCONST(m, "HWTYPE_6LOWPAN", 825);
  ADDINTCONST(m, "HWTYPE_VSOCKMON", 826);
  ADDINTCONST(m, "HWTYPE_VOID", 0xFFFF);
  ADDINTCONST(m, "HWTYPE_NONE", 0xFFFE);
  return 0;
}

/*  vim: set ts=2 sw=2 et ai si: */
