"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTestingExistingVpcSubnets = exports.IntegTesting = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'keycloak-demo', { env });
        // create a default keycloak workload with minimal required props
        new index_1.KeyCloak(stack, 'KeyCloak', {
            certificateArn: stack.node.tryGetContext('ACM_CERT_ARN') || 'MOCK_ARN',
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
class IntegTestingExistingVpcSubnets {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'keycloak-demo', { env });
        new index_1.KeyCloak(stack, 'KeyCloak', {
            certificateArn: stack.node.tryGetContext('ACM_CERT_ARN') || 'MOCK_ARN',
            vpc: ec2.Vpc.fromLookup(stack, 'Vpc', { vpcId: 'vpc-0417e46d' }),
            publicSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'pub-1a', 'subnet-5bbe7b32'),
                    ec2.Subnet.fromSubnetId(stack, 'pub-1b', 'subnet-0428367c'),
                    ec2.Subnet.fromSubnetId(stack, 'pub-1c', 'subnet-1586a75f'),
                ],
            },
            privateSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'priv-1a', 'subnet-0e9460dbcfc4cf6ee'),
                    ec2.Subnet.fromSubnetId(stack, 'priv-1b', 'subnet-0562f666bdf5c29af'),
                    ec2.Subnet.fromSubnetId(stack, 'priv-1c', 'subnet-00ab15c0022872f06'),
                ],
            },
            databaseSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'db-1a', 'subnet-0e9460dbcfc4cf6ee'),
                    ec2.Subnet.fromSubnetId(stack, 'db-1b', 'subnet-0562f666bdf5c29af'),
                    ec2.Subnet.fromSubnetId(stack, 'db-1c', 'subnet-00ab15c0022872f06'),
                ],
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTestingExistingVpcSubnets = IntegTestingExistingVpcSubnets;
new IntegTesting();
// new IntegTestingExistingVpcSubnets();
//# sourceMappingURL=data:application/json;base64,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