from copy import deepcopy

from spoonbill.common import ROOT_TABLES

TEST_ROOT_TABLES = deepcopy(ROOT_TABLES)
TEST_COMBINED_TABLES = {
    "documents": [
        "/planning/documents",
        "/tender/documents",
        "/awards/documents",
        "/contracts/documents",
        "/contracts/implementation/documents",
    ],
    "milestones": [
        "/planning/milestones",
        "/tender/milestones",
        "/contracts/milestones",
        "/contracts/implementation/milestones",
    ],
    "amendments": [
        "/planning/amendments",
        "/tender/amendments",
        "/awards/amendments",
        "/contracts/amendments",
        "/contracts/implementation/amendments",
    ],
}

tenders_columns = [
    "/tender/id",
    "/tender/title",
    "/tender/description",
    "/tender/status",
    "/tender/procurementMethod",
    "/tender/procurementMethodDetails",
    "/tender/procurementMethodRationale",
    "/tender/mainProcurementCategory",
    "/tender/additionalProcurementCategories",
    "/tender/awardCriteria",
    "/tender/awardCriteriaDetails",
    "/tender/submissionMethodDetails",
    "/tender/submissionMethod",
    "/tender/hasEnquiries",
    "/tender/eligibilityCriteria",
    "/tender/numberOfTenderers",
    "/tender/contractPeriod/startDate",
    "/tender/contractPeriod/endDate",
    "/tender/contractPeriod/maxExtentDate",
    "/tender/contractPeriod/durationInDays",
    "/tender/awardPeriod/startDate",
    "/tender/awardPeriod/endDate",
    "/tender/awardPeriod/maxExtentDate",
    "/tender/awardPeriod/durationInDays",
    "/tender/enquiryPeriod/startDate",
    "/tender/enquiryPeriod/endDate",
    "/tender/enquiryPeriod/maxExtentDate",
    "/tender/enquiryPeriod/durationInDays",
    "/tender/tenderPeriod/startDate",
    "/tender/tenderPeriod/endDate",
    "/tender/tenderPeriod/maxExtentDate",
    "/tender/tenderPeriod/durationInDays",
    "/tender/minValue/amount",
    "/tender/minValue/currency",
    "/tender/value/amount",
    "/tender/value/currency",
    "/tender/procuringEntity/name",
    "/tender/procuringEntity/id",
]
tenders_arrays = [
    "/tender/items",
    "/tender/tenderers",
    "/tender/items/additionalClassifications",
]
tenders_combined_columns = [
    "/tender/id",
    "/tender/title",
    "/tender/description",
    "/tender/status",
    "/tender/procurementMethod",
    "/tender/procurementMethodDetails",
    "/tender/procurementMethodRationale",
    "/tender/mainProcurementCategory",
    "/tender/additionalProcurementCategories",
    "/tender/awardCriteria",
    "/tender/awardCriteriaDetails",
    "/tender/submissionMethod",
    "/tender/submissionMethodDetails",
    "/tender/hasEnquiries",
    "/tender/eligibilityCriteria",
    "/tender/numberOfTenderers",
    "/tender/tenderers/0/name",
    "/tender/tenderers/0/id",
    "/tender/contractPeriod/startDate",
    "/tender/contractPeriod/endDate",
    "/tender/contractPeriod/maxExtentDate",
    "/tender/contractPeriod/durationInDays",
    "/tender/awardPeriod/startDate",
    "/tender/awardPeriod/endDate",
    "/tender/awardPeriod/maxExtentDate",
    "/tender/awardPeriod/durationInDays",
    "/tender/enquiryPeriod/startDate",
    "/tender/enquiryPeriod/endDate",
    "/tender/enquiryPeriod/maxExtentDate",
    "/tender/enquiryPeriod/durationInDays",
    "/tender/tenderPeriod/startDate",
    "/tender/tenderPeriod/endDate",
    "/tender/tenderPeriod/maxExtentDate",
    "/tender/tenderPeriod/durationInDays",
    "/tender/minValue/amount",
    "/tender/minValue/currency",
    "/tender/value/amount",
    "/tender/value/currency",
    "/tender/items/0/id",
    "/tender/items/0/description",
    "/tender/items/0/quantity",
    "/tender/items/0/unit/scheme",
    "/tender/items/0/unit/id",
    "/tender/items/0/unit/name",
    "/tender/items/0/unit/uri",
    "/tender/items/0/unit/value/amount",
    "/tender/items/0/unit/value/currency",
    "/tender/items/0/additionalClassifications/0/scheme",
    "/tender/items/0/additionalClassifications/0/id",
    "/tender/items/0/additionalClassifications/0/description",
    "/tender/items/0/additionalClassifications/0/uri",
    "/tender/items/0/classification/scheme",
    "/tender/items/0/classification/id",
    "/tender/items/0/classification/description",
    "/tender/items/0/classification/uri",
    "/tender/procuringEntity/name",
    "/tender/procuringEntity/id",
]

awards_columns = [
    "/awards/id",
    "/awards/title",
    "/awards/description",
    "/awards/status",
    "/awards/date",
    "/awards/contractPeriod/startDate",
    "/awards/contractPeriod/endDate",
    "/awards/contractPeriod/maxExtentDate",
    "/awards/contractPeriod/durationInDays",
    "/awards/value/amount",
    "/awards/value/currency",
]
awards_combined_columns = [
    "/awards/id",
    "/awards/title",
    "/awards/description",
    "/awards/status",
    "/awards/date",
    "/awards/contractPeriod/startDate",
    "/awards/contractPeriod/endDate",
    "/awards/contractPeriod/maxExtentDate",
    "/awards/contractPeriod/durationInDays",
    "/awards/items/0/id",
    "/awards/items/0/description",
    "/awards/items/0/quantity",
    "/awards/items/0/unit/scheme",
    "/awards/items/0/unit/id",
    "/awards/items/0/unit/name",
    "/awards/items/0/unit/uri",
    "/awards/items/0/unit/value/amount",
    "/awards/items/0/unit/value/currency",
    "/awards/items/0/additionalClassifications/0/scheme",
    "/awards/items/0/additionalClassifications/0/id",
    "/awards/items/0/additionalClassifications/0/description",
    "/awards/items/0/additionalClassifications/0/uri",
    "/awards/items/0/classification/scheme",
    "/awards/items/0/classification/id",
    "/awards/items/0/classification/description",
    "/awards/items/0/classification/uri",
    "/awards/suppliers/0/name",
    "/awards/suppliers/0/id",
    "/awards/value/amount",
    "/awards/value/currency",
]

awards_arrays = [
    "/awards/suppliers",
    "/awards/items",
    "/awards/items/additionalClassifications",
]
contracts_columns = [
    "/contracts/id",
    "/contracts/awardID",
    "/contracts/title",
    "/contracts/description",
    "/contracts/status",
    "/contracts/dateSigned",
    "/contracts/value/amount",
    "/contracts/value/currency",
    "/contracts/period/startDate",
    "/contracts/period/endDate",
    "/contracts/period/maxExtentDate",
    "/contracts/period/durationInDays",
]
contracts_arrays = [
    "/contracts/items",
    "/contracts/relatedProcesses",
    "/contracts/implementation/transactions",
    "/contracts/items/additionalClassifications",
]
contracts_combined_columns = [
    "/contracts/id",
    "/contracts/awardID",
    "/contracts/title",
    "/contracts/description",
    "/contracts/status",
    "/contracts/dateSigned",
    "/contracts/relatedProcesses/0/id",
    "/contracts/relatedProcesses/0/relationship",
    "/contracts/relatedProcesses/0/title",
    "/contracts/relatedProcesses/0/scheme",
    "/contracts/relatedProcesses/0/identifier",
    "/contracts/relatedProcesses/0/uri",
    "/contracts/implementation/transactions/0/id",
    "/contracts/implementation/transactions/0/source",
    "/contracts/implementation/transactions/0/date",
    "/contracts/implementation/transactions/0/uri",
    "/contracts/implementation/transactions/0/payee/name",
    "/contracts/implementation/transactions/0/payee/id",
    "/contracts/implementation/transactions/0/payer/name",
    "/contracts/implementation/transactions/0/payer/id",
    "/contracts/implementation/transactions/0/value/amount",
    "/contracts/implementation/transactions/0/value/currency",
    "/contracts/items/0/id",
    "/contracts/items/0/description",
    "/contracts/items/0/quantity",
    "/contracts/items/0/unit/scheme",
    "/contracts/items/0/unit/id",
    "/contracts/items/0/unit/name",
    "/contracts/items/0/unit/uri",
    "/contracts/items/0/unit/value/amount",
    "/contracts/items/0/unit/value/currency",
    "/contracts/items/0/additionalClassifications/0/scheme",
    "/contracts/items/0/additionalClassifications/0/id",
    "/contracts/items/0/additionalClassifications/0/description",
    "/contracts/items/0/additionalClassifications/0/uri",
    "/contracts/items/0/classification/scheme",
    "/contracts/items/0/classification/id",
    "/contracts/items/0/classification/description",
    "/contracts/items/0/classification/uri",
    "/contracts/value/amount",
    "/contracts/value/currency",
    "/contracts/period/startDate",
    "/contracts/period/endDate",
    "/contracts/period/maxExtentDate",
    "/contracts/period/durationInDays",
]

planning_columns = [
    "/planning/rationale",
    "/planning/budget/id",
    "/planning/budget/description",
    "/planning/budget/project",
    "/planning/budget/projectID",
    "/planning/budget/uri",
    "/planning/budget/amount/amount",
    "/planning/budget/amount/currency",
]

planning_combined_columns = [
    "/planning/rationale",
    "/planning/budget/id",
    "/planning/budget/description",
    "/planning/budget/project",
    "/planning/budget/projectID",
    "/planning/budget/uri",
    "/planning/budget/amount/amount",
    "/planning/budget/amount/currency",
]
planning_arrays = []
parties_arrays = ["/parties/additionalIdentifiers"]
parties_columns = [
    "/parties/name",
    "/parties/id",
    "/parties/roles",
    "/parties/contactPoint/name",
    "/parties/contactPoint/email",
    "/parties/contactPoint/telephone",
    "/parties/contactPoint/faxNumber",
    "/parties/contactPoint/url",
    "/parties/address/streetAddress",
    "/parties/address/locality",
    "/parties/address/region",
    "/parties/address/postalCode",
    "/parties/address/countryName",
    "/parties/identifier/scheme",
    "/parties/identifier/id",
    "/parties/identifier/legalName",
    "/parties/identifier/uri",
]
parties_combined_columns = [
    "/parties/name",
    "/parties/id",
    "/parties/roles",
    "/parties/roles",
    "/parties/contactPoint/name",
    "/parties/contactPoint/email",
    "/parties/contactPoint/telephone",
    "/parties/contactPoint/faxNumber",
    "/parties/contactPoint/url",
    "/parties/address/streetAddress",
    "/parties/address/locality",
    "/parties/address/region",
    "/parties/address/postalCode",
    "/parties/address/countryName",
    "/parties/additionalIdentifiers/0/scheme",
    "/parties/additionalIdentifiers/0/id",
    "/parties/additionalIdentifiers/0/legalName",
    "/parties/additionalIdentifiers/0/uri",
    "/parties/identifier/scheme",
    "/parties/identifier/id",
    "/parties/identifier/legalName",
    "/parties/identifier/uri",
]
