ALTER TABLE CRUISE.PLATFORMS ADD DESIGNATOR VARCHAR2(10);

ALTER TABLE CRUISE.PLATFORMS ADD PLATFORM_NAME VARCHAR2(100);

ALTER TABLE ACCESS_PATHS MODIFY PATH varchar2(1000);

drop trigger PLATFORMS_BI;

create sequence MB_NGDC_ID_SEQ
    nocache
/

ALTER TABLE SCIENTISTS ADD ROLE varchar2(25);


drop index SHAPES_SPX;

insert into MDSYS.USER_SDO_GEOM_METADATA (table_name, column_name, diminfo, srid)
values ('SHAPES', 'SHAPE',
        MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('Longitude', -180, 180, 0.05), MDSYS.SDO_DIM_ELEMENT('Latitude', -90, 90, 0.05)), 8307);

create index SHAPES_SPX on SHAPES (SHAPE) indextype is MDSYS.SPATIAL_INDEX;


insert into PARAMETER_DETAILS (PARAMETER) VALUES ('FILE_FORMAT_TYPE');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('FILE_FORMAT_PROTOCOL');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('FILE_FORMAT_ATTRIBUTES');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_SYSTEM_ID');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_FILE_FORMAT_ID');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MD5_CHECKSUM');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('SHA256_CHECKSUM');

insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_OBJECT_COUNT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_TOTAL_TIME_HOURS');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_TOTAL_TRACK_LENGTH_KM');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_AVG_SPEED_KM_HR');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_MIN_SONAR_DEPTH_M');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_MAX_SONAR_DEPTH_M');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_MIN_ALTITUDE');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_MAX_ALTITUDE');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_MIN_DEPTH');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_MAX_DEPTH');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_MIN_AMPLITUDE');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_MAX_AMPLITUDE');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_MIN_SIDESCAN');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_MAX_SIDESCAN');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_FILE_COUNT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_RECORD_COUNT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_BATHY_BEAMS');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_GOOD_BATH_TOTAL');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_GOOD_BATH_PERCENT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_ZERO_BATH_TOTAL');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_ZERO_BATH_PERCENT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_FLAGGED_BATH_TOTAL');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_FLAGGED_BATH_PERCENT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_AMP_BEAMS');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_GOOD_AMP_TOTAL');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_GOOD_AMP_PERCENT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_ZERO_AMP_TOTAL');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_ZERO_AMP_PERCENT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_FLAGGED_AMP_TOTAL');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_FLAGGED_AMP_PERCENT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_SIDESCANS');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_GOOD_SIDESCANS_TOTAL');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_GOOD_SIDESCANS_PERCENT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_ZERO_SIDESCANS_TOTAL');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_ZERO_SIDESCANS_PERCENT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_FLAGGED_SIDESCANS_TOTAL');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_FLAGGED_SIDESCANS_PERCENT');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_BBOX_NORTH');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_BBOX_SOUTH');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_BBOX_EAST');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_BBOX_WEST');

insert into PARAMETER_DETAILS (PARAMETER) VALUES ('DIRECTORY_STRUCTURE_TYPE');

insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_NGDC_ID');

insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_DATASET_DIR');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('DATASET_DIRECTORY');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MB_AREA_SQ_KM');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Publish');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Proprietary');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Comments');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('NAV1');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('NAV2');

insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Horizontal_Datum');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Vertical_Datum');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Tide_Correction');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Sound_Velocity');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Previous_State');

insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Modify_Date_Data');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Modify_Date_Metadata');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Extract_Metadata');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Download_URL');

insert into PARAMETER_DETAILS (PARAMETER) VALUES ('MBIO_Format_ID');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Start_Time');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Start_Lon');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Start_Lat');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Start_Depth');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Start_Speed');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Start_Heading');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Start_Sonar_Depth');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Start_Sonar_Alt');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('End_Time');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('End_Lon');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('End_Lat');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('End_Depth');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('End_Speed');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('End_Heading');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('End_Sonar_Depth');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('End_Sonar_Alt');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Min_Lon');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Max_Lon');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Min_Lat');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Max_Lat');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Min_Sonar_Alt');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Max_Sonar_Alt');
insert into PARAMETER_DETAILS (PARAMETER) VALUES ('Object_ID');


insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ANC_SVP', 'Sound Speed Profiles (SSP or SVP)');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SVP'),
        '4000'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SVP'),
        'ASCII sound speed measurements applied to multibeam soundings'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SVP'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SVP'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('METADATA_INF', 'Informal metadata text');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'METADATA_INF'),
        '3002'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'METADATA_INF'),
        'ASCII'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'METADATA_INF'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'METADATA_INF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IMAGE_BMP', 'Bitmap image product');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_BMP'),
        '2007'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_BMP'),
        'Bitmap image product'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_BMP'),
        'Images'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_BMP'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ANC_SUPPORT', 'Supporting data');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SUPPORT'),
        '4005'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SUPPORT'),
        'Additional ancillary support data'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SUPPORT'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SUPPORT'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IVS_SD', 'Fledermaus surface');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IVS_SD'),
        '2008'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IVS_SD'),
        'Fledermaus gridded surface'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IVS_SD'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IVS_SD'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('GRID_BAG', 'Bathymetric Attributed Grid');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GRID_BAG'),
        '2010'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GRID_BAG'),
        'Open Navigation Surface Bathymetric Attributed Grid file'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GRID_BAG'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GRID_BAG'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('DATAFILE_XML', 'XML metadata file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'DATAFILE_XML'),
        '3001'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'DATAFILE_XML'),
        'XML format metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'DATAFILE_XML'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'DATAFILE_XML'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('NETCDF', 'netCDF grid file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'NETCDF'),
        '1000'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'NETCDF'),
        'binary'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'NETCDF'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'NETCDF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ANC_NAV', 'Navigation data');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_NAV'),
        '4006'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_NAV'),
        'Navigation data from ship''s positioning equipment'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_NAV'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_NAV'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ESRI_ASC', 'ESRI Arc ASCII');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ESRI_ASC'),
        '2009'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ESRI_ASC'),
        'ESRI Arc ASCII'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ESRI_ASC'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ESRI_ASC'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('PDF', 'PDF product');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PDF'),
        '2011'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PDF'),
        'PDF products, reports, images'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PDF'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PDF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SBSIOMRG', 'SIO merge Sea Beam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOMRG'),
        '11'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOMRG'),
        '11'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOMRG'),
        'Sea Beam, bathymetry, 16 beams, binary, uncentered, SIO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOMRG'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOMRG'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SBSIOCEN', 'SIO centered Sea Beam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOCEN'),
        '12'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOCEN'),
        '12'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOCEN'),
        'Sea Beam, bathymetry, 19 beams, binary, centered, SIO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOCEN'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOCEN'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SBSIOLSI', 'SIO LSI Sea Beam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOLSI'),
        '13'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOLSI'),
        '13'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOLSI'),
        'Sea Beam, bathymetry, 19 beams, binary, centered, obsolete, SIO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOLSI'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOLSI'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SBURICEN', 'URI Sea Beam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBURICEN'),
        '14'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBURICEN'),
        '14'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBURICEN'),
        'Sea Beam, bathymetry, 19 beams, binary, centered, URI'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBURICEN'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBURICEN'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SBURIVAX', 'URI Sea Beam from VAX');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBURIVAX'),
        '15'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBURIVAX'),
        '15'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBURIVAX'),
        'Sea Beam, bathymetry, 19 beams, binary, centered, VAX byte order, URI'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBURIVAX'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBURIVAX'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SBSIOSWB', 'SIO Swath-bathy SeaBeam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOSWB'),
        '16'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOSWB'),
        '16'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOSWB'),
        'Sea Beam, bathymetry, 19 beams, binary, centered, SIO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOSWB'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBSIOSWB'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SBIFREMR', 'IFREMER Archive SeaBeam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBIFREMR'),
        '17'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBIFREMR'),
        '17'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBIFREMR'),
        'Sea Beam, bathymetry, 19 beams, ascii, centered, IFREMER'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBIFREMR'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SBIFREMR'),
        'ARCHIVE'
    );


insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSATLRAW', 'Raw Hydrosweep');
-- Note: Uses 2 system IDs
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSATLRAW'),
        '5,21'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSATLRAW'),
        '21'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSATLRAW'),
        'Hydrosweep DS, bathymetry and amplitude, 59 beams, ascii, Atlas Electronik'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSATLRAW'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSATLRAW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSLDEDMB', 'EDMB Hydrosweep');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEDMB'),
        '22'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEDMB'),
        '22'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEDMB'),
        'Hydrosweep DS, bathymetry, 59 beams, binary, NRL'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEDMB'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEDMB'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSURICEN', 'URI Hydrosweep');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSURICEN'),
        '23'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSURICEN'),
        '23'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSURICEN'),
        'Hydrosweep DS, 59 beams, bathymetry, binary, URI'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSURICEN'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSURICEN'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSLDEOIH', 'L-DEO in-house binary Hydrosweep');
-- Note: Uses 2 system IDs
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEOIH'),
        '8,24'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEOIH'),
        '24'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEOIH'),
        'Hydrosweep DS, 59 beams, bathymetry and amplitude, binary, centered, L-DEO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEOIH'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEOIH'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSURIVAX', 'URI Hydrosweep from VAX');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSURIVAX'),
        '25'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSURIVAX'),
        '25'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSURIVAX'),
        'Hydrosweep DS, 59 beams, bathymetry, binary, VAX byte order, URI'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSURIVAX'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSURIVAX'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SB2000SB', 'SIO Swath-bathy SeaBeam 2000 format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2000SB'),
        '32'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2000SB'),
        '32'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2000SB'),
        'SeaBeam 2000, bathymetry, 121 beams, binary, SIO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2000SB'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2000SB'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SB2000SS', 'SIO Swath-bathy SeaBeam 2000 format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2000SS'),
        '33'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2000SS'),
        '33'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2000SS'),
        'SeaBeam 2000, sidescan, 1000 pixels for 4-bit sidescan, 2000 pixels for 12+-bit sidescan, binary, SIO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2000SS'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2000SS'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SB2100RW', 'SeaBeam 2100 series vender format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100RW'),
        '41'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100RW'),
        '41'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100RW'),
        'SeaBeam 2100, bathymetry, amplitude and sidescan, 151 beams and 2000 pixels, ascii with binary sidescan, SeaBeam Instruments'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100RW'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100RW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SB2100B1', 'SeaBeam 2100 series vender format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100B1'),
        '42'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100B1'),
        '42'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100B1'),
        'SeaBeam 2100, bathymetry, amplitude and sidescan, 151 beams bathymetry, 2000 pixels sidescan, binary, SeaBeam Instruments and L-DEO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100B1'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100B1'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SB2100B2', 'SeaBeam 2100 series vender format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100B2'),
        '43'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100B2'),
        '43'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100B2'),
        'SeaBeam 2100, bathymetry and amplitude, 151 beams bathymetry, binary, SeaBeam Instruments and L-DEO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100B2'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SB2100B2'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_EMOLDRAW', 'Old Simrad vendor multibeam format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EMOLDRAW'),
        '51'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EMOLDRAW'),
        '51'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EMOLDRAW'),
        'Simrad EM1000, EM12S, EM12D, and EM121 multibeam sonars, bathymetry, amplitude, and sidescan, 60 beams for EM1000, 81 beams for EM12S/D, 121 beams for EM121, variable pixels, ascii + binary, Simrad'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EMOLDRAW'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EMOLDRAW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_EM12IFRM', 'IFREMER TRISMUS format for Simrad EM12');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM12IFRM'),
        '53'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM12IFRM'),
        '53'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM12IFRM'),
        'Simrad EM12S and EM12D, bathymetry, amplitude, and sidescan 81 beams, variable pixels, binary, IFREMER'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM12IFRM'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM12IFRM'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_EM12DARW', 'Simrad EM12S RRS Darwin processed format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM12DARW'),
        '54'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM12DARW'),
        '54'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM12DARW'),
        'Simrad EM12S, bathymetry and amplitude, 81 beams, binary, Oxford University'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM12DARW'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM12DARW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_EM300RAW', 'Simrad multibeam vendor format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM300RAW'),
        '56'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM300RAW'),
        '56'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM300RAW'),
        'Simrad EM120, EM300, EM1002, EM3000, bathymetry, amplitude, and sidescan, up to 254 beams, variable pixels, ascii + binary, Simrad'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM300RAW'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM300RAW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_EM300MBA', 'Simrad multibeam processing format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM300MBA'),
        '57'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM300MBA'),
        '57'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM300MBA'),
        'Old and new Simrad multibeams, EM12S, EM12D, EM121, EM120, EM300, EM100, EM1000, EM950, EM1002, EM3000, bathymetry, amplitude, and sidescan, up to 254 beams, variable pixels, ascii + binary, MBARI'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM300MBA'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM300MBA'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MR1PRHIG', 'SOEST MR1 post processed format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1PRHIG'),
        '61'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1PRHIG'),
        '61'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1PRHIG'),
        'SOEST MR1, bathymetry and sidescan, variable beams and pixels, xdr binary, SOEST, University of Hawaii'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1PRHIG'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1PRHIG'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MR1ALDEO', 'L-DEO MR1 post processed format with travel times');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1ALDEO'),
        '62'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1ALDEO'),
        '62'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1ALDEO'),
        'L-DEO MR1, bathymetry and sidescan, variable beams and pixels, xdr binary, L-DEO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1ALDEO'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1ALDEO'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MR1BLDEO', 'L-DEO small MR1 post processed format with travel times');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1BLDEO'),
        '63'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1BLDEO'),
        '63'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1BLDEO'),
        'L-DEO MR1, bathymetry and sidescan, variable beams and pixels, xdr binary, L-DEO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1BLDEO'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1BLDEO'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MBLDEOIH', 'L-DEO in-house generic multibeam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBLDEOIH'),
        '71'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBLDEOIH'),
        '71'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBLDEOIH'),
        'Data from all sonar systems, bathymetry, amplitude and sidescan, variable beams and pixels, binary, centered, L-DEO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBLDEOIH'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBLDEOIH'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_CBAT9001', 'Reson SeaBat 9001 shallow water multibeam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CBAT9001'),
        '81'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CBAT9001'),
        '81'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CBAT9001'),
        '60 beam bathymetry and amplitude, binary, University of New Brunswick'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CBAT9001'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CBAT9001'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_CBAT8101', 'Reson SeaBat 8101 shallow water multibeam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CBAT8101'),
        '82'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CBAT8101'),
        '82'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CBAT8101'),
        '101 beam bathymetry and amplitude, binary, SeaBeam Instruments'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CBAT8101'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CBAT8101'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HYPC8101', 'Reson SeaBat 8101 shallow water multibeam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYPC8101'),
        '83'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYPC8101'),
        '83'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYPC8101'),
        '101 beam bathymetry, ASCII, read-only, Coastal Oceanographics'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYPC8101'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYPC8101'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_XTFR8101', 'XTF format Reson SeaBat 81XX');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_XTFR8101'),
        '84'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_XTFR8101'),
        '84'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_XTFR8101'),
        '240 beam bathymetry and amplitude, 1024 pixel sidescan binary, read-only, Triton-Elics'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_XTFR8101'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_XTFR8101'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_BCHRTUNB', 'Elac BottomChart shallow water multibeam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_BCHRTUNB'),
        '91'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_BCHRTUNB'),
        '91'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_BCHRTUNB'),
        '56 beam bathymetry and amplitude, binary, University of New Brunswick'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_BCHRTUNB'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_BCHRTUNB'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_ELMK2UNB', 'Elac BottomChart MkII shallow water multibeam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ELMK2UNB'),
        '92'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ELMK2UNB'),
        '92'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ELMK2UNB'),
        '126 beam bathymetry and amplitude, binary, University of New Brunswick'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ELMK2UNB'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ELMK2UNB'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_BCHRXUNB', 'Elac BottomChart shallow water multibeam');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_BCHRXUNB'),
        '93'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_BCHRXUNB'),
        '93'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_BCHRXUNB'),
        '56 beam bathymetry and amplitude, binary, University of New Brunswick'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_BCHRXUNB'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_BCHRXUNB'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_L3XSERAW', 'ELAC/SeaBeam XSE vendor format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_L3XSERAW'),
        '94'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_L3XSERAW'),
        '94'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_L3XSERAW'),
        'Bottomchart MkII 50 kHz and 180 kHz multibeam, SeaBeam 2120 20 KHz multibeam, bathymetry, amplitude and sidescan, variable beams and pixels, binary, L3 Communications (Elac Nautik and SeaBeam Instruments)'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_L3XSERAW'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_L3XSERAW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSMDARAW', 'Atlas HSMD medium depth multibeam raw format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSMDARAW'),
        '101'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSMDARAW'),
        '101'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSMDARAW'),
        '40 beam bathymetry, 160 pixel sidescan, XDR (binary), STN Atlas Elektronik'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSMDARAW'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSMDARAW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSMDLDIH', 'Atlas HSMD medium depth multibeam processed format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSMDLDIH'),
        '102'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSMDLDIH'),
        '102'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSMDLDIH'),
        '40 beam bathymetry, 160 pixel sidescan, XDR (binary), L-DEO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSMDLDIH'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSMDLDIH'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_DSL120SF', 'WHOI DSL AMS-120 processed format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_DSL120SF'),
        '111'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_DSL120SF'),
        '111'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_DSL120SF'),
        '2048 beam bathymetry, 8192 pixel sidescan, binary, single files, WHOI DSL'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_DSL120SF'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_DSL120SF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_DSL120PF', 'WHOI DSL AMS-120 processed format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_DSL120PF'),
        '112'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_DSL120PF'),
        '112'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_DSL120PF'),
        '2048 beam bathymetry, 8192 pixel sidescan, binary, parallel bathymetry and amplitude files, WHOI DSL'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_DSL120PF'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_DSL120PF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_GSFGENMB', 'SAIC Generic Sensor Format (GSF)');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_GSFGENMB'),
        '121'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_GSFGENMB'),
        '121'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_GSFGENMB'),
        'variable beams, bathymetry and amplitude, binary, single files, SAIC'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_GSFGENMB'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_GSFGENMB'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MSTIFFSS', 'MSTIFF sidescan format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MSTIFFSS'),
        '131'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MSTIFFSS'),
        '131'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MSTIFFSS'),
        'variable pixels, sidescan, binary TIFF variant, single files, Sea Scan'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MSTIFFSS'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MSTIFFSS'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_OICGEODA', 'OIC swath sonar format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OICGEODA'),
        '141'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OICGEODA'),
        '141'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OICGEODA'),
        'variable beam bathymetry and amplitude, variable pixel sidescan, binary, Oceanic Imaging Consultants'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OICGEODA'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OICGEODA'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_OICMBARI', 'OIC-style extended swath sonar format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OICMBARI'),
        '142'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OICMBARI'),
        '142'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OICMBARI'),
        'variable beam bathymetry and amplitude, variable pixel sidescan, binary, MBARI'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OICMBARI'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OICMBARI'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_OMGHDCSJ', 'UNB OMG HDCS format (the John Hughes Clarke format)');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OMGHDCSJ'),
        '151'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OMGHDCSJ'),
        '151'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OMGHDCSJ'),
        'variable beam bathymetry and amplitude, variable pixel sidescan, binary, UNB'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OMGHDCSJ'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_OMGHDCSJ'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MGD77DAT', 'NGDC MGD77 underway geophysics format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MGD77DAT'),
        '161'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MGD77DAT'),
        '161'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MGD77DAT'),
        'single beam bathymetry, nav, magnetics, gravity, ascii, NOAA NGDC'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MGD77DAT'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MGD77DAT'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MBARIROV', 'MBARI ROV navigation format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBARIROV'),
        '165'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBARIROV'),
        '165'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBARIROV'),
        'ROV navigation, MBARI'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBARIROV'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBARIROV'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MBPRONAV', 'MB-System simple navigation format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBPRONAV'),
        '166'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBPRONAV'),
        '166'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBPRONAV'),
        'navigation, MBARI'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBPRONAV'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBPRONAV'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HS10JAMS', 'Furuno HS-10 multibeam format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HS10JAMS'),
        '171'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HS10JAMS'),
        '171'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HS10JAMS'),
        '45 beams bathymetry and amplitude, ascii, JAMSTEC'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HS10JAMS'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HS10JAMS'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSDS2RAW', 'STN Atlas raw multibeam format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSDS2RAW'),
        '182'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSDS2RAW'),
        '182'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSDS2RAW'),
        'STN Atlas multibeam sonars, Hydrosweep DS2, Hydrosweep MD, Fansweep 10, Fansweep 20, bathymetry, amplitude, and sidescan, up to 1440 beams and 4096 pixels, XDR binary, STN Atlas'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSDS2RAW'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSDS2RAW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSDS2LAM', 'L-DEO HSDS2 processing format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSDS2LAM'),
        '183'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSDS2LAM'),
        '183'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSDS2LAM'),
        'STN Atlas multibeam sonars, Hydrosweep DS2, Hydrosweep MD, Fansweep 10, Fansweep 20, bathymetry, amplitude, and sidescan, up to 1440 beams and 4096 pixels, XDR binary, L-DEO'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSDS2LAM'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSDS2LAM'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IMAGE_GEOTIFF', 'GeoTIFF survey image');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_GEOTIFF'),
        '2000'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_GEOTIFF'),
        'Data over the entire survey area is represented in full color.'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_GEOTIFF'),
        'Images'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_GEOTIFF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IMAGE_TFW', 'TIFF survey world file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_TFW'),
        '2001'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_TFW'),
        'The world file geospatially registers the corresponding TIFF image.'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_TFW'),
        'Images'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_TFW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IMAGE_JPEG', 'JPEG survey image');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_JPEG'),
        '2002'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_JPEG'),
        'Data over the entire survey area is represented in full color.'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_JPEG'),
        'Images'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_JPEG'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('SIO_MIF', 'Metadata I?? File for each individual data file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'SIO_MIF'),
        '3003'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'SIO_MIF'),
        'ASCII'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'SIO_MIF'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'SIO_MIF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_EM710RAW', 'Kongsberg multibeam vendor format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM710RAW'),
        '58'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM710RAW'),
        '58'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM710RAW'),
        'Kongsberg EM122, EM302, EM710, bathymetry, amplitude, and sidescan, up to 400 beams, variable pixels, binary, Kongsberg'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM710RAW'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM710RAW'),
        'ARCHIVE'
    );

-- insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSLDEOIH', 'same as 24');
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEOIH'),
--     '8'
-- );
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEOIH'),
--     'see 24'
-- );
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEOIH'),
--     'Bathymetry'
-- );
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSLDEOIH'),
--     'ARCHIVE'
-- );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('XYZ_SOURCE', 'xyz grid file provided by the originator');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XYZ_SOURCE'),
        '1005'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XYZ_SOURCE'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XYZ_SOURCE'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IMAGE_JPW', 'JPEG world reference file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_JPW'),
        '2003'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_JPW'),
        'Images'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_JPW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IMAGE_RRD', 'image pyramid file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_RRD'),
        '2004'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_RRD'),
        'Images'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_RRD'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IMAGE_AUX', 'image auxiliary file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_AUX'),
        '2005'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_AUX'),
        'Images'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_AUX'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('YXZ_SOURCE', 'yxz file provided by the originator');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'YXZ_SOURCE'),
        '1006'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'YXZ_SOURCE'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'YXZ_SOURCE'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('NOSEEZ', 'NOS EEZ metadata file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'NOSEEZ'),
        '3000'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'NOSEEZ'),
        'ASCII'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'NOSEEZ'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'NOSEEZ'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IMAGE_PS', 'Postscript');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_PS'),
        '2006'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_PS'),
        'Images'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_PS'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('DMC', 'ASCII Format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'DMC'),
        '997'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'DMC'),
        'ascii'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'DMC'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'DMC'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ASCII_MOSAIC', 'ASCII backscatter data');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_MOSAIC'),
        '1007'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_MOSAIC'),
        'ASCII backscatter data from multibeam sonars'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_MOSAIC'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_MOSAIC'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ASCII_TEXT', 'ASCII text product');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_TEXT'),
        '1008'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_TEXT'),
        'ASCII text product'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_TEXT'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_TEXT'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_ASCIIXYZ', 'Generic XYZ sounding format');
-- Note: Uses multiple system IDs
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYZ'),
        '162,996'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYZ'),
        '162'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYZ'),
        'XYZ (lon lat depth) ASCII soundings, generic'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYZ'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYZ'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('Unsupported', 'Not supported by MB-System');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Unsupported'),
        '999'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Unsupported'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Unsupported'),
        'ARCHIVE'
    );

-- insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSATLRAW', 'Raw Hydrosweep');
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSATLRAW'),
--     '5'
-- );
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSATLRAW'),
--     'Bathymetry'
-- );
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSATLRAW'),
--     'ARCHIVE'
-- );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('META_FILE_LEVEL', 'File level metadata');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_FILE_LEVEL'),
        '3006'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_FILE_LEVEL'),
        'Metadata files describing each multibeam data file'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_FILE_LEVEL'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_FILE_LEVEL'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MR1PRVR2', 'SOEST MR1 post processed format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1PRVR2'),
        '64'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1PRVR2'),
        '64'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1PRVR2'),
        'SOEST MR1, bathymetry and sidescan, variable beams and pixels, xdr binary, SOEST, University of Hawaii'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1PRVR2'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MR1PRVR2'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('META_PDF', 'PDF metadata file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_PDF'),
        '3004'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_PDF'),
        'Metadata files in PDF format, reports, summaries, cruise instructions'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_PDF'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_PDF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ANC_XBT', 'Expendable Bathythermograph (XBT) data');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_XBT'),
        '4001'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_XBT'),
        'Measurements collected with expendable bathythermograph probes'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_XBT'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_XBT'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ANC_CTD', 'Conductivity, Temperature, Depth (CTD) data');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_CTD'),
        '4002'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_CTD'),
        'Files associated with Conductivity, Temperature, and Depth package data'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_CTD'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_CTD'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('META_RTF', 'Metadata files in Rich Text Format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_RTF'),
        '3005'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_RTF'),
        'Metadata files in RTF format, documents, summaries'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_RTF'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_RTF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('WCD', 'Water column sonar data available');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'WCD'),
        '5001'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'WCD'),
        'Water Column Sonar Data collected for cruise'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'WCD'),
        'Water column'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_EM710MBA', 'Kongsberg multibeam vendor format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM710MBA'),
        '59'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM710MBA'),
        '59'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM710MBA'),
        'Kongsberg EM122, EM302, EM710, bathymetry, amplitude, and sidescan, up to 400 beams, variable pixels, binary, Simrad'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM710MBA'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EM710MBA'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ANC_TIDE', 'Tidal data');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_TIDE'),
        '4004'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_TIDE'),
        'Tidal data for application of tidal offsets to multibeam data'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_TIDE'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_TIDE'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MS Word 2000', 'Data report or metadata in Word document format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS Word 2000'),
        '3008'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS Word 2000'),
        'Data Report or Metadata in DOCX format'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS Word 2000'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS Word 2000'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('GOOGLE_KMZ', 'Compressed Keyhole Markup Language file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GOOGLE_KMZ'),
        '2012'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GOOGLE_KMZ'),
        'Compressed Keyhole Markup Language file for display in Google Earth or other geospatial software'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GOOGLE_KMZ'),
        'Geometry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GOOGLE_KMZ'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_RESON7KR', 'Reson S7K multibeam vendor format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_RESON7KR'),
        '88'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_RESON7KR'),
        '88'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_RESON7KR'),
        'Reson 7K series multibeam sonars, bathymetry, amplitude, three channels sidescan, and subbottom up to 254 beams, variable pixels, binary, Reson'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_RESON7KR'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_RESON7KR'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('do_not_process', 'files	Data Not Processed');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'do_not_process'),
        '4007'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'do_not_process'),
        'Data Not Processed'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'do_not_process'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'do_not_process'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('BagIt info files', 'BagIt File (includes checksum manifest)');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'BagIt info files'),
        '4008'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'BagIt info files'),
        'BagIt Information File'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'BagIt info files'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'BagIt info files'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MS Word', 'Data report or metadata in Word document format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS Word'),
        '3007'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS Word'),
        'Data Report or Metadata in DOC format'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS Word'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS Word'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_ASCIIXYT', 'Generic XYT sounding format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYT'),
        '168'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYT'),
        '168'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYT'),
        'XYT (lon lat topography) ASCII soundings, generic'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYT'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYT'),
        'ARCHIVE'
    );

-- insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_ASCIIXYZ', 'Generic XYZ sounding format');
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYZ'),
--     '162'
-- );
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYZ'),
--     'XYZ (lon, lat, depth) ASCII soundings, generic'
-- );
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYZ'),
--     'Bathymetry'
-- );
-- insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
-- (
--     (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
--     (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIXYZ'),
--     'ARCHIVE'
-- );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_ASCIIYXZ', 'Generic YXZ sounding format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIYXZ'),
        '163'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIYXZ'),
        '163'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIYXZ'),
        'YXZ (lat, lon, depth) ASCII soundings, generic'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIYXZ'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIYXZ'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MS_XLS', 'Provider supplied metadata');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS_XLS'),
        '3027'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS_XLS'),
        'Provider supplied metadata in Microsoft Excel 97/2000/XP/2003 format'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS_XLS'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS_XLS'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MS_XLSX', 'Provider supplied metadata');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS_XLSX'),
        '3028'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS_XLSX'),
        'Provider supplied metadata in Microsoft Excel 2007/2010 format'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS_XLSX'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MS_XLSX'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('GZ_BAG', 'Compressed Bathymetric Attributed Grid file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_BAG'),
        '2020'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_BAG'),
        'Compressed BAG file'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_BAG'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_BAG'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('META_REPORT', 'Reports and Logs from cruise');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_REPORT'),
        '3017'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_REPORT'),
        'Archive of cruise reports, logs, project instructions'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_REPORT'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_REPORT'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MB_TAR', 'Tar archive of unsupported MB data');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MB_TAR'),
        '998'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MB_TAR'),
        'Tar archive of sonar data files in a format not supported by MB-System'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MB_TAR'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MB_TAR'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('GZ_XYZ_SOURCE', 'GZIP XYZ grid file provided by the originator');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_XYZ_SOURCE'),
        '1015'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_XYZ_SOURCE'),
        'Compressed XYZ file'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_XYZ_SOURCE'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_XYZ_SOURCE'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('.sxp', 'Processed Interferometric Sonar file .sxp');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '.sxp'),
        '222'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '.sxp'),
        '222'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '.sxp'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '.sxp'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('.sxr', 'raw interferometric sonar file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '.sxr'),
        '901'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '.sxr'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '.sxr'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('GOOGLE_KML', 'Keyhole Markup Language file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GOOGLE_KML'),
        '2022'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GOOGLE_KML'),
        'Keyhole Markup Language file for display in Google Earth or other geospatial software'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GOOGLE_KML'),
        'Geometry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GOOGLE_KML'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ANC_SHP', 'Shapefile data');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SHP'),
        '4010'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SHP'),
        'ESRI Shapefile format providing geospatial vector data for GIS software'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SHP'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ANC_SHP'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('META_HTML', 'HTML metadata file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_HTML'),
        '3010'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_HTML'),
        'Metadata records in HTML or HTM format'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_HTML'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'META_HTML'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ESRI_ARCGRID', 'ESRI Arc/INFO grid');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ESRI_ARCGRID'),
        '2039'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ESRI_ARCGRID'),
        'ESRI Arc grid files'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ESRI_ARCGRID'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ESRI_ARCGRID'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('GZ_SD', 'Compressed Fledermaus surface');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_SD'),
        '2018'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_SD'),
        'Compressed Fledermaus surface'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_SD'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_SD'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('GZ_ASC', 'Compressed ESRI Arc ASCII');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_ASC'),
        '2019'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_ASC'),
        'Compressed ESRI Arc ASCII'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_ASC'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GZ_ASC'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('PRODUCT_XML', 'Product Specific Metadata');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PRODUCT_XML'),
        '2099'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PRODUCT_XML'),
        'Product Specific Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PRODUCT_XML'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PRODUCT_XML'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ASCII_XYB', 'Generic XYB backscatter format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_XYB'),
        '962'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_XYB'),
        'XYB (lon, lat, backscatter) ASCII data, generic'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_XYB'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ASCII_XYB'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('Singlebeam', 'Singlebeam data available by request');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Singlebeam'),
        '5003'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Singlebeam'),
        'Singlebeam Sonar Data collected for cruise'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Singlebeam'),
        'Water column'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('Sidescan', 'Sidescan or Backscatter data available by request');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Sidescan'),
        '5004'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Sidescan'),
        'Sidescan or Backscatter Sonar Data collected for cruise'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Sidescan'),
        'Sidescan'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_CARIS', 'Caris project data files');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CARIS'),
        '900'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CARIS'),
        'Caris project files'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CARIS'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_CARIS'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('INFO_TAR', 'Additional cruise information');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'INFO_TAR'),
        '3009'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'INFO_TAR'),
        'Archive of additional cruise information, xml, txt, htm, reports, summaries'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'INFO_TAR'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'INFO_TAR'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('7K', 'Reson snippet data');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '7K'),
        '990'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '7K'),
        'Reson snippet (footprint amplitude time series) data in Hypack acquired .7K file format'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '7K'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '7K'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('PROD_TRKLNE', 'Trackline files');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PROD_TRKLNE'),
        '2032'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PROD_TRKLNE'),
        'Trackline data represented in a geospatial format'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PROD_TRKLNE'),
        'Geometry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PROD_TRKLNE'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HYDROB93', 'NGDC binary hydrographic sounding format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYDROB93'),
        '164'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYDROB93'),
        '164'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYDROB93'),
        'XYZ (lon lat depth) binary soundings'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYDROB93'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYDROB93'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IVS_SCENE', 'Fledermaus Scene file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IVS_SCENE'),
        '2031'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IVS_SCENE'),
        'Fledermaus Scene File'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IVS_SCENE'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IVS_SCENE'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('ADD_PROD', 'Additional Products');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ADD_PROD'),
        '2058'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ADD_PROD'),
        'Bundle of additional products not associated with usual product formats'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ADD_PROD'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'ADD_PROD'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('.pds	native', 'PDS2000');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '.pds	native'),
        '902'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = '.pds	native'),
        'native format for PDS2000'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('Ancillary_Data', 'Ancillary Data Files');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Ancillary_Data'),
        '4012'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'Ancillary_Data'),
        'Ancillary data for Cruise'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('BISTs', 'BISTs data files');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'BISTs'),
        '4011'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'BISTs'),
        'BISTs data files'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('XML', 'NCEI created ISO metadata');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XML'),
        '3011'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XML'),
        'ISO standard XML metadata generated during data ingest'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XML'),
        'Metadata'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XML'),
        'HTTP'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('gzip text product', 'GZIP Text Product');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'gzip text product'),
        '1018'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'gzip text product'),
        'text product'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'gzip text product'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'gzip text product'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('IMAGE_TIFF_TFW', 'Compressed TIFF and TFW');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_TIFF_TFW'),
        '2013'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_TIFF_TFW'),
        'TIFF image and support files'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_TIFF_TFW'),
        'Images'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'IMAGE_TIFF_TFW'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HYSWEEP1', 'HYSWEEP multibeam data format');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYSWEEP1'),
        '201'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYSWEEP1'),
        '201'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYSWEEP1'),
        'Many multibeam sonars, bathymetry, amplitude variable beams, ascii, HYPACK'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYSWEEP1'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HYSWEEP1'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('PLATFORM_CONFIG', 'Platform Configuration files');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PLATFORM_CONFIG'),
        '4009'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PLATFORM_CONFIG'),
        'Platform Configuration Files'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PLATFORM_CONFIG'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'PLATFORM_CONFIG'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('XTF', 'XTF formatted bathymetry');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XTF'),
        '909'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XTF'),
        'Bathymetry files acquired in XTF format (through programs such as Triton ISIS or QPS QINSy). Not supported by MB-System.'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XTF'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'XTF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('s7k', 'Backscatter Support Data');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_FILE_FORMAT_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 's7k'),
        '991'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 's7k'),
        'Backscatter Support Data'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 's7k'),
        'Bathymetry'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 's7k'),
        'ARCHIVE'
    );


insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MD5', 'MD5 checksum');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MD5'),
        'MD5 checksum'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MD5'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MD5'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('SHA256', 'SHA256 checksum');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'SHA256'),
        'SHA256 checksum'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'SHA256'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'SHA256'),
        'ARCHIVE'
    );


insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('FNV', 'MB-System fast navigation file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'FNV'),
        'MB-System fast navigation file'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'FNV'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'FNV'),
        'ARCHIVE'
    );


insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('INF', 'MB-System statistics file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'INF'),
        'MB-System statistics file'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'INF'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'INF'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('FBT', 'MB-System fast bathymetry file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'FBT'),
        'MB-System fast bathymetry file'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'FBT'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'FBT'),
        'ARCHIVE'
    );


insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('GEOJSON', 'GeoJSON file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GEOJSON'),
        'GeoJSON file'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GEOJSON'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'GEOJSON'),
        'ARCHIVE'
    );


insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('WKT', 'Well known text file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'WKT'),
        'WKT file'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'WKT'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'WKT'),
        'ARCHIVE'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('HTML', 'HTML file');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_ATTRIBUTES'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'HTML'),
        'HTML file'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_TYPE'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'HTML'),
        'Supporting'
    );
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'FILE_FORMAT_PROTOCOL'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'HTML'),
        'ARCHIVE'
    );





insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HSUNKNWN', 'MBF_HSUNKNWN');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HSUNKNWN'),
        '26'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MBNETCDF', 'MBF_MBNETCDF');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBNETCDF'),
        '75'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_EDGJSTAR', 'MBF_EDGJSTAR');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EDGJSTAR'),
        '132'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_EDGJSTR2', 'MBF_EDGJSTR2');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_EDGJSTR2'),
        '133'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SEGYSEGY', 'MBF_SEGYSEGY');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SEGYSEGY'),
        '160'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_NVNETCDF', 'MBF_NVNETCDF');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_NVNETCDF'),
        '167'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_ASCIIYXT', 'MBF_ASCIIYXT');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_ASCIIYXT'),
        '169'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MBARROV2', 'MBF_MBARROV2');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBARROV2'),
        '170'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_HIR2RNAV', 'MBF_HIR2RNAV');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_HIR2RNAV'),
        '172'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MGD77TXT', 'MBF_MGD77TXT');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MGD77TXT'),
        '173'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MGD77TAB', 'MBF_MGD77TAB');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MGD77TAB'),
        '174'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SAMESURF', 'MBF_SAMESURF');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SAMESURF'),
        '181'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_IMAGE83P', 'MBF_IMAGE83P');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_IMAGE83P'),
        '191'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_IMAGEMBA', 'MBF_IMAGEMBA');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_IMAGEMBA'),
        '192'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_XTFB1624', 'MBF_XTFB1624');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_XTFB1624'),
        '211'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_SWPLSSXI', 'MBF_SWPLSSXI');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_SWPLSSXI'),
        '221'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_3DDEPTHP', 'MBF_3DDEPTHP');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_3DDEPTHP'),
        '231'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_3DWISSLR', 'MBF_3DWISSLR');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_3DWISSLR'),
        '232'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_3DWISSLP', 'MBF_3DWISSLP');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_3DWISSLP'),
        '233'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_WASSPENL', 'MBF_WASSPENL');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_WASSPENL'),
        '241'
    );


insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_PHOTGRAM', 'MBF_PHOTGRAM');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_PHOTGRAM'),
        '251'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_KEMKMALL', 'MBF_KEMKMALL');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_KEMKMALL'),
        '261'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MBARIMB1', 'MBF_MBARIMB1');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBARIMB1'),
        '72'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_MBNCDFXT', 'MBF_MBNCDFXT');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_MBNCDFXT'),
        '76'
    );

insert into FILE_FORMATS (FORMAT_NAME, FORMAT_DESCRIPTION) VALUES ('MBF_RESON7K3', 'MBF_RESON7K3');
insert into FILE_FORMAT_PARAMETERS (PARAMETER_DETAIL_ID, FILE_FORMAT_ID, VALUE) VALUES
    (
        (select PARAMETER_ID from PARAMETER_DETAILS where PARAMETER = 'MB_SYSTEM_ID'),
        (select FORMAT_ID from FILE_FORMATS where FORMAT_NAME = 'MBF_RESON7K3'),
        '89'
    );


insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('MB RAW', 'Raw MB data - Raw instrument and associated files');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('MB PROCESSED', 'Processed MB data');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('MB PRODUCT', 'Product MB data');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('MB RAW NONPUBLIC', 'Non-public raw MB data - Raw instrument and associated files');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('MB PROCESSED NONPUBLIC', 'Non-public processed MB data');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('MB PRODUCT NONPUBLIC', 'Non-public product MB data');

insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('ANCILLARY', 'Ancillary data');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('DOCUMENT', 'Documents');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('METADATA', 'Metadata');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('ANCILLARY NONPUBLIC', 'Non-public ancillary data');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('DOCUMENT NONPUBLIC', 'Non-public documents');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('METADATA NONPUBLIC', 'Non-public metadata');

insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('WCSD Raw', 'Raw water column data');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('WCSD Processed', 'Processed water column data');
insert into DATASET_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('WCSD Product', 'Product water column data');


insert into VERSION_DESCRIPTIONS (VERSION_NUMBER, DESCRIPTION) VALUES (1, 'RAW');
insert into VERSION_DESCRIPTIONS (VERSION_NUMBER, DESCRIPTION) VALUES (2, 'PROCESSED');
insert into VERSION_DESCRIPTIONS (VERSION_NUMBER, DESCRIPTION) VALUES (3, 'PRODUCT');
insert into VERSION_DESCRIPTIONS (VERSION_NUMBER, DESCRIPTION) VALUES (1, 'ANCILLARY');
insert into VERSION_DESCRIPTIONS (VERSION_NUMBER, DESCRIPTION) VALUES (1, 'DOCUMENT');
insert into VERSION_DESCRIPTIONS (VERSION_NUMBER, DESCRIPTION) VALUES (1, 'METADATA');


insert into FILE_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('MB RAW', 'Raw multibeam data file');
insert into FILE_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('MB PROCESSED', 'Processed multibeam data file');
insert into FILE_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('MB PRODUCT', 'Product multibeam data file');
insert into FILE_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('ANCILLARY', 'Ancillary file');
insert into FILE_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('DOCUMENT', 'Document file');
insert into FILE_TYPES (TYPE_NAME, TYPE_DESCRIPTION) VALUES ('METADATA', 'Metadata file');





exit;
