# coding: utf-8

"""
    aind-tars-service

     ## aind-tars-service  Service to pull data from TARS.  

    The version of the OpenAPI document: 0.1.3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aind_tars_service_client.models.viral_prep_type import ViralPrepType
from aind_tars_service_client.models.virus_data import VirusData
from typing import Optional, Set
from typing_extensions import Self

class ViralPrep(BaseModel):
    """
    ViralPrep
    """ # noqa: E501
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    id: Optional[StrictStr] = None
    rr_id: Optional[StrictStr] = Field(default=None, alias="rrId")
    viral_prep_type: Optional[ViralPrepType] = Field(default=None, alias="viralPrepType")
    virus: Optional[VirusData] = None
    citations: Optional[List[Any]] = None
    shipments: Optional[List[Any]] = None
    patents: Optional[List[Any]] = None
    material_transfer_agreements: Optional[List[Any]] = Field(default=None, alias="materialTransferAgreements")
    qc_certification_files: Optional[List[Any]] = Field(default=None, alias="qcCertificationFiles")
    serotypes: Optional[List[Any]] = None
    __properties: ClassVar[List[str]] = ["createdAt", "updatedAt", "createdBy", "updatedBy", "id", "rrId", "viralPrepType", "virus", "citations", "shipments", "patents", "materialTransferAgreements", "qcCertificationFiles", "serotypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ViralPrep from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of viral_prep_type
        if self.viral_prep_type:
            _dict['viralPrepType'] = self.viral_prep_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of virus
        if self.virus:
            _dict['virus'] = self.virus.to_dict()
        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['createdAt'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updatedAt'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['createdBy'] = None

        # set to None if updated_by (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by is None and "updated_by" in self.model_fields_set:
            _dict['updatedBy'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if rr_id (nullable) is None
        # and model_fields_set contains the field
        if self.rr_id is None and "rr_id" in self.model_fields_set:
            _dict['rrId'] = None

        # set to None if viral_prep_type (nullable) is None
        # and model_fields_set contains the field
        if self.viral_prep_type is None and "viral_prep_type" in self.model_fields_set:
            _dict['viralPrepType'] = None

        # set to None if virus (nullable) is None
        # and model_fields_set contains the field
        if self.virus is None and "virus" in self.model_fields_set:
            _dict['virus'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ViralPrep from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "createdBy": obj.get("createdBy"),
            "updatedBy": obj.get("updatedBy"),
            "id": obj.get("id"),
            "rrId": obj.get("rrId"),
            "viralPrepType": ViralPrepType.from_dict(obj["viralPrepType"]) if obj.get("viralPrepType") is not None else None,
            "virus": VirusData.from_dict(obj["virus"]) if obj.get("virus") is not None else None,
            "citations": obj.get("citations"),
            "shipments": obj.get("shipments"),
            "patents": obj.get("patents"),
            "materialTransferAgreements": obj.get("materialTransferAgreements"),
            "qcCertificationFiles": obj.get("qcCertificationFiles"),
            "serotypes": obj.get("serotypes")
        })
        return _obj


