"""Python setup.py for idupes package"""
import io
import os
from setuptools import find_packages, setup
from pathlib import Path

def read(*paths, **kwargs):
    """Read the contents of a text file safely.
    >>> read("idupes", "VERSION")
    '0.1.0'
    >>> read("README.md")
    ...
    """

    content = ""
    with io.open(
        os.path.join(os.path.dirname(__file__), *paths),
        encoding=kwargs.get("encoding", "utf8"),
    ) as open_file:
        content = open_file.read().strip()
    return content


def read_requirements(path):
    return [
            line.strip()
            for line in read(path).split("\n")
            if not line.startswith(('"', "#", "-", "git+"))
        ]

deps = [
    "imagehash",
    "scikit-learn>=1.2.2",
    "joblib",
    "scipy>=1.10.1"
]


setup(
    name="idupes",
    version=read("idupes", "VERSION"),
    description="Awesome idupes created by jimmysue",
    url="https://github.com/jimmysue/idupes/",
    long_description=read("README.md"),
    long_description_content_type="text/markdown",
    author="jimmysue",
    packages=find_packages(exclude=["tests", ".github"]),
    install_requires=deps,
    entry_points={
        "console_scripts": ["idupes = idupes.__main__:main"]
    }
)
