"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnEipEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const _util_1 = require("./_util");
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint.
 *
 * @stability stable
 */
class CfnEipEndpoint {
    /**
     * @stability stable
     */
    constructor(eip, options = {}) {
        this.eip = eip;
        this.options = options;
        _util_1.validateWeight(options.weight);
        this.region = core_1.Stack.of(eip).region;
    }
    /**
     * Render the endpoint to an endpoint configuration.
     *
     * @stability stable
     */
    renderEndpointConfiguration() {
        return {
            endpointId: this.eip.attrAllocationId,
            weight: this.options.weight,
        };
    }
}
exports.CfnEipEndpoint = CfnEipEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CfnEipEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator-endpoints.CfnEipEndpoint", version: "1.114.0" };
//# sourceMappingURL=data:application/json;base64,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