"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkLoadBalancerEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use a Network Load Balancer as a Global Accelerator Endpoint.
 *
 * @stability stable
 */
class NetworkLoadBalancerEndpoint {
    /**
     * @stability stable
     */
    constructor(loadBalancer, options = {}) {
        this.loadBalancer = loadBalancer;
        this.options = options;
        _util_1.validateWeight(options.weight);
        this.region = loadBalancer.env.region;
    }
    /**
     * Render the endpoint to an endpoint configuration.
     *
     * @stability stable
     */
    renderEndpointConfiguration() {
        return {
            endpointId: this.loadBalancer.loadBalancerArn,
            weight: this.options.weight,
        };
    }
}
exports.NetworkLoadBalancerEndpoint = NetworkLoadBalancerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
NetworkLoadBalancerEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator-endpoints.NetworkLoadBalancerEndpoint", version: "1.114.0" };
//# sourceMappingURL=data:application/json;base64,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