"use strict";
/// !cdk-integ canary-one
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const synthetics = require("../lib");
/*
 * Stack verification steps:
 *
 * -- aws synthetics get-canary --name canary-one has a state of 'RUNNING'
 */
const app = new cdk.App();
const stack = new cdk.Stack(app, 'canary-one');
const bucket = new s3.Bucket(stack, 'mytestbucket');
const prefix = 'integ';
new synthetics.Canary(stack, 'MyCanary', {
    canaryName: 'canary-integ',
    test: synthetics.Test.custom({
        handler: 'index.handler',
        code: synthetics.Code.fromInline(`
      exports.handler = async () => {
        console.log(\'hello world\');
      };`),
    }),
    schedule: synthetics.Schedule.rate(cdk.Duration.minutes(1)),
    artifactsBucketLocation: { bucket, prefix },
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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