"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const synthetics = require("../lib");
test('.metricXxx() methods can be used to obtain Metrics for the canary', () => {
    // GIVEN
    const stack = new core_1.Stack(new core_1.App(), 'canaries');
    const canary = new synthetics.Canary(stack, 'mycanary', {
        test: synthetics.Test.custom({
            handler: 'index.handler',
            code: synthetics.Code.fromInline('foo'),
        }),
    });
    // WHEN
    const metricSuccess = canary.metricSuccessPercent();
    const metricFailed = canary.metricFailed();
    const metricDuration = canary.metricDuration();
    // THEN
    expect(metricSuccess).toEqual(expect.objectContaining({
        dimensions: { CanaryName: canary.canaryName },
        namespace: 'CloudWatchSynthetics',
        metricName: 'SuccessPercent',
        statistic: 'Average',
    }));
    expect(metricFailed).toEqual(expect.objectContaining({
        dimensions: { CanaryName: canary.canaryName },
        namespace: 'CloudWatchSynthetics',
        metricName: 'Failed',
        statistic: 'Average',
    }));
    expect(metricDuration).toEqual(expect.objectContaining({
        dimensions: { CanaryName: canary.canaryName },
        namespace: 'CloudWatchSynthetics',
        metricName: 'Duration',
        statistic: 'Average',
    }));
});
test('Metric can specify statistic', () => {
    // GIVEN
    const stack = new core_1.Stack(new core_1.App(), 'canaries');
    const canary = new synthetics.Canary(stack, 'mycanary', {
        test: synthetics.Test.custom({
            handler: 'index.handler',
            code: synthetics.Code.fromInline('foo'),
        }),
    });
    // WHEN
    const metric = canary.metricFailed({ statistic: 'Sum' });
    // THEN
    expect(metric).toEqual(expect.objectContaining({
        dimensions: { CanaryName: canary.canaryName },
        namespace: 'CloudWatchSynthetics',
        metricName: 'Failed',
        statistic: 'Sum',
    }));
});
//# sourceMappingURL=data:application/json;base64,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